/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.awt.event.KeyEvent;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.util.NodeArray;

public class KeyDeviceSensorManager {
    private static final int DEFAULT_LISTENER_SIZE = 10;
    private static final int LISTENER_SIZE_INC = 5;
    private ErrorReporter errorReporter;
    private HashSet keyNodes = new HashSet();
    private NodeArray sensors = new NodeArray();

    public KeyDeviceSensorManager() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void clear() {
        this.keyNodes.clear();
    }

    public void sendEvents(KeyEvent[] keyEventArray, int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.sensors.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType = (VRMLKeyDeviceSensorNodeType)this.sensors.get(i);
            if (!vRMLKeyDeviceSensorNodeType.getEnabled()) continue;
            for (int j = n3 = vRMLKeyDeviceSensorNodeType.requiresLastEventOnly() ? n - 1 : 0; j < n; ++j) {
                this.sendEvent(vRMLKeyDeviceSensorNodeType, keyEventArray[j]);
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void addSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (!this.keyNodes.contains(vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.add(vRMLKeyDeviceSensorNodeType);
            this.sensors.add(vRMLKeyDeviceSensorNodeType);
        }
    }

    public void removeSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (this.keyNodes.contains(vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.remove(vRMLKeyDeviceSensorNodeType);
            this.sensors.remove(vRMLKeyDeviceSensorNodeType);
        }
    }

    private void sendEvent(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType, KeyEvent keyEvent) {
        try {
            switch (keyEvent.getID()) {
                case 401: {
                    vRMLKeyDeviceSensorNodeType.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    vRMLKeyDeviceSensorNodeType.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    vRMLKeyDeviceSensorNodeType.keyTyped(keyEvent);
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Error propogating key event", exception);
        }
    }
}

