/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.runtime.EventOutHolder;
import org.web3d.vrml.nodes.runtime.RouteHolder;
import org.web3d.vrml.nodes.runtime.Router;

public class ListsRouter
implements Router {
    private static final int DEFAULT_SIZE = 32;
    private static final int ARRAY_INC = 8;
    private HashSet routeSet = new HashSet();
    private HashSet routesToAdd = new HashSet();
    private HashSet routesToRemove = new HashSet();
    private int sourceCount = 0;
    private HashMap sourceMap = new HashMap();
    private EventOutHolder[] routeList = new EventOutHolder[32];
    private ErrorReporter errorReporter;
    private RouteHolder[] routeTmp = new RouteHolder[32];

    public ListsRouter() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean processRoutes(double d) {
        if (this.sourceCount <= 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.sourceCount; ++i) {
            if (!this.routeList[i].needsProcessing()) continue;
            ArrayList arrayList = (ArrayList)this.sourceMap.get(this.routeList[i]);
            int n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                RouteHolder routeHolder = (RouteHolder)arrayList.get(j);
                routeHolder.sendRoute(d);
            }
            bl = true;
        }
        return bl;
    }

    public void addRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (this.routeSet.contains(routeHolder) || this.routesToAdd.contains(routeHolder)) {
            return;
        }
        if (this.routesToRemove.contains(routeHolder)) {
            this.routesToRemove.remove(routeHolder);
            return;
        }
        this.routesToAdd.add(routeHolder);
    }

    public void addRoutes(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ROUTE rOUTE = (ROUTE)arrayList.get(i);
            this.addRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
        }
    }

    public void removeRoute(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        RouteHolder routeHolder = new RouteHolder();
        routeHolder.srcNode = vRMLNodeType;
        routeHolder.srcIndex = n;
        routeHolder.destNode = vRMLNodeType2;
        routeHolder.destIndex = n2;
        if (!this.routeSet.contains(routeHolder) || this.routesToRemove.contains(routeHolder)) {
            return;
        }
        if (this.routesToAdd.contains(routeHolder)) {
            this.routesToAdd.remove(routeHolder);
            return;
        }
        this.routesToRemove.add(routeHolder);
    }

    public void updateRoutes() {
        Object object;
        ArrayList arrayList;
        RouteHolder routeHolder;
        int n;
        if (this.routesToRemove.size() == 0 && this.routesToAdd.size() == 0) {
            return;
        }
        this.routeSet.removeAll(this.routesToRemove);
        this.routeSet.addAll(this.routesToAdd);
        int n2 = this.routesToRemove.size();
        if (this.routeTmp.length < n2) {
            int n3 = n2 >= this.routeTmp.length + 8 ? n2 : this.routeTmp.length + 8;
            this.routeTmp = new RouteHolder[n3];
        }
        this.routesToRemove.toArray(this.routeTmp);
        EventOutHolder eventOutHolder = new EventOutHolder();
        for (n = 0; n < n2; ++n) {
            routeHolder = this.routeTmp[n];
            this.routeTmp[n] = null;
            eventOutHolder.srcNode = routeHolder.srcNode;
            eventOutHolder.srcIndex = routeHolder.srcIndex;
            arrayList = (ArrayList)this.sourceMap.get(eventOutHolder);
            if (arrayList == null) continue;
            arrayList.remove(routeHolder);
        }
        n2 = this.routesToAdd.size();
        if (this.routeTmp.length < n2) {
            n = n2 >= this.routeTmp.length + 8 ? n2 : this.routeTmp.length + 8;
            this.routeTmp = new RouteHolder[n];
        }
        this.routesToAdd.toArray(this.routeTmp);
        for (n = 0; n < n2; ++n) {
            routeHolder = this.routeTmp[n];
            this.routeTmp[n] = null;
            eventOutHolder.srcNode = routeHolder.srcNode;
            eventOutHolder.srcIndex = routeHolder.srcIndex;
            arrayList = (ArrayList)this.sourceMap.get(eventOutHolder);
            if (arrayList == null) {
                arrayList = new ArrayList();
                object = new EventOutHolder();
                object.srcNode = routeHolder.srcNode;
                object.srcIndex = routeHolder.srcIndex;
                this.sourceMap.put(object, arrayList);
            }
            arrayList.add(routeHolder);
        }
        this.sourceCount = this.sourceMap.size();
        if (this.sourceCount > this.routeList.length) {
            n = this.routeList.length;
            int n4 = n2 >= this.routeTmp.length + 8 ? n2 : this.routeTmp.length + 8;
            object = new EventOutHolder[n4];
            System.arraycopy(this.routeList, 0, object, 0, n);
            this.routeList = object;
        }
        Set set = this.sourceMap.keySet();
        set.toArray(this.routeList);
        this.routesToAdd.clear();
        this.routesToRemove.clear();
    }

    public void clear() {
        this.routeSet.clear();
        this.routesToAdd.clear();
        this.routesToRemove.clear();
        this.sourceMap.clear();
        for (int i = 0; i < this.sourceCount; ++i) {
            this.routeList[i] = null;
        }
        this.sourceCount = 0;
    }
}

