/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ais;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.plugins.ais.AisOverlay;
import pt.lsts.neptus.plugins.ais.AisShip;
import pt.lsts.neptus.types.coord.LocationType;

public class AisDataFetcher {
    protected LocationType sw;
    protected LocationType ne;
    protected double gridSizeMeters;
    protected long[][] ships;
    protected AisOverlay overlay = new AisOverlay(null);
    protected LinkedHashMap<String, LocationType> lastShips = new LinkedHashMap();

    public AisDataFetcher(double minLat, double maxLat, double minLon, double maxLon, double gridSize) {
        this.gridSizeMeters = gridSize;
        this.sw = new LocationType(minLat, minLon);
        this.ne = new LocationType(maxLat, maxLon);
        double[] offsets = this.ne.getOffsetFrom(this.sw);
        System.out.println("Latitude,Longitude,Ships");
        this.ships = new long[(int)(offsets[1] / gridSize)][(int)(offsets[0] / gridSize)];
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AisDataFetcher.this.writeFile("output.csv");
                System.out.println("wrote file");
            }
        });
    }

    public void writeFile(String filename) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(filename)));
            bw.write("latitude,longitude,ships\n");
            for (int i = 0; i < this.ships.length; ++i) {
                for (int j = 0; j < this.ships[i].length; ++j) {
                    if (this.ships[i][j] == 0L) continue;
                    LocationType loc = new LocationType(this.sw);
                    loc.translatePosition(this.gridSizeMeters * (double)i, this.gridSizeMeters * (double)j, 0.0);
                    loc.convertToAbsoluteLatLonDepth();
                    bw.write(loc.getLatitudeDegs() + "," + loc.getLongitudeDegs() + "," + this.ships[i][j] + "\n");
                }
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void incShip(double lat, double lon) {
        double[] offsets = new LocationType(lat, lon).getOffsetFrom(this.sw);
        long[] lArray = this.ships[(int)(offsets[1] / this.gridSizeMeters)];
        int n = (int)(offsets[0] / this.gridSizeMeters);
        lArray[n] = lArray[n] + 1L;
    }

    public void fetchShips() {
        Vector<AisShip> ships = this.overlay.getShips(this.sw.getLatitudeDegs(), this.sw.getLongitudeDegs(), this.ne.getLatitudeDegs(), this.ne.getLongitudeDegs(), false);
        LinkedHashMap<String, LocationType> newShips = new LinkedHashMap<String, LocationType>();
        for (AisShip s : ships) {
            LocationType newLoc = s.getLocation();
            newShips.put(s.getName(), newLoc);
            LocationType prevPosition = this.lastShips.get(s.getName());
            if (prevPosition == null || prevPosition.getLatitudeDegs() == s.getLatitude()) continue;
            double dist = prevPosition.getDistanceInMeters(newLoc);
            double[] offsets = newLoc.getOffsetFrom(prevPosition);
            double points = dist / this.gridSizeMeters;
            double curDist = 0.0;
            double x = 0.0;
            double y = 0.0;
            while (curDist <= dist) {
                LocationType loc = new LocationType(prevPosition);
                loc.translatePosition(x, y, 0.0);
                loc.convertToAbsoluteLatLonDepth();
                this.incShip(loc.getLatitudeDegs(), loc.getLongitudeDegs());
                System.out.println(loc.getLatitudeDegs() + "," + loc.getLongitudeDegs() + "," + 1);
                curDist += this.gridSizeMeters;
                x += offsets[0] / points;
                y += offsets[1] / points;
            }
        }
        this.lastShips = newShips;
    }

    public static void main(String[] args) throws Exception {
        AisDataFetcher fetcher = new AisDataFetcher(36.4789, 36.5601, -6.3439, -6.1676, 10.0);
        long millisBetweenUpdates = 60000L;
        long count = 0L;
        fetcher.fetchShips();
        while (true) {
            Thread.sleep(1000L);
            if ((count += 1000L) <= millisBetweenUpdates) continue;
            fetcher.fetchShips();
            count = 0L;
        }
    }
}

