/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ais;

import com.google.gson.Gson;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.planeditor.IEditorMenuExtension;
import pt.lsts.neptus.planeditor.IMapPopup;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.ais.AisShip;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(author="ZP", name="AIS Overlay", icon="pt/lsts/neptus/plugins/ais/mt.png")
@LayerPriority(priority=-50)
public class AisOverlay
extends SimpleRendererInteraction
implements IPeriodicUpdates,
IEditorMenuExtension {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Show vessel names")
    public boolean showNames = true;
    @NeptusProperty(name="Show vessel speeds")
    public boolean showSpeeds = true;
    @NeptusProperty(name="Milliseconds between vessel updates")
    public long updateMillis = 60000L;
    @NeptusProperty(name="Show only when selected")
    public boolean showOnlyWhenInteractionIsActive = true;
    @NeptusProperty(name="Show stationary vessels")
    public boolean showStoppedShips = false;
    @NeptusProperty(name="Interpolate and predict positions")
    public boolean interpolate = false;
    @NeptusProperty(name="Moving vessel color")
    public Color movingColor = Color.blue.darker();
    @NeptusProperty(name="Stationary vessel color")
    public Color stationaryColor = Color.gray.darker();
    @NeptusProperty(name="Vessel label color")
    public Color labelColor = Color.black;
    @NeptusProperty(name="Show speed in knots")
    public boolean useKnots = false;
    protected boolean active = false;
    protected Vector<AisShip> shipsOnMap = new Vector();
    protected StateRenderer2D renderer = null;
    protected boolean updating = false;
    protected Thread lastThread = null;
    protected GeneralPath path = new GeneralPath();
    private HttpClient client;
    private Gson gson;

    public AisOverlay(ConsoleLayout console) {
        super(console);
        this.path.moveTo(0.0f, 5.0f);
        this.path.lineTo(-5.0, 3.5);
        this.path.lineTo(-5.0f, -5.0f);
        this.path.lineTo(5.0f, -5.0f);
        this.path.lineTo(5.0, 3.5);
        this.path.lineTo(0.0f, 5.0f);
        this.path.closePath();
        this.client = new HttpClient();
        this.gson = new Gson();
    }

    public boolean isExclusive() {
        return true;
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        super.setActive(mode, source);
        this.active = mode;
        if (this.active) {
            this.update();
        }
    }

    public long millisBetweenUpdates() {
        return this.updateMillis;
    }

    public boolean update() {
        if (this.showOnlyWhenInteractionIsActive && !this.active) {
            return true;
        }
        if (this.lastThread != null) {
            return true;
        }
        this.lastThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AisOverlay.this.updating = true;
                try {
                    if (AisOverlay.this.renderer == null) {
                        AisOverlay.this.lastThread = null;
                        return;
                    }
                    LocationType topLeft = AisOverlay.this.renderer.getTopLeftLocationType();
                    LocationType bottomRight = AisOverlay.this.renderer.getBottomRightLocationType();
                    AisOverlay.this.shipsOnMap = AisOverlay.this.getShips(bottomRight.getLatitudeDegs(), topLeft.getLongitudeDegs(), topLeft.getLatitudeDegs(), bottomRight.getLongitudeDegs(), AisOverlay.this.showStoppedShips);
                    AisOverlay.this.lastThread = null;
                    AisOverlay.this.renderer.repaint();
                }
                finally {
                    AisOverlay.this.updating = false;
                }
            }
        };
        this.lastThread.setName("AIS Fetcher thread");
        this.lastThread.setDaemon(true);
        this.lastThread.start();
        return true;
    }

    protected Vector<AisShip> getShips(double minLat, double minLon, double maxLat, double maxLon, boolean includeStationary) {
        Vector<AisShip> ships = new Vector<AisShip>();
        if (maxLat - minLat > 2.0) {
            return ships;
        }
        try {
            URL url = new URL("http://www.marinetraffic.com/ais/getjson.aspx?sw_x=" + minLon + "&sw_y=" + minLat + "&ne_x=" + maxLon + "&ne_y=" + maxLat + "&zoom=12" + "&fleet=&station=0&id=null");
            GetMethod get = new GetMethod(url.toString());
            get.setRequestHeader("Referer", "http://www.marinetraffic.com/ais/");
            this.client.executeMethod((HttpMethod)get);
            String json = get.getResponseBodyAsString();
            String[][] res = (String[][])this.gson.fromJson(json, String[][].class);
            for (int i = 0; i < res.length; ++i) {
                double knots = Double.parseDouble(res[i][5]) / 10.0;
                if (!includeStationary && knots <= 0.2) continue;
                AisShip ship = new AisShip();
                ship.setLatitude(Double.parseDouble(res[i][0]));
                ship.setLongitude(Double.parseDouble(res[i][1]));
                ship.setName(res[i][2]);
                ship.setMMSI(Integer.parseInt(res[i][7]));
                ship.setSpeed(knots);
                if (res[i][4] != null) {
                    ship.setCourse(Double.parseDouble(res[i][4]));
                }
                if (res[i][6] != null) {
                    ship.setCountry(res[i][6]);
                }
                if (res[i][8] != null) {
                    ship.setLength(Double.parseDouble(res[i][8]));
                }
                ships.add(ship);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
        }
        return ships;
    }

    public void cleanSubPanel() {
        PeriodicUpdatesService.unregister((IPeriodicUpdates)this);
        this.shipsOnMap.clear();
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        super.mouseClicked(event, source);
        JPopupMenu popup = new JPopupMenu();
        popup.add(I18n.text((String)"AIS settings")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)AisOverlay.this, (Frame)AisOverlay.this.getConsole(), (boolean)true);
            }
        });
        popup.add(I18n.text((String)"Update ships")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AisOverlay.this.update();
            }
        });
        popup.add(this.getShipInfoMenu());
        popup.show((Component)source, event.getX(), event.getY());
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        this.renderer = renderer;
        if (this.showOnlyWhenInteractionIsActive && !this.active) {
            return;
        }
        if (this.lastThread != null) {
            g.drawString(I18n.text((String)"Updating AIS layer..."), 10, 15);
        } else {
            g.drawString(I18n.textf((String)"%numberOfShips visible ships", (Object[])new Object[]{this.shipsOnMap.size()}), 10, 15);
        }
        for (AisShip ship : this.shipsOnMap) {
            Graphics2D clone = (Graphics2D)g.create();
            LocationType shipLoc = ship.getLocation();
            if (this.interpolate) {
                double dT = (double)(System.currentTimeMillis() - ship.lastUpdate) / 1000.0;
                double tx = Math.cos(ship.getHeadingRads()) * dT * ship.getSpeedMps();
                double ty = Math.sin(ship.getHeadingRads()) * dT * ship.getSpeedMps();
                shipLoc.translatePosition(tx, ty, 0.0);
            }
            Point2D pt = renderer.getScreenPosition(shipLoc);
            clone.translate(pt.getX(), pt.getY());
            Graphics2D clone2 = (Graphics2D)clone.create();
            Color c = this.movingColor;
            if (ship.getSpeedKnots() <= 0.2) {
                c = this.stationaryColor;
            }
            double scaleX = (double)(renderer.getZoom() / 10.0f) * ship.getLength() / 9.0;
            double scaleY = (double)(renderer.getZoom() / 10.0f) * ship.getLength();
            clone.rotate(Math.PI + ship.getHeadingRads() - renderer.getRotation());
            clone.setColor(c.brighter());
            clone.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 10.0f}, 0.0f));
            clone.draw(new Line2D.Double(0.0, ship.getLength() / 1.99 * (double)renderer.getZoom(), 0.0, ship.getSpeedMps() * 60.0 * (double)renderer.getZoom()));
            clone.scale(scaleX, scaleY);
            clone.setColor(c);
            clone.fill(this.path);
            clone.dispose();
            clone2.setFont(new Font("Helvetica", 0, 8));
            clone2.setColor(this.labelColor);
            clone2.drawLine(-3, 0, 3, 0);
            clone2.drawLine(0, -3, 0, 3);
            if (this.showNames) {
                clone2.drawString(ship.getName(), 5, 5);
            }
            if (this.showSpeeds && ship.getSpeedKnots() > 0.2) {
                if (this.useKnots) {
                    clone2.drawString(GuiUtils.getNeptusDecimalFormat((int)1).format(ship.getSpeedKnots()) + " kn", 5, 15);
                } else {
                    clone2.drawString(GuiUtils.getNeptusDecimalFormat((int)1).format(ship.getSpeedMps()) + " m/s", 5, 15);
                }
            }
            clone2.dispose();
        }
    }

    protected JMenu getShipInfoMenu() {
        Vector<AisShip> ships = new Vector<AisShip>();
        JMenu menu = new JMenu(I18n.text((String)"Ship Info"));
        ships.addAll(this.shipsOnMap);
        Collections.sort(ships);
        if (ships.size() > 0 && Desktop.isDesktopSupported()) {
            for (final AisShip s : ships) {
                menu.add(s.getName()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            URI uri = new URI(s.getShipInfoURL());
                            desktop.browse(uri);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (URISyntaxException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        } else {
            menu.setEnabled(false);
        }
        return menu;
    }

    public Collection<JMenuItem> getApplicableItems(LocationType loc, IMapPopup source) {
        Vector<JMenuItem> items = new Vector<JMenuItem>();
        if (!this.shipsOnMap.isEmpty()) {
            items.add(this.getShipInfoMenu());
        }
        return items;
    }

    public void initSubPanel() {
        Vector r = this.getConsole().getSubPanelsOfInterface(IMapPopup.class);
        for (IMapPopup str2d : r) {
            str2d.addMenuExtension((IEditorMenuExtension)this);
        }
    }
}

