/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.ais;

import pt.lsts.neptus.types.coord.LocationType;

public class AisShip
implements Comparable<AisShip> {
    protected String name;
    protected String country;
    protected double speed = 0.0;
    protected double course = 0.0;
    protected double latitude = 0.0;
    protected double longitude = 0.0;
    protected double length = 10.0;
    protected int mmsi = 0;
    protected long lastUpdate = System.currentTimeMillis();

    public void update(double lat, double lon, double course, double speed) {
        this.setLatitude(lat);
        this.setLongitude(lon);
        this.setCourse(course);
        this.setSpeed(speed);
        this.lastUpdate = System.currentTimeMillis();
    }

    public LocationType getLocation() {
        return new LocationType(this.latitude, this.longitude);
    }

    public double getSpeedMps() {
        return 0.514 * this.speed;
    }

    public double getHeadingRads() {
        return Math.toRadians(this.course);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public double getSpeedKnots() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getCourse() {
        return this.course;
    }

    public void setCourse(double course) {
        this.course = course;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setMMSI(int mmsi) {
        this.mmsi = mmsi;
    }

    public int getMMSI() {
        return this.mmsi;
    }

    public String getShipInfoURL() {
        return "http://www.marinetraffic.com/ais/shipdetails.aspx?mmsi=" + this.getMMSI() + "&header=false";
    }

    @Override
    public int compareTo(AisShip o) {
        return this.getName().compareTo(o.getName());
    }
}

