/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;
import pt.lsts.neptus.util.coord.MapTileUtil;

@MapTileProvider(name="www.GEBCO.net")
public class TileGEBCO
extends TileHttpFetcher {
    private static final long serialVersionUID = -7203527367652271493L;
    protected static String tileClassId = TileGEBCO.class.getSimpleName();
    private static Map<String, TileGEBCO> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final int MAX_LEVEL_OF_DETAIL = 20;
    private static boolean alreadyInitialize = false;

    public TileGEBCO(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
        this.initialize();
    }

    public TileGEBCO(String id) throws Exception {
        super(id);
        this.initialize();
    }

    public static int getMaxLevelOfDetail() {
        return 20;
    }

    private synchronized void initialize() {
        if (alreadyInitialize) {
            return;
        }
        alreadyInitialize = true;
        httpConnectionManager.setMaxPerRoute(new HttpRoute(new HttpHost("www.gebco.net")), 4);
    }

    protected String createTileRequestURL() {
        double lat1 = 35.0;
        double lat2 = 44.0;
        double lon1 = -12.7;
        double lon2 = 5.0;
        double[] ret1 = MapTileUtil.XYToDegrees((double)this.worldX, (double)this.worldY, (int)this.levelOfDetail);
        double[] ret2 = MapTileUtil.XYToDegrees((double)(this.worldX + 256), (double)(this.worldY + 256), (int)this.levelOfDetail);
        lat1 = Math.min(ret1[0], ret2[0]);
        lat2 = Math.max(ret1[0], ret2[0]);
        lon1 = Math.min(ret1[1], ret2[1]);
        lon2 = Math.max(ret1[1], ret2[1]);
        String urlGet = "http://www.gebco.net/data_and_products/gebco_web_services/web_map_service/mapserv?request=getmap&service=wms&BBOX=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2 + "&srs=EPSG:4326&format=image/jpeg&layers=gebco_08_grid&" + "width=256&height=256&version=1.1.1";
        NeptusLog.pub().info((Object)("<###> " + urlGet));
        return urlGet;
    }

    protected long getWaitTimeMillisToSeparateConnections() {
        return (long)(10.0 * rnd.nextDouble());
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }
}

