/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;
import pt.lsts.neptus.util.coord.MapTileUtil;

@MapTileProvider(name="Google Maps")
public class TileGoogleMaps
extends TileHttpFetcher {
    private static final long serialVersionUID = 536559879996297467L;
    private static final String HOST = "maps.google.com";
    private static final ReentrantLock lock = new ReentrantLock();
    protected static String tileClassId = TileGoogleMaps.class.getSimpleName();
    private static Map<String, TileGoogleMaps> tilesMap = Collections.synchronizedMap(new HashMap());
    private static boolean alreadyInitialize = false;

    public TileGoogleMaps(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
        this.initialize();
    }

    public TileGoogleMaps(String id) throws Exception {
        super(id);
        this.initialize();
    }

    private synchronized void initialize() {
        if (alreadyInitialize) {
            return;
        }
        alreadyInitialize = true;
        httpConnectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(HOST)), 1);
    }

    protected String createTileRequestURL() {
        double[] ret = MapTileUtil.XYToDegrees((double)(this.worldX + 128), (double)(this.worldY + 128), (int)this.levelOfDetail);
        String urlGet = "http://maps.google.com/maps/api/staticmap?center=" + ret[0] + "," + ret[1] + "&zoom=" + this.levelOfDetail + "&size=256x256&sensor=false";
        return urlGet;
    }

    protected long getWaitTimeMillisToSeparateConnections() {
        return (long)((double)(!TileGoogleMaps.isInStateForbidden() ? 800 : 5000) + (double)(!TileGoogleMaps.isInStateForbidden() ? 500 : 5000) * rnd.nextDouble());
    }

    protected ReentrantLock getWaitTimeLock() {
        return lock;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }

    public static boolean isFetchableOrGenerated() {
        return false;
    }
}

