/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;

@MapTileProvider(name="Open Sea Map Overlay", isBaseMapOrLayer=false)
public class TileOpenSeaMap
extends TileHttpFetcher {
    private static final long serialVersionUID = -6223894220961990674L;
    protected static String tileClassId = TileOpenSeaMap.class.getSimpleName();
    private static Map<String, TileOpenSeaMap> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final int MAX_LEVEL_OF_DETAIL = 18;

    public TileOpenSeaMap(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileOpenSeaMap(String id) throws Exception {
        super(id);
    }

    public static int getMaxLevelOfDetail() {
        return 18;
    }

    protected String createTileRequestURL() {
        String urlGet = "http://www.openptmap.org/tiles/" + this.levelOfDetail + "/" + this.tileX + "/" + this.tileY + ".png";
        urlGet = "http://tiles.openseamap.org/seamark/" + this.levelOfDetail + "/" + this.tileX + "/" + this.tileY + ".png";
        return urlGet;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }
}

