/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;

@MapTileProvider(name="Ship Traffic Density", isBaseMapOrLayer=false)
public class TileShipTrafficDensity
extends TileHttpFetcher {
    private static final long serialVersionUID = -5210083535661616257L;
    protected static String tileClassId = TileShipTrafficDensity.class.getSimpleName();
    private static Map<String, TileShipTrafficDensity> tilesMap = Collections.synchronizedMap(new HashMap());

    public TileShipTrafficDensity(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileShipTrafficDensity(String id) throws Exception {
        super(id);
    }

    protected String createTileRequestURL() {
        if (this.levelOfDetail > 11) {
            return null;
        }
        return "http://tiles.marinetraffic.com/ais/density_tiles/" + this.levelOfDetail + "/" + this.tileX + "/tile_" + this.levelOfDetail + "_" + this.tileX + "_" + this.tileY + ".png";
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static int getMaxLevelOfDetail() {
        return 10;
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }
}

