/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileHttpFetcher;

@MapTileProvider(name="Virtual Earth")
public class TileVirtualEarth
extends TileHttpFetcher {
    private static final long serialVersionUID = -7203527367652271490L;
    protected static String tileClassId = TileVirtualEarth.class.getSimpleName();
    private static Map<String, TileVirtualEarth> tilesMap = Collections.synchronizedMap(new HashMap());
    private static final int MAX_LEVEL_OF_DETAIL = 20;

    public TileVirtualEarth(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileVirtualEarth(String id) throws Exception {
        super(id);
    }

    public static int getMaxLevelOfDetail() {
        return 20;
    }

    protected String createTileRequestURL() {
        int server = (int)(4.0f * rnd.nextFloat());
        String urlGet = "http://r" + server + ".ortho.tiles.virtualearth.net/tiles/" + "r" + this.id + ".png?g=1";
        return urlGet;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }
}

