/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.renderer2d.tiles;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pt.lsts.neptus.plugins.MapTileProvider;
import pt.lsts.neptus.renderer2d.tiles.Tile;
import pt.lsts.neptus.renderer2d.tiles.TileVirtualEarth;

@MapTileProvider(name="Virtual Earth Hybrid")
public class TileVirtualEarthHybrid
extends TileVirtualEarth {
    private static final long serialVersionUID = -1827702213399356919L;
    protected static String tileClassId = TileVirtualEarthHybrid.class.getSimpleName();
    private static Map<String, TileVirtualEarthHybrid> tilesMap = Collections.synchronizedMap(new HashMap());

    public TileVirtualEarthHybrid(Integer levelOfDetail, Integer tileX, Integer tileY, BufferedImage image) throws Exception {
        super(levelOfDetail, tileX, tileY, image);
    }

    public TileVirtualEarthHybrid(String id) throws Exception {
        super(id);
    }

    @Override
    protected String createTileRequestURL() {
        int server = (int)(4.0f * rnd.nextFloat());
        String urlGet = "http://r" + server + ".ortho.tiles.virtualearth.net/tiles/" + "h" + this.id + ".png?g=1";
        return urlGet;
    }

    public static <T extends Tile> Map<String, T> getTilesMap() {
        return tilesMap;
    }

    public static void clearDiskCache() {
        Tile.clearDiskCache((String)tileClassId);
    }

    public static <T extends Tile> Vector<T> loadCache() {
        return Tile.loadCache((String)tileClassId);
    }
}

