/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.matlab;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.vecmath.Point3d;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.PathElement;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Planner - Shortest Path", icon="pt/lsts/neptus/plugins/matlab/shortest.png")
public class ShortestPathPlanner
extends SimpleRendererInteraction
implements Renderer2DPainter,
StateRendererInteraction {
    private static final long serialVersionUID = -3743171179579658242L;
    public LocationType destination = null;
    public LocationType initial = null;
    public LocationType bottomLeft = null;
    public LocationType topRight = null;
    protected boolean isActive;
    protected EDITION_STATES state = EDITION_STATES.NONE;
    protected Vector<PathElement> obstacles = new Vector();
    protected PathElement currentObstacle = null;
    protected LocationType ultimoPonto = null;
    @NeptusProperty(name="Default Speed (m/s)")
    public double defaultSpeed = 1.0;
    @NeptusProperty(name="Default Depth (m)")
    public double defaultDepth = 2.0;
    protected static String errors = "";
    protected static String output = "";

    public ShortestPathPlanner(ConsoleLayout console) {
        super(console);
    }

    public boolean isExclusive() {
        return true;
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        this.isActive = mode;
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        final Point mousePosition = event.getPoint();
        final StateRenderer2D renderer = source;
        if (event.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            switch (this.state) {
                case NONE: {
                    menu.add("Define boundary's bottom left").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.bottomLeft = renderer.getRealWorldLocation(mousePosition);
                        }
                    });
                    menu.add("Define boundary's top right").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.topRight = renderer.getRealWorldLocation(mousePosition);
                        }
                    });
                    menu.add("Define destination location").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.destination = renderer.getRealWorldLocation(mousePosition);
                        }
                    });
                    menu.add("Define initial location").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.initial = renderer.getRealWorldLocation(mousePosition);
                        }
                    });
                    menu.add("Add obstacle").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.state = EDITION_STATES.ADDING_OBSTACLE;
                            LocationType loc = renderer.getRealWorldLocation(mousePosition);
                            ShortestPathPlanner.this.currentObstacle = new PathElement(renderer.getMapGroup(), null, loc);
                            ShortestPathPlanner.this.currentObstacle.setFill(true);
                            ShortestPathPlanner.this.currentObstacle.setShape(true);
                            ShortestPathPlanner.this.currentObstacle.setMyColor(Color.yellow);
                            ShortestPathPlanner.this.currentObstacle.addPoint(0.0, 0.0, 0.0, false);
                        }
                    });
                    menu.add("Clear obstacles").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.obstacles.clear();
                        }
                    });
                    for (PathElement el : this.obstacles) {
                        if (!el.containsPoint(source.getRealWorldLocation((Point2D)mousePosition), source)) continue;
                        final PathElement toremove = el;
                        menu.add("Remove obstacle").addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ShortestPathPlanner.this.obstacles.remove(toremove);
                            }
                        });
                    }
                    menu.addSeparator();
                    menu.add("Shortest Path settings").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PropertiesEditor.editProperties((PropertiesProvider)ShortestPathPlanner.this, (boolean)true);
                        }
                    });
                    menu.addSeparator();
                    menu.add("Clear map").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.obstacles.clear();
                            ShortestPathPlanner.this.initial = null;
                            ShortestPathPlanner.this.destination = null;
                            ShortestPathPlanner.this.bottomLeft = null;
                            ShortestPathPlanner.this.topRight = null;
                        }
                    });
                    menu.addSeparator();
                    final JMenuItem item = menu.add("Generate plan");
                    if (this.initial == null || this.destination == null || this.bottomLeft == null || this.topRight == null) break;
                    item.setEnabled(true);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                item.setEnabled(false);
                                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                                    @Override
                                    protected Void doInBackground() throws Exception {
                                        ShortestPathPlanner.this.generatePlan();
                                        return null;
                                    }

                                    @Override
                                    protected void done() {
                                        try {
                                            this.get();
                                        }
                                        catch (Exception e) {
                                            NeptusLog.pub().error((Object)e);
                                        }
                                        item.setEnabled(true);
                                    }
                                };
                                worker.execute();
                            }
                            catch (Exception ex) {
                                GuiUtils.errorMessage((Component)ShortestPathPlanner.this.getConsole(), (Exception)ex);
                            }
                        }
                    });
                    break;
                }
                case ADDING_OBSTACLE: {
                    menu.add("Finish obstacle").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.currentObstacle.setFinished(true);
                            ShortestPathPlanner.this.currentObstacle.setMyColor(Color.orange);
                            ShortestPathPlanner.this.obstacles.add(ShortestPathPlanner.this.currentObstacle);
                            ShortestPathPlanner.this.currentObstacle = null;
                            ShortestPathPlanner.this.state = EDITION_STATES.NONE;
                        }
                    });
                    menu.add("Delete obstacle").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ShortestPathPlanner.this.state = EDITION_STATES.NONE;
                            ShortestPathPlanner.this.currentObstacle = null;
                        }
                    });
                }
            }
            menu.show((Component)source, (int)((Point2D)mousePosition).getX(), (int)((Point2D)mousePosition).getY());
        } else if (this.state == EDITION_STATES.ADDING_OBSTACLE) {
            NeptusLog.pub().info((Object)("<###> " + renderer.getRealWorldLocation((Point2D)mousePosition)));
            LocationType loc = renderer.getRealWorldLocation((Point2D)mousePosition);
            double[] offsets = loc.getOffsetFrom(this.currentObstacle.getCenterLocation());
            this.currentObstacle.addPoint(offsets[1], offsets[0], 0.0, false);
        }
    }

    protected PlanType createPlanFromWaypoints(Collection<LocationType> waypoints, LinkedHashMap<String, Object> maneuverProperties) {
        PlanCreator creator = new PlanCreator(this.getConsole().getMission());
        for (LocationType loc : waypoints) {
            creator.setLocation(loc);
            creator.addGoto(maneuverProperties);
        }
        return creator.getPlan();
    }

    protected PlanType createPlan(Collection<LocationType> waypoints, double speedMps) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("speed", speedMps);
        props.put("units", "m/s");
        return this.createPlanFromWaypoints(waypoints, props);
    }

    protected void generatePlan() throws Exception {
        File output = new File(ConfigFetch.getNeptusTmpDir(), "shortest_path_in.ini");
        File input = new File(ConfigFetch.getNeptusTmpDir(), "shortest_path_out.ini");
        NeptusLog.pub().info((Object)("Creating file " + output.getAbsolutePath()));
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        writer.append("[vehicle]\n");
        writer.append("name = " + this.getConsole().getMainSystem() + "\n\n");
        writer.append("[map_origin]\n");
        this.bottomLeft.convertToAbsoluteLatLonDepth();
        writer.append("latitude = " + this.bottomLeft.getLatitudeDegs() + "\n");
        writer.append("longitude = " + this.bottomLeft.getLongitudeDegs() + "\n\n");
        writer.append("[map_finish]\n");
        this.topRight.convertToAbsoluteLatLonDepth();
        writer.append("latitude = " + this.topRight.getLatitudeDegs() + "\n");
        writer.append("longitude = " + this.topRight.getLongitudeDegs() + "\n\n");
        writer.append("[start_point]\n");
        this.initial.convertToAbsoluteLatLonDepth();
        writer.append("latitude = " + this.initial.getLatitudeDegs() + "\n");
        writer.append("longitude = " + this.initial.getLongitudeDegs() + "\n\n");
        writer.append("[end_point]\n");
        this.destination.convertToAbsoluteLatLonDepth();
        writer.append("latitude = " + this.destination.getLatitudeDegs() + "\n");
        writer.append("longitude = " + this.destination.getLongitudeDegs() + "\n\n");
        writer.append("[obstacles]\n");
        int i = 1;
        for (PathElement obs : this.obstacles) {
            Vector points = obs.getPoints();
            LocationType center = new LocationType(obs.getCenterLocation().convertToAbsoluteLatLonDepth());
            writer.append("obs" + i++ + " = ");
            for (Point3d pt : points) {
                LocationType loc = new LocationType(center);
                loc.translatePosition(pt.x, pt.y, 0.0);
                loc.convertToAbsoluteLatLonDepth();
                writer.append(loc.getLatitudeDegs() + ", " + loc.getLongitudeDegs() + "; ");
            }
            writer.append(center.getLatitudeDegs() + ", " + center.getLongitudeDegs() + ";\n");
        }
        writer.close();
        String result = "<html>" + ShortestPathPlanner.execCommand("matlab -nodisplay -r shortestPath_no_plots('" + output.getAbsolutePath() + "','" + input.getAbsolutePath() + "')");
        GuiUtils.htmlMessage((Component)this.getConsole(), (String)"Shortest Path", (String)"", (String)result);
        Vector<LocationType> wpts = new Vector<LocationType>();
        String in = FileUtil.getFileAsString((File)input);
        NeptusLog.pub().info((Object)("<###> " + in));
        try {
            String[] lines;
            for (String l : lines = in.split("\n")) {
                String[] parts = l.split("\t");
                Double lat = Double.parseDouble(parts[0]);
                Double lon = Double.parseDouble(parts[1]);
                wpts.add(new LocationType(lat.doubleValue(), lon.doubleValue()));
            }
            PlanType pt = this.createPlan(wpts, this.defaultSpeed);
            pt.setVehicle(this.getConsole().getMainSystem());
            this.getConsole().getMission().addPlan(pt);
            this.getConsole().warnMissionListeners();
            this.getConsole().setPlan(pt);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    public static String execCommand(String command) {
        errors = "";
        output = "";
        NeptusLog.pub().info((Object)("<###>$>" + command + "\n"));
        String result = "<p>Executing <b>" + command + "</b>...</p>\n";
        try {
            Process p = Runtime.getRuntime().exec(command);
            final BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            final BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            Thread out = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String s;
                        while ((s = stdInput.readLine()) != null) {
                            output = output + s + "\n";
                            NeptusLog.pub().info((Object)("<###> " + s));
                        }
                        NeptusLog.pub().info((Object)"<###>closed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            out.start();
            Thread err = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String s;
                        while ((s = stdError.readLine()) != null) {
                            errors = errors + s + "\n";
                            System.err.println(s);
                            System.err.flush();
                        }
                        System.err.println("closed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            err.start();
            while (out.isAlive() && err.isAlive()) {
                try {
                    Thread.sleep(500L);
                    NeptusLog.pub().info((Object)"<###>.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            errors = errors + new String(baos.toByteArray());
        }
        if (output.length() > 0) {
            result = result + "<p><b>Output:</b><blockquote><font color='green'><pre>" + output + "</pre></font></blockquote></p>";
        }
        if (errors.length() > 0) {
            result = result + "<p><b>Errors:</b><blockquote><font color='red'><pre>" + errors + "</pre></font></blockquote></p>";
        }
        return result;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Point2D ponto;
        if (this.destination != null) {
            ponto = renderer.getScreenPosition(this.destination);
            if (this.isActive) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.red.darker().darker());
            }
            g.fill(new Ellipse2D.Double(ponto.getX() - 5.0, ponto.getY() - 5.0, 10.0, 10.0));
            g.draw(new Ellipse2D.Double(ponto.getX() - 5.0, ponto.getY() - 5.0, 10.0, 10.0));
        }
        g.setColor(Color.green.darker());
        g.setStroke(new BasicStroke(4.0f));
        if (this.initial != null) {
            ponto = renderer.getScreenPosition(this.initial);
            if (this.isActive) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.green.darker().darker());
            }
            g.fill(new Ellipse2D.Double(ponto.getX() - 5.0, ponto.getY() - 5.0, 10.0, 10.0));
            g.draw(new Ellipse2D.Double(ponto.getX() - 5.0, ponto.getY() - 5.0, 10.0, 10.0));
        }
        if (this.isActive) {
            if (this.bottomLeft != null) {
                ponto = renderer.getScreenPosition(this.bottomLeft);
                g.draw(new Line2D.Double(ponto.getX(), ponto.getY(), ponto.getX() + 20.0, ponto.getY()));
                g.draw(new Line2D.Double(ponto.getX(), ponto.getY(), ponto.getX(), ponto.getY() - 20.0));
            }
            if (this.topRight != null) {
                ponto = renderer.getScreenPosition(this.topRight);
                g.draw(new Line2D.Double(ponto.getX() - 20.0, ponto.getY(), ponto.getX(), ponto.getY()));
                g.draw(new Line2D.Double(ponto.getX(), ponto.getY(), ponto.getX(), ponto.getY() + 20.0));
            }
        }
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.0f));
        if (this.topRight != null && this.bottomLeft != null) {
            Point2D topo = renderer.getScreenPosition(this.topRight);
            Point2D fundo = renderer.getScreenPosition(this.bottomLeft);
            double x = Math.min(topo.getX(), fundo.getX());
            double y = Math.min(topo.getY(), fundo.getY());
            double w = Math.abs(topo.getX() - fundo.getX());
            double h = Math.abs(topo.getY() - fundo.getY());
            g.draw(new Rectangle2D.Double(x, y, w, h));
        }
        for (PathElement elem : this.obstacles) {
            elem.paint(g, renderer, renderer.getRotation());
        }
        if (this.currentObstacle != null) {
            this.currentObstacle.paint(g, renderer, renderer.getRotation());
        }
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }

    public static enum EDITION_STATES {
        NONE,
        ADDING_OBSTACLE;

    }
}

