/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.dom.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.web3d.x3d.dom.swing.DOMTreeNode;

public class DOMTreeCellEditor
implements TreeCellEditor,
KeyListener {
    private Insets emptyBorder;
    private Color textSelectColor;
    private Color textUnselectColor;
    private Color bgSelectColor;
    private Color bgUnselectColor;
    private Color borderColor;
    private JTextField editor;
    private ArrayList listeners = new ArrayList(5);

    public DOMTreeCellEditor() {
        this.editor = new JTextField(10);
        this.editor.addKeyListener(this);
        this.emptyBorder = new Insets(0, 0, 0, 0);
        this.textSelectColor = UIManager.getColor("Tree.selectionForeground");
        this.textUnselectColor = UIManager.getColor("Tree.textForeground");
        this.bgSelectColor = UIManager.getColor("Tree.selectionBackground");
        this.bgUnselectColor = UIManager.getColor("Tree.textBackground");
        this.borderColor = UIManager.getColor("Tree.selectionBorderColor");
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        JComponent jComponent = null;
        Node node = ((DOMTreeNode)object).getNode();
        switch (node.getNodeType()) {
            case 2: {
                this.editor.setText(node.getNodeValue());
                this.editor.selectAll();
                JLabel jLabel = new JLabel(node.getNodeName() + " ");
                JPanel jPanel = new JPanel();
                jPanel.add(jLabel);
                jPanel.add(this.editor);
                jLabel.setBorder(new EmptyBorder(this.emptyBorder));
                if (bl) {
                    jLabel.setForeground(this.textSelectColor);
                    jLabel.setBackground(this.bgSelectColor);
                    if (this.borderColor != null) {
                        jPanel.setBorder(new LineBorder(this.borderColor));
                    } else {
                        jPanel.setBorder(new EmptyBorder(this.emptyBorder));
                    }
                } else {
                    jLabel.setForeground(this.textUnselectColor);
                    jLabel.setBackground(this.bgUnselectColor);
                    jPanel.setBorder(new EmptyBorder(this.emptyBorder));
                }
                jComponent = jPanel;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                this.editor.setText(node.getNodeValue());
                this.editor.selectAll();
                jComponent = this.editor;
                break;
            }
        }
        return jComponent;
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        if (mouseEvent.getClickCount() < 2) {
            return false;
        }
        JTree jTree = (JTree)eventObject.getSource();
        TreePath treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        DOMTreeNode dOMTreeNode = (DOMTreeNode)treePath.getLastPathComponent();
        Node node = dOMTreeNode.getNode();
        boolean bl = false;
        switch (node.getNodeType()) {
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null && !this.listeners.contains(cellEditorListener)) {
            this.listeners.add(cellEditorListener);
        }
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.fireFinishEditEvent();
        } else if (n == 27) {
            this.fireCancelEditEvent();
        }
    }

    private void fireCancelEditEvent() {
        Iterator iterator = this.listeners.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this.editor);
        while (iterator.hasNext()) {
            CellEditorListener cellEditorListener = (CellEditorListener)iterator.next();
            try {
                cellEditorListener.editingCanceled(changeEvent);
            }
            catch (Exception exception) {
                System.err.println("Error sending cancel event: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFinishEditEvent() {
        Iterator iterator = this.listeners.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this.editor);
        while (iterator.hasNext()) {
            CellEditorListener cellEditorListener = (CellEditorListener)iterator.next();
            try {
                cellEditorListener.editingStopped(changeEvent);
            }
            catch (Exception exception) {
                System.err.println("Error sending cancel event: " + exception);
                exception.printStackTrace();
            }
        }
    }
}

