/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.dom.swing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.web3d.x3d.dom.swing.DOMTreeNode;

public class DOMTreeModel
implements TreeModel,
EventListener {
    private DOMTreeNode domRoot;
    private ArrayList listeners;
    private boolean hasDOMEvents = false;

    public DOMTreeModel(Node node) {
        this.domRoot = new DOMTreeNode(node, null);
        this.listeners = new ArrayList();
        this.hasDOMEvents = node.isSupported("MutationEvents", "2.0");
        this.buildChildren(this.domRoot);
        if (this.hasDOMEvents) {
            EventTarget eventTarget = (EventTarget)((Object)node);
            eventTarget.addEventListener("DOMNodeInserted", this, false);
            eventTarget.addEventListener("DOMNodeRemoved", this, false);
            eventTarget.addEventListener("DOMAttrModified", this, false);
        }
    }

    public Object getChild(Object object, int n) {
        DOMTreeNode dOMTreeNode = (DOMTreeNode)object;
        DOMTreeNode dOMTreeNode2 = (DOMTreeNode)dOMTreeNode.getChildAt(n);
        if (!dOMTreeNode2.kidsLoaded) {
            this.buildChildren(dOMTreeNode2);
            dOMTreeNode2.kidsLoaded = true;
        }
        return dOMTreeNode2;
    }

    public int getChildCount(Object object) {
        DOMTreeNode dOMTreeNode = (DOMTreeNode)object;
        return dOMTreeNode.getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        DOMTreeNode dOMTreeNode = (DOMTreeNode)object;
        return dOMTreeNode.getIndex((TreeNode)object2);
    }

    public Object getRoot() {
        return this.domRoot;
    }

    public boolean isLeaf(Object object) {
        DOMTreeNode dOMTreeNode = (DOMTreeNode)object;
        Node node = dOMTreeNode.getNode();
        short s = node.getNodeType();
        boolean bl = false;
        switch (s) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                bl = true;
            }
        }
        return bl;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        DOMTreeNode dOMTreeNode = (DOMTreeNode)treePath.getLastPathComponent();
        Node node = dOMTreeNode.getNode();
        switch (node.getNodeType()) {
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                node.setNodeValue((String)object);
                break;
            }
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && !this.listeners.contains(treeModelListener)) {
            this.listeners.add(treeModelListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && this.listeners.contains(treeModelListener)) {
            this.listeners.remove(treeModelListener);
        }
    }

    public void handleEvent(Event event) {
        MutationEvent mutationEvent = (MutationEvent)event;
        String string = event.getType();
        Node node = (Node)((Object)event.getTarget());
        Node node2 = null;
        node2 = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : (node.getNodeType() == 1 && (mutationEvent.getAttrChange() == 3 || mutationEvent.getAttrChange() == 2) ? node : node.getParentNode());
        TreePath treePath = this.buildTreePath(node2);
        DOMTreeNode dOMTreeNode = (DOMTreeNode)treePath.getLastPathComponent();
        Object[] objectArray = new Object[1];
        int[] nArray = new int[1];
        if (string.equals("DOMAttrModified")) {
            short s = mutationEvent.getAttrChange();
            switch (s) {
                case 2: {
                    int n;
                    DOMTreeNode dOMTreeNode2 = new DOMTreeNode(mutationEvent.getRelatedNode(), dOMTreeNode);
                    dOMTreeNode.insert(dOMTreeNode2, dOMTreeNode.getChildCount());
                    nArray[0] = n = this.getIndexOfChild(dOMTreeNode, dOMTreeNode2);
                    objectArray[0] = dOMTreeNode2;
                    TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                    this.fireTreeNodesInserted(treeModelEvent);
                    break;
                }
                case 3: {
                    int n;
                    DOMTreeNode dOMTreeNode3 = dOMTreeNode.getTreeNodeChild(node);
                    nArray[0] = n = this.getIndexOfChild(dOMTreeNode, dOMTreeNode3);
                    objectArray[0] = dOMTreeNode3;
                    TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                    dOMTreeNode.remove(dOMTreeNode3);
                    this.fireTreeNodesRemoved(treeModelEvent);
                    break;
                }
                case 1: {
                    int n;
                    DOMTreeNode dOMTreeNode4 = dOMTreeNode.getTreeNodeChild(node);
                    nArray[0] = n = this.getIndexOfChild(dOMTreeNode, dOMTreeNode4);
                    objectArray[0] = dOMTreeNode4;
                    TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                    this.fireTreeNodesChanged(treeModelEvent);
                }
            }
        } else if (string.equals("DOMNodeInserted")) {
            int n;
            DOMTreeNode dOMTreeNode5 = new DOMTreeNode(node, dOMTreeNode);
            dOMTreeNode.insert(dOMTreeNode5, dOMTreeNode.getChildCount());
            nArray[0] = n = this.getIndexOfChild(dOMTreeNode, dOMTreeNode5);
            objectArray[0] = dOMTreeNode5;
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            this.fireTreeNodesInserted(treeModelEvent);
        } else if (string.equals("DOMNodeRemoved")) {
            int n;
            DOMTreeNode dOMTreeNode6 = dOMTreeNode.getTreeNodeChild(node);
            nArray[0] = n = this.getIndexOfChild(dOMTreeNode, dOMTreeNode6);
            objectArray[0] = dOMTreeNode6;
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            dOMTreeNode.remove(dOMTreeNode6);
            this.fireTreeNodesRemoved(treeModelEvent);
        }
    }

    private void buildChildren(DOMTreeNode dOMTreeNode) {
        Node node = dOMTreeNode.getNode();
        EventTarget eventTarget = null;
        if (this.hasDOMEvents) {
            eventTarget = (EventTarget)((Object)node);
        }
        if (node.getNodeType() != 2) {
            DOMTreeNode dOMTreeNode2;
            int n;
            int n2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n3 = n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
            for (n = 0; n < n2; ++n) {
                dOMTreeNode2 = new DOMTreeNode(namedNodeMap.item(n), dOMTreeNode);
                dOMTreeNode.insert(dOMTreeNode2, n);
            }
            NodeList nodeList = node.getChildNodes();
            n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                dOMTreeNode2 = new DOMTreeNode(nodeList.item(n), dOMTreeNode);
                dOMTreeNode.insert(dOMTreeNode2, n3++);
            }
        }
    }

    private TreePath buildTreePath(Node node) {
        int n;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            arrayList.add(node2);
        }
        int n2 = arrayList.size();
        Node[] nodeArray = new Node[n2];
        for (n = 0; n < n2; ++n) {
            nodeArray[n] = (Node)arrayList.get(n2 - n - 1);
        }
        Object[] objectArray = new DOMTreeNode[n2];
        objectArray[0] = this.domRoot;
        for (n = 1; n < n2; ++n) {
            objectArray[n] = ((DOMTreeNode)objectArray[n - 1]).getTreeNodeChild(nodeArray[n]);
        }
        return new TreePath(objectArray);
    }

    private void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            try {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
            catch (Exception exception) {
                System.err.println("Error during tree event processing");
                exception.printStackTrace();
            }
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            try {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
            catch (Exception exception) {
                System.err.println("Error during tree event processing");
                exception.printStackTrace();
            }
        }
    }

    private void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            try {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
            catch (Exception exception) {
                System.err.println("Error during tree event processing");
                exception.printStackTrace();
            }
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            try {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
            catch (Exception exception) {
                System.err.println("Error during tree event processing");
                exception.printStackTrace();
            }
        }
    }
}

