/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.beacons;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MissionType;

@PluginDescription(name="Transponder Visibility", icon="pt/lsts/neptus/plugins/beacons/transponder.png")
public class BeaconsVisibilityLayer
extends ConsoleLayer
implements MissionChangeListener {
    @NeptusProperty(name="Maximum communication radius")
    private double commRadius = 800.0;
    private List<Area> beaconVisibility = Collections.synchronizedList(new ArrayList());
    private List<LocationType> beaconPositions = Collections.synchronizedList(new ArrayList());

    public boolean userControlsOpacity() {
        return false;
    }

    public void missionUpdated(MissionType mission) {
        this.parseMap();
    }

    public void missionReplaced(MissionType mission) {
        this.parseMap();
    }

    public void initLayer() {
        this.parseMap();
    }

    private void parseMap() {
        this.beaconPositions.clear();
        this.beaconVisibility.clear();
        MapGroup mg = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission());
        Vector elems = mg.getAllObjectsOfType(TransponderElement.class);
        if (elems.isEmpty()) {
            return;
        }
        Vector obstacles = mg.getObstacles();
        for (TransponderElement e : elems) {
            LocationType center = new LocationType(e.getCenterLocation());
            this.beaconPositions.add(center);
            this.beaconVisibility.add(this.computeVisibility(center, this.commRadius, obstacles));
        }
    }

    private Area computeVisibility(LocationType center, double radius, Vector<AbstractElement> obstacles) {
        Area visibleArea = new Area(new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0));
        for (AbstractElement elem : obstacles) {
            Vector corners = elem.getShapePoints();
            if (corners == null || corners.isEmpty()) continue;
            double[] lastOffsets = ((LocationType)corners.lastElement()).getOffsetFrom(center);
            Point2D.Double prevPoint = new Point2D.Double(lastOffsets[1], -lastOffsets[0]);
            Area a = new Area();
            for (LocationType l : corners) {
                double[] offsets = l.getOffsetFrom(center);
                Point2D.Double p = new Point2D.Double(offsets[1], -offsets[0]);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(((Point2D)p).getX(), ((Point2D)p).getY());
                double ang = Math.atan2(((Point2D)p).getY(), ((Point2D)p).getX());
                double px = ((Point2D)p).getX() + this.commRadius * 2.0 * Math.cos(ang);
                double py = ((Point2D)p).getY() + this.commRadius * 2.0 * Math.sin(ang);
                gp.lineTo(px, py);
                ang = Math.atan2(((Point2D)prevPoint).getY(), ((Point2D)prevPoint).getX());
                px = ((Point2D)prevPoint).getX() + this.commRadius * 2.0 * Math.cos(ang);
                py = ((Point2D)prevPoint).getY() + this.commRadius * 2.0 * Math.sin(ang);
                gp.lineTo(px, py);
                gp.lineTo(((Point2D)prevPoint).getX(), ((Point2D)prevPoint).getY());
                gp.closePath();
                a.add(new Area(gp));
                prevPoint = p;
            }
            visibleArea.subtract(a);
        }
        return visibleArea;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        for (int i = 0; i < this.beaconPositions.size(); ++i) {
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D center = renderer.getScreenPosition(this.beaconPositions.get(i));
            g2.translate(center.getX(), center.getY());
            g2.scale(renderer.getZoom(), renderer.getZoom());
            g2.setPaint(new RadialGradientPaint(new Point2D.Double(0.0, 0.0), (float)this.commRadius, new float[]{0.3f, 0.5f}, new Color[]{new Color(0, 255, 0, 40), new Color(0, 255, 0, 0)}));
            g2.fill(this.beaconVisibility.get(i));
        }
    }

    public void cleanLayer() {
    }
}

