/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Collections;
import java.util.Timer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.gui.MenuScroller;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.plugins.map.edit.ObjectPropertiesEdit;
import pt.lsts.neptus.plugins.map.edit.RemoveObjectEdit;
import pt.lsts.neptus.plugins.map.interactions.Box2DInteraction;
import pt.lsts.neptus.plugins.map.interactions.DrawPathInteraction;
import pt.lsts.neptus.plugins.map.interactions.LineInteraction;
import pt.lsts.neptus.plugins.map.interactions.MineDangerAreaInteraction;
import pt.lsts.neptus.plugins.map.interactions.PolygonInteraction;
import pt.lsts.neptus.plugins.map.interactions.QRouteInteraction;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.StateRendererInteraction;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.RotatableElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(author="Jos\u00e9 Pinto, Paulo Dias", name="Map Editor", icon="pt/lsts/neptus/plugins/map/map-edit.png", version="1.5", category=PluginDescription.CATEGORY.INTERFACE)
@LayerPriority(priority=90)
public class MapEditor
extends ConsolePanel
implements StateRendererInteraction,
Renderer2DPainter,
MissionChangeListener,
ConfigurationListener {
    private static final long serialVersionUID = 1L;
    protected InteractionAdapter adapter;
    protected InteractionAdapter currentInteraction = null;
    protected UndoManager manager = this.createManager();
    protected Point mousePoint = null;
    protected Timer dragTesterTimer = null;
    protected Vector<AbstractElement> intersectedObjects = new Vector();
    protected MapGroup mg = null;
    protected StateRenderer2D renderer;
    protected MapType pivot = null;
    protected AbstractElement draggedObject = null;
    protected LocationType originalObjLocation = null;
    protected JToolBar toolbar = this.createToolbar();
    protected Point2D dragOffsets = null;
    protected boolean objectRotated = false;
    protected boolean objectMoved = false;
    protected double originalYaw;
    protected String orignalXML = null;
    protected ToolbarButton undo;
    protected ToolbarButton redo;
    protected ToolbarSwitch associatedSwitch = null;
    @NeptusProperty(name="Toolbar location")
    public ControlsLocation toolbarLocation = ControlsLocation.Right;

    public MapEditor(ConsoleLayout console) {
        super(console);
        try {
            this.adapter = new InteractionAdapter(console);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisibility(false);
    }

    public void propertiesChanged() {
        Container parent = this.toolbar.getParent();
        if (parent != null) {
            parent.remove(this.toolbar);
            switch (this.toolbarLocation) {
                case Left: {
                    parent.add((Component)this.toolbar, "West");
                    this.toolbar.setOrientation(1);
                    break;
                }
                case Right: {
                    parent.add((Component)this.toolbar, "East");
                    this.toolbar.setOrientation(1);
                    break;
                }
                case Top: {
                    parent.add((Component)this.toolbar, "North");
                    this.toolbar.setOrientation(0);
                    break;
                }
                case Bottom: {
                    parent.add((Component)this.toolbar, "South");
                    this.toolbar.setOrientation(0);
                }
            }
            parent.invalidate();
            parent.validate();
        }
    }

    protected UndoManager createManager() {
        return new UndoManager(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized void undo() throws CannotUndoException {
                super.undo();
                MapEditor.this.updateUndoRedoActions();
            }

            @Override
            public synchronized void redo() throws CannotRedoException {
                super.redo();
                MapEditor.this.updateUndoRedoActions();
            }

            @Override
            public synchronized boolean addEdit(UndoableEdit anEdit) {
                boolean ret = super.addEdit(anEdit);
                if (ret) {
                    MapEditor.this.updateUndoRedoActions();
                }
                return ret;
            }
        };
    }

    protected void updateUndoRedoActions() {
        this.undo.setEnabled(this.manager.canUndo());
        this.undo.setToolTipText(this.manager.getUndoPresentationName());
        this.redo.setEnabled(this.manager.canRedo());
        this.redo.setToolTipText(this.manager.getRedoPresentationName());
    }

    protected void disableAllInteractionsBut(ToolbarSwitch source) {
        for (Component c : this.toolbar.getComponents()) {
            if (!(c instanceof ToolbarSwitch) || !((ToolbarSwitch)c).isSelected() || c.equals(source)) continue;
            ((ToolbarSwitch)c).doClick();
        }
    }

    protected MapType getPivot() {
        return this.mg.getPivotMap();
    }

    protected JToolBar createToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setBackground(new Color(255, 200, 200));
        toolbar.setOpaque(true);
        final ToolbarSwitch freehand = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/fh.png"), I18n.text((String)"Add Free-hand drawing"), "fh");
        freehand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(freehand);
                    MapEditor.this.currentInteraction = new DrawPathInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(freehand);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        freehand.setToolTipText(I18n.text((String)"Add freehand drawing"));
        toolbar.add((Component)freehand);
        final ToolbarSwitch fp = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/poly.png"), I18n.text((String)"Add filled polygon"), "fp");
        fp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(fp);
                    MapEditor.this.currentInteraction = new PolygonInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, true, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(fp);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        fp.setToolTipText(I18n.text((String)"Add filled polygon"));
        toolbar.add((Component)fp);
        final ToolbarSwitch up = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/poly2.png"), I18n.text((String)"Add unfilled polygon"), "fp");
        up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(up);
                    MapEditor.this.currentInteraction = new PolygonInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, false, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(up);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        up.setToolTipText(I18n.text((String)"Add polygon (unfilled)"));
        toolbar.add((Component)up);
        final ToolbarSwitch mda = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/mda.png"), I18n.text((String)"Add mine danger area"), "mda");
        mda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(mda);
                    MapEditor.this.currentInteraction = new MineDangerAreaInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(mda);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        mda.setToolTipText(I18n.text((String)"Add mine danger area"));
        toolbar.add((Component)mda);
        final ToolbarSwitch qr = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/qr.png"), I18n.text((String)"Add QRoute"), "qr");
        qr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(qr);
                    MapEditor.this.currentInteraction = new QRouteInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(qr);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        qr.setToolTipText(I18n.text((String)"Add QRoute"));
        toolbar.add((Component)qr);
        final ToolbarSwitch b2d = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/b2d.png"), I18n.text((String)"Add Box2D"), "b2d");
        b2d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(b2d);
                    MapEditor.this.currentInteraction = new Box2DInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(b2d);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        b2d.setToolTipText(I18n.text((String)"Add Box2D"));
        toolbar.add((Component)b2d);
        final ToolbarSwitch line = new ToolbarSwitch(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/interactions/draw-line.png"), I18n.text((String)"Add Line Segment"), "line");
        line.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MapEditor.this.disableAllInteractionsBut(line);
                    MapEditor.this.currentInteraction = new LineInteraction(MapEditor.this.getPivot(), MapEditor.this.manager, MapEditor.this.getConsole());
                    MapEditor.this.currentInteraction.setAssociatedSwitch(line);
                    MapEditor.this.currentInteraction.setActive(true, MapEditor.this.renderer);
                } else {
                    MapEditor.this.currentInteraction.setActive(false, MapEditor.this.renderer);
                    MapEditor.this.currentInteraction = null;
                }
            }
        });
        line.setToolTipText(I18n.text((String)"Add Line Segment"));
        toolbar.add((Component)line);
        this.undo = new ToolbarButton(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/undo.png"), I18n.text((String)"Undo"), "undo");
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.manager.undo();
            }
        });
        toolbar.add((Component)this.undo);
        this.undo.setEnabled(this.manager.canUndo());
        this.redo = new ToolbarButton(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/redo.png"), I18n.text((String)"Redo"), "redo");
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapEditor.this.manager.redo();
            }
        });
        toolbar.add((Component)this.redo);
        this.redo.setEnabled(this.manager.canRedo());
        return toolbar;
    }

    protected void testMouseIntersections() {
        this.intersectedObjects.clear();
        if (this.mousePoint == null || this.mg == null || this.renderer == null) {
            return;
        }
        LocationType loc = this.renderer.getRealWorldLocation((Point2D)this.mousePoint);
        for (AbstractElement elem : this.mg.getAllObjects()) {
            if (!elem.containsPoint(loc, this.renderer)) continue;
            this.intersectedObjects.add(elem);
        }
        Collections.sort(this.intersectedObjects);
    }

    public void missionUpdated(MissionType mission) {
        this.mg = MapGroup.getMapGroupInstance((MissionType)mission);
        if (this.mg.getMaps().length == 0) {
            this.mg.addMap(new MapType((LocationType)mission.getHomeRef()));
        }
        this.pivot = this.mg.getMaps()[0];
    }

    public void missionReplaced(MissionType mission) {
        if (this.adapter.isActive()) {
            this.setActive(false, this.renderer);
        }
        this.manager.discardAllEdits();
        this.pivot = null;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        this.renderer = renderer;
    }

    public Image getIconImage() {
        return ImageUtils.getImage((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass()));
    }

    public Cursor getMouseCursor() {
        return this.adapter.getMouseCursor();
    }

    public boolean isExclusive() {
        return true;
    }

    protected void removeElement(String elemId) {
        AbstractElement elem = this.mg.getMapObjectsByID(elemId)[0];
        RemoveObjectEdit edit = new RemoveObjectEdit(elem);
        edit.redo();
        if (this.pivot == null) {
            this.pivot = this.getPivot();
        }
        MapChangeEvent mce = new MapChangeEvent(1);
        mce.setSourceMap(this.pivot);
        mce.setChangedObject(this.draggedObject);
        this.pivot.warnChangeListeners(mce);
        this.manager.addEdit(edit);
    }

    protected void editElement(String elemId) {
        AbstractElement[] elements = this.mg.getMapObjectsByID(elemId);
        if (elements.length == 0) {
            return;
        }
        AbstractElement element = elements[0];
        String oldXml = element.asXML();
        element.showParametersDialog((Component)this.getConsole(), this.getTransNames(), element.getParentMap(), true);
        if (!element.isUserCancel()) {
            this.mg.updateObjectIds();
            this.manager.addEdit(new ObjectPropertiesEdit(element, oldXml));
            MapChangeEvent mce = new MapChangeEvent(0);
            this.pivot = this.getPivot();
            mce.setSourceMap(this.pivot);
            mce.setChangedObject(this.draggedObject);
            this.pivot.warnChangeListeners(mce);
        }
    }

    private String[] getTransNames() {
        String[] transNames;
        try {
            Vector vector = this.mg.getAllObjectsOfType(TransponderElement.class);
            transNames = new String[vector.size()];
            int i = 0;
            for (TransponderElement transponderElement : vector) {
                transNames[i] = transponderElement.getIdentification();
                ++i;
            }
        }
        catch (NullPointerException e) {
            transNames = new String[]{};
        }
        return transNames;
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.mouseClicked(event, source);
            return;
        }
        this.mousePoint = event.getPoint();
        this.testMouseIntersections();
        final LocationType loc = source.getRealWorldLocation((Point2D)this.mousePoint);
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            if (!this.intersectedObjects.isEmpty()) {
                for (final AbstractElement elem : this.intersectedObjects) {
                    final String elemId = elem.getId();
                    JMenu menu = new JMenu(elem.getId() + " [" + I18n.text((String)elem.getType()) + "]");
                    menu.add(I18n.text((String)"Properties")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MapEditor.this.editElement(elemId);
                        }
                    });
                    if (this.renderer != null) {
                        menu.add(I18n.text((String)"Center in")).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                MapEditor.this.renderer.focusLocation(elem.getCenterLocation());
                            }
                        });
                    }
                    menu.add(I18n.text((String)"Remove")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MapEditor.this.removeElement(elemId);
                        }
                    });
                    popup.add(menu);
                }
                popup.addSeparator();
            }
            JMenu add = new JMenu(I18n.text((String)"Add..."));
            for (AbstractElement elem : MapType.getMapElements()) {
                try {
                    final AbstractElement el = elem;
                    MapType m = null;
                    for (MapType mapType : this.mg.getMaps()) {
                        if (mapType.getHref() == null || mapType.getHref().length() <= 0) continue;
                        m = mapType;
                    }
                    final MapType pivot = m != null ? m : this.mg.getMaps()[0];
                    add.add(I18n.text((String)el.getType())).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                AbstractElement newElem = (AbstractElement)el.getClass().getConstructor(MapGroup.class, MapType.class).newInstance(MapEditor.this.mg, pivot);
                                newElem.setCenterLocation(loc);
                                Vector<String> objNames = new Vector<String>();
                                for (AbstractElement el2 : MapEditor.this.mg.getAllObjects()) {
                                    objNames.add(el2.getId());
                                }
                                newElem.showParametersDialog((Component)((Object)MapEditor.this), objNames.toArray(new String[0]), pivot, true);
                                if (!newElem.userCancel) {
                                    pivot.addObject(newElem);
                                    MapChangeEvent mce = new MapChangeEvent(2);
                                    mce.setSourceMap(pivot);
                                    mce.setChangedObject(MapEditor.this.draggedObject);
                                    pivot.warnChangeListeners(mce);
                                    AddObjectEdit edit = new AddObjectEdit(newElem);
                                    MapEditor.this.manager.addEdit(edit);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                NeptusLog.pub().error((Object)ex);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            add.addSeparator();
            add.add(I18n.text((String)"Image from World File")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block7: {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)I18n.text((String)"Images acompanied by world file"), (String[])new String[]{"png", "jpg", "bmp", "tif"}));
                        int op = chooser.showOpenDialog((Component)MapEditor.this.getConsole());
                        if (op == 0) {
                            File choice = chooser.getSelectedFile();
                            String extension = FileUtil.getFileExtension((File)choice);
                            try {
                                String filename = choice.getCanonicalPath();
                                File file = new File(filename.substring(0, filename.length() - extension.length()) + extension.charAt(0) + extension.charAt(2) + 'w');
                                if (!file.canRead()) {
                                    file = new File(filename + 'w');
                                }
                                if (file.canRead()) {
                                    MapType m = null;
                                    for (MapType mt : MapEditor.this.mg.getMaps()) {
                                        if (mt.getHref() == null || mt.getHref().length() <= 0) continue;
                                        m = mt;
                                    }
                                    MapType pivot = m != null ? m : MapEditor.this.mg.getMaps()[0];
                                    ImageElement el = new ImageElement(choice, file);
                                    el.setMapGroup(MapEditor.this.mg);
                                    el.showParametersDialog((Component)((Object)MapEditor.this), pivot.getObjectIds(), pivot, true);
                                    if (!el.userCancel) {
                                        pivot.addObject((AbstractElement)el);
                                        MapChangeEvent mce = new MapChangeEvent(2);
                                        mce.setSourceMap(pivot);
                                        mce.setChangedObject(MapEditor.this.draggedObject);
                                        pivot.warnChangeListeners(mce);
                                        AddObjectEdit edit = new AddObjectEdit((AbstractElement)el);
                                        MapEditor.this.manager.addEdit(edit);
                                    }
                                    break block7;
                                }
                                throw new Exception(I18n.text((String)"Could not find world image file for given image"));
                            }
                            catch (Exception ex) {
                                GuiUtils.errorMessage((Component)MapEditor.this.getConsole(), (Exception)ex);
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
            popup.add(add);
            JMenuItem item = new JMenuItem(I18n.text((String)"Copy Location"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    CoordinateUtil.copyToClipboard((LocationType)loc);
                }
            });
            item.setIcon(ImageUtils.getIcon((String)"images/menus/editcopy.png"));
            popup.add(item);
            JMenu editElem = new JMenu(I18n.text((String)"Properties..."));
            editElem.setEnabled(false);
            JMenu removeElem = new JMenu(I18n.text((String)"Remove..."));
            removeElem.setEnabled(false);
            JMenu centerElem = new JMenu(I18n.text((String)"Center in..."));
            centerElem.setEnabled(false);
            for (MapType mapType : this.mg.getAllObjects()) {
                if (this.intersectedObjects.contains(mapType)) continue;
                if (!editElem.isEnabled()) {
                    editElem.setEnabled(true);
                    removeElem.setEnabled(true);
                    if (this.renderer != null) {
                        centerElem.setEnabled(true);
                    }
                }
                editElem.add(mapType.getId() + " [" + I18n.text((String)mapType.getType()) + "]").addActionListener(new ActionListener((AbstractElement)mapType){
                    final /* synthetic */ AbstractElement val$elem;
                    {
                        this.val$elem = abstractElement;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapEditor.this.editElement(this.val$elem.getId());
                    }
                });
                removeElem.add(mapType.getId() + " [" + I18n.text((String)mapType.getType()) + "]").addActionListener(new ActionListener((AbstractElement)mapType){
                    final /* synthetic */ AbstractElement val$elem;
                    {
                        this.val$elem = abstractElement;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapEditor.this.removeElement(this.val$elem.getId());
                    }
                });
                if (this.renderer == null) continue;
                centerElem.add(mapType.getId() + " [" + I18n.text((String)mapType.getType()) + "]").addActionListener(new ActionListener((AbstractElement)mapType){
                    final /* synthetic */ AbstractElement val$elem;
                    {
                        this.val$elem = abstractElement;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapEditor.this.renderer.focusLocation(this.val$elem.getCenterLocation());
                    }
                });
            }
            MenuScroller.setScrollerFor((JMenu)editElem, (Component)((Object)this), (int)150, (int)0, (int)0);
            MenuScroller.setScrollerFor((JMenu)removeElem, (Component)((Object)this), (int)150, (int)0, (int)0);
            MenuScroller.setScrollerFor((JMenu)centerElem, (Component)((Object)this), (int)150, (int)0, (int)0);
            popup.addSeparator();
            popup.add(editElem);
            popup.add(centerElem);
            popup.add(removeElem);
            popup.addSeparator();
            JMenuItem undo = new JMenuItem(this.manager.getUndoPresentationName());
            undo.setEnabled(this.manager.canUndo());
            if (this.manager.canUndo()) {
                undo.setIcon(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/undo.png"));
            } else {
                undo.setIcon(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/undo_disabled.png"));
            }
            undo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapEditor.this.manager.undo();
                }
            });
            popup.add(undo);
            JMenuItem redo = new JMenuItem(this.manager.getRedoPresentationName());
            redo.setEnabled(this.manager.canRedo());
            if (this.manager.canRedo()) {
                redo.setIcon(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/redo.png"));
            } else {
                redo.setIcon(ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/map/redo_disabled.png"));
            }
            redo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapEditor.this.manager.redo();
                }
            });
            popup.add(redo);
            popup.show((Component)this.renderer, event.getX(), event.getY());
        }
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.mousePressed(event, source);
            return;
        }
        if (event.getButton() != 1) {
            return;
        }
        this.testMouseIntersections();
        if (!this.intersectedObjects.isEmpty()) {
            this.draggedObject = this.intersectedObjects.lastElement();
            this.orignalXML = this.draggedObject.asXML();
            this.originalObjLocation = new LocationType(this.draggedObject.getCenterLocation());
            Point2D center = source.getScreenPosition(this.originalObjLocation);
            Point clicked = event.getPoint();
            this.dragOffsets = new Point2D.Double(((Point2D)clicked).getX() - center.getX(), ((Point2D)clicked).getY() - center.getY());
            this.objectMoved = false;
        } else {
            this.adapter.mousePressed(event, source);
        }
        this.mousePoint = event.getPoint();
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.mouseDragged(event, source);
            return;
        }
        if (this.draggedObject != null) {
            if (event.isShiftDown() && this.draggedObject instanceof RotatableElement) {
                if (this.objectMoved) {
                    this.mouseReleased(event, source);
                }
                this.originalYaw = ((RotatableElement)this.draggedObject).getYaw();
                ((RotatableElement)this.draggedObject).rotateLeft(event.getPoint().getY() - this.mousePoint.getY());
                this.objectRotated = true;
                this.mousePoint = event.getPoint();
                return;
            }
            LocationType oldLoc = new LocationType(this.draggedObject.getCenterLocation());
            if (this.objectRotated) {
                this.mouseReleased(event, source);
            }
            LocationType newLoc = source.getRealWorldLocation((Point2D)event.getPoint());
            newLoc.translateInPixel(-this.dragOffsets.getX(), -this.dragOffsets.getY(), source.getLevelOfDetail());
            newLoc.setDepth(oldLoc.getDepth());
            this.draggedObject.setCenterLocation(newLoc);
            this.objectMoved = true;
            MapChangeEvent mce = new MapChangeEvent(0);
            mce.setSourceMap(this.draggedObject.getParentMap());
            mce.setChangedObject(this.draggedObject);
            mce.setMapGroup(this.draggedObject.getParentMap().getMapGroup());
            this.draggedObject.getParentMap().warnChangeListeners(mce);
        } else {
            this.adapter.mouseDragged(event, source);
        }
        this.mousePoint = event.getPoint();
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.mouseMoved(event, source);
            return;
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.mousePoint = event.getPoint();
        this.adapter.mouseMoved(event, source);
    }

    public void mouseExited(MouseEvent event, StateRenderer2D source) {
        this.adapter.mouseExited(event, source);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.mouseReleased(event, source);
            return;
        }
        this.adapter.mouseReleased(event, source);
        if (event.getButton() != 1) {
            return;
        }
        if (this.draggedObject != null) {
            if (this.pivot == null) {
                this.pivot = this.getPivot();
            }
            MapChangeEvent mce = new MapChangeEvent(0);
            mce.setSourceMap(this.pivot);
            mce.setChangedObject(this.draggedObject);
            this.pivot.warnChangeListeners(mce);
            ObjectPropertiesEdit edit = new ObjectPropertiesEdit(this.draggedObject, this.orignalXML);
            this.manager.addEdit(edit);
        }
        this.objectMoved = false;
        this.objectRotated = false;
        this.originalYaw = 0.0;
        this.draggedObject = null;
        this.originalObjLocation = null;
        this.mousePoint = event.getPoint();
    }

    public void wheelMoved(MouseWheelEvent event, StateRenderer2D source) {
        this.adapter.wheelMoved(event, source);
    }

    public void keyPressed(KeyEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.keyPressed(event, source);
            return;
        }
        this.adapter.keyPressed(event, source);
    }

    public void keyReleased(KeyEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.keyReleased(event, source);
            return;
        }
        this.adapter.keyReleased(event, source);
    }

    public void keyTyped(KeyEvent event, StateRenderer2D source) {
        if (this.currentInteraction != null) {
            this.currentInteraction.keyTyped(event, source);
            return;
        }
        this.adapter.keyTyped(event, source);
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        this.adapter.setActive(mode, source);
        this.mg = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission());
        if (mode) {
            source.setBorder((Border)new LineBorder(Color.orange.darker(), 3));
            Object c = source;
            while (((Component)c).getParent() != null && !(((Container)c).getLayout() instanceof BorderLayout)) {
                c = ((Component)c).getParent();
            }
            if (((Container)c).getLayout() instanceof BorderLayout) {
                switch (this.toolbarLocation) {
                    case Left: {
                        ((Container)c).add((Component)this.toolbar, "West");
                        this.toolbar.setOrientation(1);
                        break;
                    }
                    case Right: {
                        ((Container)c).add((Component)this.toolbar, "East");
                        this.toolbar.setOrientation(1);
                        break;
                    }
                    case Top: {
                        ((Container)c).add((Component)this.toolbar, "North");
                        this.toolbar.setOrientation(0);
                        break;
                    }
                    case Bottom: {
                        ((Container)c).add((Component)this.toolbar, "South");
                        this.toolbar.setOrientation(0);
                    }
                }
                ((Container)c).invalidate();
                ((Container)c).validate();
            }
        } else {
            Container parent = this.toolbar.getParent();
            try {
                parent.remove(this.toolbar);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Error removing toolbar of " + MapEditor.class.getSimpleName() + " from " + MapPanel.class.getSimpleName()), (Throwable)e);
            }
            parent.invalidate();
            parent.validate();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    LocationType oldCenter = MapEditor.this.renderer.getCenter();
                    MapEditor.this.getConsole().getMission().save(true);
                    MapEditor.this.getConsole().warnMissionListeners();
                    MapEditor.this.renderer.setCenter(oldCenter);
                    return null;
                }
            };
            worker.execute();
            source.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            if (this.toolbar.getParent() != null) {
                this.toolbar.getParent().remove(this.toolbar);
            }
        }
    }

    public void focusGained(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusGained(event, source);
    }

    public void focusLost(FocusEvent event, StateRenderer2D source) {
        this.adapter.focusLost(event, source);
    }

    public void setAssociatedSwitch(ToolbarSwitch tswitch) {
        this.associatedSwitch = tswitch;
    }

    public void initSubPanel() {
    }

    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
        this.adapter.paintInteraction(g, source);
    }

    public void cleanSubPanel() {
    }

    public static enum ControlsLocation {
        Left,
        Right,
        Top,
        Bottom;

    }
}

