/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.map.AbstractElement;

public class HideObjectEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected AbstractElement element;
    protected boolean wasVisible;
    protected int normalTransparency;

    public HideObjectEdit(AbstractElement element, boolean hide, int normalTransparency) {
        this.element = element;
        this.normalTransparency = normalTransparency;
        this.wasVisible = !hide;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.wasVisible) {
            this.element.setTransparency(this.normalTransparency);
        } else {
            this.element.setTransparency(0);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.wasVisible) {
            this.element.setTransparency(this.normalTransparency);
        } else {
            this.element.setTransparency(0);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        if (this.wasVisible) {
            return I18n.textf((String)"Hide '%element'", (Object[])new Object[]{this.element.getId()});
        }
        return I18n.textf((String)"Show '%element'", (Object[])new Object[]{this.element.getId()});
    }
}

