/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.edit;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;

public class MoveObjectEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    protected AbstractElement element;
    protected LocationType newLocation;
    protected LocationType oldLocation;

    public MoveObjectEdit(AbstractElement element, LocationType oldLocation) {
        this.element = element;
        this.oldLocation = new LocationType(oldLocation);
        this.newLocation = element instanceof LocatedManeuver ? new LocationType((LocationType)((LocatedManeuver)element).getManeuverLocation()) : new LocationType(oldLocation);
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.element instanceof LocatedManeuver) {
            this.element.setCenterLocation(this.oldLocation);
        }
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(this.element.getParentMap());
        mce.setChangedObject(this.element);
        mce.setMapGroup(this.element.getParentMap().getMapGroup());
        this.element.getParentMap().warnChangeListeners(mce);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.element instanceof LocatedManeuver) {
            this.element.setCenterLocation(this.newLocation);
        }
        MapChangeEvent mce = new MapChangeEvent(0);
        mce.setSourceMap(this.element.getParentMap());
        mce.setChangedObject(this.element);
        mce.setMapGroup(this.element.getParentMap().getMapGroup());
        this.element.getParentMap().warnChangeListeners(mce);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return I18n.textf((String)"Move '%element'", (Object[])new Object[]{this.element.getId()});
    }
}

