/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.interactions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.util.GuiUtils;

@LayerPriority(priority=60)
public class Box2DInteraction
extends InteractionAdapter
implements Renderer2DPainter {
    protected LocationType point1 = null;
    protected LocationType point2 = null;
    protected MapType pivot = null;
    protected UndoManager manager = null;

    public Box2DInteraction(MapType pivot, UndoManager manager, ConsoleLayout console) {
        super(console);
        this.pivot = pivot;
        this.manager = manager;
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (this.point1 == null) {
            this.point1 = source.getRealWorldLocation((Point2D)event.getPoint());
        }
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        super.mouseReleased(event, source);
        this.point2 = source.getRealWorldLocation((Point2D)event.getPoint());
        this.point1.convertToAbsoluteLatLonDepth();
        this.point2.convertToAbsoluteLatLonDepth();
        double lat = (this.point1.getLatitudeDegs() + this.point2.getLatitudeDegs()) / 2.0;
        double lon = (this.point1.getLongitudeDegs() + this.point2.getLongitudeDegs()) / 2.0;
        double[] offsets = this.point1.getOffsetFrom(this.point2);
        double width = Math.abs(offsets[1]);
        double length = Math.abs(offsets[0]);
        ParallelepipedElement element = new ParallelepipedElement(this.pivot.getMapGroup(), this.pivot);
        element.setWidth(width);
        element.setHeight(0.0);
        element.setLength(length);
        element.setColor(Color.red);
        element.setCenterLocation(new LocationType(lat, lon));
        this.pivot.addObject((AbstractElement)element);
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)element);
        changeEvent.setSourceMap(this.pivot);
        AddObjectEdit edit = new AddObjectEdit((AbstractElement)element);
        this.manager.addEdit(edit);
        this.pivot.warnChangeListeners(changeEvent);
        if (this.getAssociatedSwitch() != null) {
            this.getAssociatedSwitch().doClick();
        }
        this.point2 = null;
        this.point1 = null;
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.point1 != null) {
            this.point2 = source.getRealWorldLocation((Point2D)event.getPoint());
            source.repaint();
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.point1 != null && this.point2 != null) {
            double[] offsets = this.point1.getOffsetFrom(this.point2);
            double w = Math.abs(offsets[1]);
            double h = Math.abs(offsets[0]);
            g.setColor(Color.red.darker());
            g.setFont(new Font("Helvetica", 1, 14));
            g.drawString(I18n.textf((String)"Width: %width m", (Object[])new Object[]{GuiUtils.getNeptusDecimalFormat((int)1).format(w)}), 55, 20);
            g.drawString(I18n.textf((String)"Height: %height m", (Object[])new Object[]{GuiUtils.getNeptusDecimalFormat((int)1).format(h)}), 55, 35);
            Point2D pt1 = renderer.getScreenPosition(this.point1);
            Point2D pt2 = renderer.getScreenPosition(this.point2);
            double top = Math.min(pt1.getY(), pt2.getY());
            double left = Math.min(pt1.getX(), pt2.getX());
            double width = Math.abs(pt1.getX() - pt2.getX());
            double length = Math.abs(pt1.getY() - pt2.getY());
            Rectangle2D.Double rect = new Rectangle2D.Double(left, top, width, length);
            g.setColor(Color.red);
            g.draw(rect);
            g.setColor(new Color(255, 0, 0, 200));
            g.fill(rect);
        }
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        super.setActive(mode, source);
        if (mode) {
            source.addPostRenderPainter((Renderer2DPainter)this, I18n.text((String)"Box 2d painter"));
        } else {
            source.removePostRenderPainter((Renderer2DPainter)this);
        }
    }
}

