/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.interactions;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PathElement;

public class DrawPathInteraction
extends InteractionAdapter {
    private static final long serialVersionUID = 1L;
    protected MapType pivot;
    protected PathElement curDrawing = null;
    protected UndoManager undoManager = null;

    public DrawPathInteraction(MapType pivot, UndoManager undoManager, ConsoleLayout console) {
        super(console);
        this.pivot = pivot;
        this.undoManager = undoManager;
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 1) {
            super.mousePressed(event, source);
            return;
        }
        LocationType lt = source.getRealWorldLocation((Point2D)event.getPoint());
        this.curDrawing = new PathElement(this.pivot.getMapGroup(), this.pivot, lt);
        this.curDrawing.addPoint(0.0, 0.0, 0.0, false);
        this.pivot.addObject((AbstractElement)this.curDrawing);
        MapChangeEvent changeEvent = new MapChangeEvent(2);
        changeEvent.setChangedObject((AbstractElement)this.curDrawing);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 1) {
            super.mouseReleased(event, source);
            return;
        }
        this.curDrawing.setFinished(true);
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.curDrawing);
        changeEvent.setSourceMap(this.pivot);
        AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.curDrawing);
        this.undoManager.addEdit(edit);
        this.pivot.warnChangeListeners(changeEvent);
        this.curDrawing = null;
        if (this.associatedSwitch != null) {
            this.associatedSwitch.doClick();
        }
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.curDrawing == null) {
            super.mouseDragged(event, source);
            return;
        }
        double[] offsets = this.curDrawing.getCenterLocation().getOffsetFrom(source.getRealWorldLocation((Point2D)event.getPoint()));
        this.curDrawing.addPoint(-offsets[1], -offsets[0], 0.0, false);
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.curDrawing);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        if (!mode && this.curDrawing != null) {
            this.curDrawing.setFinished(true);
            MapChangeEvent changeEvent = new MapChangeEvent(0);
            changeEvent.setChangedObject((AbstractElement)this.curDrawing);
            changeEvent.setSourceMap(this.pivot);
            AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.curDrawing);
            this.undoManager.addEdit(edit);
            this.pivot.warnChangeListeners(changeEvent);
        }
    }

    public boolean isExclusive() {
        return true;
    }
}

