/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.interactions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.LineSegmentElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.util.GuiUtils;

@LayerPriority(priority=60)
public class LineInteraction
extends InteractionAdapter
implements Renderer2DPainter {
    private static final long serialVersionUID = -3574806724182214294L;
    protected MapType pivot;
    protected LineSegmentElement element = null;
    protected UndoManager undoManager = null;

    public LineInteraction(MapType pivot, UndoManager undoManager, ConsoleLayout console) {
        super(console);
        this.pivot = pivot;
        this.undoManager = undoManager;
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 1) {
            super.mousePressed(event, source);
            return;
        }
        LocationType lt = source.getRealWorldLocation((Point2D)event.getPoint());
        this.element = new LineSegmentElement(this.pivot.getMapGroup(), this.pivot);
        this.element.setCenterLocation(lt);
        this.element.length = 0.0;
        this.pivot.addObject((AbstractElement)this.element);
        MapChangeEvent changeEvent = new MapChangeEvent(2);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        super.mouseReleased(event, source);
        if (this.element == null) {
            return;
        }
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
        this.undoManager.addEdit(edit);
        this.pivot.warnChangeListeners(changeEvent);
        this.element = null;
        if (this.associatedSwitch != null) {
            this.associatedSwitch.doClick();
        }
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        double length;
        if (this.element == null) {
            super.mouseDragged(event, source);
            return;
        }
        this.element.length = length = source.getRealWorldLocation((Point2D)event.getPoint()).getDistanceInMeters(this.element.getCenterLocation());
        this.element.setYawDeg(Math.toDegrees(this.element.getCenterLocation().getXYAngle(source.getRealWorldLocation((Point2D)event.getPoint()))));
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
        source.repaint();
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        if (!mode && this.element != null) {
            MapChangeEvent changeEvent = new MapChangeEvent(0);
            changeEvent.setChangedObject((AbstractElement)this.element);
            changeEvent.setSourceMap(this.pivot);
            AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
            this.undoManager.addEdit(edit);
            this.pivot.warnChangeListeners(changeEvent);
        }
        if (mode) {
            source.addPostRenderPainter((Renderer2DPainter)this, I18n.text((String)"Line Segment"));
        } else {
            source.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    public boolean isExclusive() {
        return true;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Graphics2D g2 = (Graphics2D)g.create();
        double l = this.element != null ? Math.abs(this.element.length) : 0.0;
        double bearing = this.element != null ? this.element.getYawDeg() : 0.0;
        g2.setColor(Color.red.darker());
        g2.setFont(new Font("Helvetica", 1, 14));
        g2.drawString(I18n.textf((String)"Length: %radius m", (Object[])new Object[]{GuiUtils.getNeptusDecimalFormat((int)1).format(l)}), 55, 20);
        g2.drawString(I18n.textf((String)"Bearing: %bearing \u00b0", (Object[])new Object[]{GuiUtils.getNeptusDecimalFormat((int)1).format(bearing)}), 55, 40);
        g2.dispose();
    }
}

