/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.interactions;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.MineDangerAreaElement;
import pt.lsts.neptus.util.GuiUtils;

@LayerPriority(priority=60)
public class MineDangerAreaInteraction
extends InteractionAdapter
implements Renderer2DPainter {
    private static final long serialVersionUID = -3574806724182214294L;
    protected MapType pivot;
    protected MineDangerAreaElement element = null;
    protected UndoManager undoManager = null;

    public MineDangerAreaInteraction(MapType pivot, UndoManager undoManager, ConsoleLayout console) {
        super(console);
        this.pivot = pivot;
        this.undoManager = undoManager;
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 1) {
            super.mousePressed(event, source);
            return;
        }
        LocationType lt = source.getRealWorldLocation((Point2D)event.getPoint());
        this.element = new MineDangerAreaElement(this.pivot.getMapGroup(), this.pivot);
        this.element.setCenterLocation(lt);
        this.element.radius = 0.0;
        if (event.isControlDown()) {
            this.element.filled = false;
        }
        this.pivot.addObject((AbstractElement)this.element);
        MapChangeEvent changeEvent = new MapChangeEvent(2);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        super.mouseReleased(event, source);
        if (this.element == null) {
            return;
        }
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
        this.undoManager.addEdit(edit);
        this.pivot.warnChangeListeners(changeEvent);
        this.element = null;
        if (this.associatedSwitch != null) {
            this.associatedSwitch.doClick();
        }
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        double radius;
        if (this.element == null) {
            super.mouseDragged(event, source);
            return;
        }
        this.element.radius = radius = source.getRealWorldLocation((Point2D)event.getPoint()).getDistanceInMeters(this.element.getCenterLocation());
        MapChangeEvent changeEvent = new MapChangeEvent(0);
        changeEvent.setChangedObject((AbstractElement)this.element);
        changeEvent.setSourceMap(this.pivot);
        this.pivot.warnChangeListeners(changeEvent);
        source.repaint();
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        if (!mode && this.element != null) {
            MapChangeEvent changeEvent = new MapChangeEvent(0);
            changeEvent.setChangedObject((AbstractElement)this.element);
            changeEvent.setSourceMap(this.pivot);
            AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
            this.undoManager.addEdit(edit);
            this.pivot.warnChangeListeners(changeEvent);
        }
        if (mode) {
            source.addPostRenderPainter((Renderer2DPainter)this, I18n.text((String)"Mine Danger Area"));
        } else {
            source.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    public boolean isExclusive() {
        return true;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        Graphics2D g2 = (Graphics2D)g.create();
        double r = this.element != null ? Math.abs(this.element.radius) : 0.0;
        g2.setColor(Color.red.darker());
        g2.setFont(new Font("Helvetica", 1, 14));
        g2.drawString(I18n.textf((String)"Radius: %radius m", (Object[])new Object[]{GuiUtils.getNeptusDecimalFormat((int)1).format(r)}), 55, 20);
        g2.dispose();
    }
}

