/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.map.interactions;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.plugins.map.edit.AddObjectEdit;
import pt.lsts.neptus.renderer2d.InteractionAdapter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.AbstractElement;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PathElement;

public class PolygonInteraction
extends InteractionAdapter {
    private static final long serialVersionUID = 1L;
    protected MapType pivot;
    protected PathElement element = null;
    protected UndoManager undoManager = null;
    protected boolean fill = false;

    public PolygonInteraction(MapType pivot, UndoManager undoManager, boolean fill, ConsoleLayout console) {
        super(console);
        this.pivot = pivot;
        this.fill = fill;
        this.undoManager = undoManager;
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 1) {
            if (this.element != null) {
                MapChangeEvent changeEvent = new MapChangeEvent(0);
                changeEvent.setChangedObject((AbstractElement)this.element);
                changeEvent.setSourceMap(this.pivot);
                AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
                this.element.setFinished(true);
                this.undoManager.addEdit(edit);
                this.pivot.warnChangeListeners(changeEvent);
                this.element = null;
                if (this.associatedSwitch != null) {
                    this.associatedSwitch.doClick();
                }
            }
            super.mousePressed(event, source);
            return;
        }
        LocationType lt = source.getRealWorldLocation((Point2D)event.getPoint());
        if (this.element == null) {
            this.element = new PathElement(this.pivot.getMapGroup(), this.pivot, lt);
            this.element.setFill(this.fill);
            this.element.setShape(this.fill);
            this.pivot.addObject((AbstractElement)this.element);
            this.element.addPoint(0.0, 0.0, 0.0, false);
            MapChangeEvent changeEvent = new MapChangeEvent(2);
            changeEvent.setChangedObject((AbstractElement)this.element);
            changeEvent.setSourceMap(this.pivot);
            this.pivot.warnChangeListeners(changeEvent);
        } else {
            double[] offsets = this.element.getCenterLocation().getOffsetFrom(source.getRealWorldLocation((Point2D)event.getPoint()));
            this.element.addPoint(-offsets[1], -offsets[0], 0.0, false);
            MapChangeEvent changeEvent = new MapChangeEvent(0);
            changeEvent.setChangedObject((AbstractElement)this.element);
            changeEvent.setSourceMap(this.pivot);
            this.pivot.warnChangeListeners(changeEvent);
        }
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        if (!mode && this.element != null) {
            MapChangeEvent changeEvent = new MapChangeEvent(0);
            changeEvent.setChangedObject((AbstractElement)this.element);
            changeEvent.setSourceMap(this.pivot);
            AddObjectEdit edit = new AddObjectEdit((AbstractElement)this.element);
            this.undoManager.addEdit(edit);
            this.element.setFinished(true);
            this.pivot.warnChangeListeners(changeEvent);
        }
    }

    public boolean isExclusive() {
        return true;
    }
}

