/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.cefx3d.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.web3d.cefx3d.model.StylesheetCache;
import org.web3d.cefx3d.model.ToolData;
import org.web3d.cefx3d.model.WorldModel;
import org.web3d.cefx3d.property.PropertyEditor;
import org.web3d.cefx3d.property.PropertyListener;
import org.web3d.cefx3d.toolbar.ToolBar;
import org.web3d.cefx3d.toolbar.ToolBarListener;
import org.web3d.cefx3d.toolbar.ToolInstance;
import org.web3d.cefx3d.view.View;
import org.web3d.cefx3d.view.ViewListener;

public class DefaultWorldModel
implements WorldModel,
ToolBarListener,
ViewListener,
PropertyListener {
    private View[] views;
    private PropertyEditor[] editors;
    private ToolInstance currentTool;
    private ToolData[] toolValues = new ToolData[50];
    private int lastToolValue;

    public void addToolBar(ToolBar toolBar) {
        toolBar.addToolBarListener(this);
    }

    public void addPropertyEditor(PropertyEditor propertyEditor) {
        if (this.editors == null) {
            this.editors = new PropertyEditor[1];
            this.editors[0] = propertyEditor;
        } else {
            int n = this.editors.length;
            PropertyEditor[] propertyEditorArray = this.editors;
            this.editors = new PropertyEditor[n + 1];
            for (int i = 0; i < n; ++i) {
                this.editors[i] = propertyEditorArray[i];
            }
            this.editors[n] = propertyEditor;
        }
        propertyEditor.addPropertyListener(this);
    }

    public void addView(View view) {
        if (this.views == null) {
            this.views = new View[1];
            this.views[0] = view;
        } else {
            int n = this.views.length;
            View[] viewArray = this.views;
            this.views = new View[n + 1];
            for (int i = 0; i < n; ++i) {
                this.views[i] = viewArray[i];
            }
            this.views[n] = view;
        }
        view.addViewListener(this);
    }

    public void removeToolBar(ToolBar toolBar) {
    }

    public void removePropertyEditor(PropertyEditor propertyEditor) {
    }

    public void removeView(View view) {
    }

    public void saveX3D(String string) {
        int n = this.lastToolValue + 1;
        float[] fArray = new float[3];
        try {
            Object object;
            CharSequence charSequence;
            Object object2;
            Object object3;
            FileWriter fileWriter = new FileWriter(string);
            StringWriter stringWriter = new StringWriter(1024);
            StreamResult streamResult = new StreamResult(stringWriter);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fileWriter.write("<X3D profile=\"Immersive\">\n");
            fileWriter.write("   <Scene>\n");
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                object3 = this.toolValues[i];
                if (object3 == null) continue;
                ((ToolData)object3).getPosition(fArray);
                object2 = ((ToolData)object3).getTool();
                bl = false;
                HashMap hashMap = ((ToolInstance)object2).getStylesheets();
                charSequence = (String)hashMap.get("x3d");
                try {
                    Object object4;
                    Object object5;
                    if (charSequence == null) {
                        charSequence = (String)hashMap.get("default");
                        bl = true;
                    } else {
                        object5 = new File((String)charSequence);
                        if (!((File)object5).exists()) {
                            charSequence = (String)hashMap.get("default");
                            bl = true;
                        }
                    }
                    object5 = StylesheetCache.newTransformer((String)charSequence);
                    object = (Document)((ToolData)object3).getProperties();
                    Element element = null;
                    NodeList nodeList = object.getElementsByTagName("Transform");
                    if (nodeList.getLength() <= 0) {
                        Element element2;
                        element = object.createElement("Transform");
                        object4 = object.getDocumentElement();
                        if (object4 == null) {
                            element2 = object.createElement("EntityDefinition");
                            object.appendChild(element2);
                            object4 = element2;
                        }
                        object4.appendChild(element);
                        if (bl) {
                            element2 = object.createElement("Inline");
                            element2.setAttribute("url", this.convertStringArrayToMFString(((ToolInstance)object2).getURL()));
                            object4.appendChild(element2);
                        }
                    } else {
                        element = (Element)nodeList.item(0);
                    }
                    element.setAttribute("translation", Float.toString(fArray[0]) + " " + Float.toString(fArray[1]) + " " + Float.toString(fArray[2]));
                    object4 = new DOMSource((Node)object);
                    ((Transformer)object5).transform((Source)object4, streamResult);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            String string2 = stringWriter.toString();
            object3 = new BufferedReader(new StringReader(string2));
            charSequence = new StringBuffer(string2.length());
            while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                int n2 = ((String)object2).indexOf("<?xml");
                if (n2 < 0) {
                    ((StringBuffer)charSequence).append((String)object2);
                    ((StringBuffer)charSequence).append("\n");
                    continue;
                }
                object = ((String)object2).substring(0, n2);
                ((StringBuffer)charSequence).append((String)object);
                ((StringBuffer)charSequence).append("\n");
            }
            fileWriter.write(((StringBuffer)charSequence).toString());
            fileWriter.write("   </Scene>\n");
            fileWriter.write("</X3D>\n");
            stringWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveSMAL(String string) {
    }

    public void toolSelected(ToolInstance toolInstance) {
        int n = this.views.length;
        this.currentTool = toolInstance;
        for (int i = 0; i < n; ++i) {
            this.views[i].setTool(toolInstance);
        }
    }

    public void propertyChanged(int n, String string, Object object, Node node) {
        System.out.println("Property changed: " + string + " newValue: " + object);
        ToolData toolData = this.toolValues[n];
        toolData.setProperties(node);
    }

    public void entityAdded(int n, float f, float f2, float f3, ToolInstance toolInstance) {
        int n2;
        System.out.println("Entity Added: " + n + " url: " + toolInstance.getURL() + " x: " + f + " y:" + f2 + " z: " + f3);
        ToolData toolData = new ToolData(new float[]{f, f2, f3}, new float[4], toolInstance);
        if (n > this.toolValues.length) {
            ToolData[] toolDataArray = new ToolData[n * 2];
            n2 = this.toolValues.length;
            for (int i = 0; i < n2; ++i) {
                toolDataArray[i] = this.toolValues[i];
            }
            this.toolValues = toolDataArray;
        }
        this.toolValues[n] = toolData;
        this.lastToolValue = n;
        n2 = this.editors.length;
        for (int i = 0; i < n2; ++i) {
            this.editors[i].addEntity(n, toolInstance.getDefaults());
        }
    }

    public void entityRemoved(int n) {
        this.toolValues[n] = null;
        int n2 = this.editors.length;
        for (int i = 0; i < n2; ++i) {
            this.editors[i].removeEntity(n);
        }
    }

    public void entityMoved(int n, float f, float f2, float f3) {
        ToolData toolData = this.toolValues[n];
        toolData.setPosition(new float[]{f, f2, f3});
    }

    public void entityRotated(int n, float f, float f2, float f3, float f4) {
    }

    public void entitySelected(int n) {
        System.out.println("Entity Selected: " + n);
        int n2 = this.editors.length;
        for (int i = 0; i < n2; ++i) {
            this.editors[i].displayEntity(n);
        }
    }

    private void printDOM(Node node) {
        try {
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(System.out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String convertStringArrayToMFString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }
}

