/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.cefx3d.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.web3d.cefx3d.model.TemplateEntry;

public class StylesheetCache {
    private static Map cache = new HashMap();

    public static synchronized void flushAll() {
        cache.clear();
    }

    public static synchronized void flush(String string) {
        cache.remove(string);
    }

    public static synchronized Transformer newTransformer(String string) throws TransformerConfigurationException {
        File file = new File(string);
        long l = file.lastModified();
        TemplateEntry templateEntry = (TemplateEntry)cache.get(string);
        if (templateEntry != null && l > templateEntry.lastModified) {
            templateEntry = null;
        }
        if (templateEntry == null) {
            StreamSource streamSource = new StreamSource(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(streamSource);
            templateEntry = new TemplateEntry(l, templates);
            cache.put(string, templateEntry);
        }
        return templateEntry.templates.newTransformer();
    }

    private StylesheetCache() {
    }
}

