/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.cefx3d.property;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.web3d.cefx3d.property.PanelItem;
import org.web3d.cefx3d.property.PropertyEditor;
import org.web3d.cefx3d.property.PropertyListener;
import org.web3d.cefx3d.ui.DynamicGridLayout;
import org.web3d.util.IntHashMap;

public class DefaultPropertyEditor
extends JPanel
implements PropertyEditor,
ActionListener,
DocumentListener,
PropertyChangeListener {
    private static final int MAX_TEXTFIELD_WIDTH = 10;
    private JPanel propPanel;
    private JPanel spacingPanel;
    private JPanel spacingPanel2;
    private JPanel propHolder = new JPanel(new BorderLayout());
    private JScrollPane scrollPane;
    private IntHashMap entityMap;
    private ArrayList panelItems;
    private int maxCol;
    private int numRows;
    private ArrayList changeListeners;
    private HashMap editingComponentMap;
    private HashMap editingNodeMap;
    private HashMap documentMap;
    private boolean componentChanged;
    private Component currentComponent;
    private int currentEntityID;

    public DefaultPropertyEditor() {
        this.propPanel = new JPanel();
        this.spacingPanel = new JPanel();
        this.spacingPanel2 = new JPanel();
        this.changeListeners = new ArrayList();
        this.setLayout(new BorderLayout());
        this.propHolder.add((Component)this.propPanel, "North");
        this.propHolder.add((Component)this.spacingPanel2, "Center");
        this.add((Component)this.propHolder, "West");
        this.add((Component)this.spacingPanel, "Center");
        this.entityMap = new IntHashMap();
        this.panelItems = new ArrayList(50);
        this.editingComponentMap = new HashMap(50);
        this.editingNodeMap = new HashMap(50);
        this.documentMap = new HashMap(50);
        JLabel jLabel = new JLabel("Property Editor");
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setPreferredSize(new Dimension(400, 512));
        this.add((Component)jLabel, "North");
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!this.changeListeners.contains(propertyListener)) {
            this.changeListeners.add(propertyListener);
        }
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.changeListeners.remove(propertyListener);
    }

    public void displayEntity(int n) {
        this.currentEntityID = n;
        org.w3c.dom.Document document = (org.w3c.dom.Document)this.entityMap.get(n);
        if (document == null) {
            this.propPanel.removeAll();
            this.forceRepaint();
            this.currentEntityID = -1;
            System.out.println("Unknown entity, clearing");
        } else {
            System.out.println("Displaying panel for: " + n + " doc: " + document);
            this.createPanel(document);
        }
    }

    public void addEntity(int n, org.w3c.dom.Document document) {
        if (document == null) {
            System.out.println("No properties to edit");
            this.entityMap.put(n, null);
        } else {
            Node node = document.cloneNode(true);
            this.entityMap.put(n, node);
            this.createPanel(node);
            this.firePropertyChanged(n, "", null, node);
        }
        this.currentEntityID = n;
    }

    public void removeEntity(int n) {
        this.propPanel.removeAll();
        this.forceRepaint();
        this.currentEntityID = -1;
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        String string = (String)this.editingComponentMap.get(jTextField);
        Node node = (Node)this.entityMap.get(this.currentEntityID);
        Node node2 = (Node)this.editingNodeMap.get(jTextField);
        System.out.println("Change: " + string + " n: " + node2);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.componentChanged = true;
        Document document = documentEvent.getDocument();
        this.currentComponent = (Component)this.documentMap.get(document);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.componentChanged = true;
        Document document = documentEvent.getDocument();
        this.currentComponent = (Component)this.documentMap.get(document);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.componentChanged = true;
        Document document = documentEvent.getDocument();
        this.currentComponent = (Component)this.documentMap.get(document);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("focusOwner".equals(string) && propertyChangeEvent.getNewValue() != null) {
            Component component = (Component)propertyChangeEvent.getNewValue();
            if (this.componentChanged) {
                Object object = propertyChangeEvent.getSource();
                String string2 = (String)this.editingComponentMap.get(this.currentComponent);
                Node node = (Node)this.entityMap.get(this.currentEntityID);
                Node node2 = (Node)this.editingNodeMap.get(this.currentComponent);
                String string3 = ((JTextField)this.currentComponent).getText();
                if (node2 instanceof Text) {
                    ((Text)node2).setData(string3);
                } else if (node2 instanceof Attr) {
                    ((Attr)node2).setValue(string3);
                }
                System.out.println("Change: " + string2);
                this.firePropertyChanged(this.currentEntityID, string2, string3, node);
            }
            this.componentChanged = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createPanel(Node node) {
        Node node2;
        this.panelItems.clear();
        this.maxCol = 1;
        this.numRows = 0;
        NodeList nodeList = node.getChildNodes();
        Node node3 = nodeList.item(0);
        if (node3 == null) {
            this.propPanel.removeAll();
            this.revalidate();
            Container container = this.getParent();
            container.validate();
            this.repaint();
            return;
        }
        nodeList = node3.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            this.addElement((Element)node2, 0);
        }
        n = this.panelItems.size();
        this.propPanel.removeAll();
        DynamicGridLayout dynamicGridLayout = new DynamicGridLayout(this.numRows, this.maxCol, 0, 0);
        for (int i = 0; i < this.numRows; ++i) {
            dynamicGridLayout.setRowSize(i, -1);
        }
        this.propPanel.setLayout(dynamicGridLayout);
        String[] stringArray = new String[this.maxCol];
        System.out.println("Panel Items: " + n + " maxCol: " + this.maxCol);
        int n2 = 0;
        while (true) {
            block16: {
                int n3;
                if (n2 >= n) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.addPropertyChangeListener(this);
                    this.forceRepaint();
                    return;
                }
                PanelItem panelItem = (PanelItem)this.panelItems.get(n2);
                int n4 = panelItem.getCol();
                int n5 = panelItem.getType();
                String string = (String)panelItem.getValue();
                node2 = panelItem.getNode();
                for (n3 = 0; n3 < n4; ++n3) {
                    this.propPanel.add(new JLabel());
                }
                switch (n5) {
                    case 0: {
                        this.propPanel.add(new JLabel(string));
                        stringArray[n4] = string;
                        panelItem = (PanelItem)this.panelItems.get(n2 + 1);
                        n5 = panelItem.getType();
                        if (n5 != 1) break;
                        string = (String)panelItem.getValue();
                        node2 = panelItem.getNode();
                        n3 = string.length();
                        if (n3 > 10) {
                            n3 = 10;
                        }
                        JTextField jTextField = new JTextField(string, n3);
                        jTextField.addActionListener(this);
                        Document document = jTextField.getDocument();
                        document.addDocumentListener(this);
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < n4 + 1; ++i) {
                            stringBuffer.append(stringArray[i]);
                            if (i == n4) continue;
                            stringBuffer.append(".");
                        }
                        String string2 = stringBuffer.toString();
                        this.editingComponentMap.put(jTextField, string2);
                        this.editingNodeMap.put(jTextField, node2);
                        this.documentMap.put(document, jTextField);
                        this.propPanel.add(jTextField);
                        ++n2;
                        for (int i = n4 + 2; i < this.maxCol; ++i) {
                            this.propPanel.add(new JLabel());
                        }
                        break block16;
                    }
                    case 1: {
                        n3 = string.length();
                        if (n3 > 10) {
                            n3 = 10;
                        }
                        JTextField jTextField = new JTextField(string, n3);
                        jTextField.addActionListener(this);
                        Document document = jTextField.getDocument();
                        document.addDocumentListener(this);
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < n4 + 1; ++i) {
                            stringBuffer.append(stringArray[i]);
                            if (i == n4) continue;
                            stringBuffer.append(".");
                        }
                        String string2 = stringBuffer.toString();
                        this.editingComponentMap.put(jTextField, string2);
                        this.editingNodeMap.put(jTextField, node2);
                        this.documentMap.put(document, jTextField);
                        this.propPanel.add(jTextField);
                    }
                }
                for (n3 = n4 + 1; n3 < this.maxCol; ++n3) {
                    this.propPanel.add(new JLabel());
                }
            }
            ++n2;
        }
    }

    private void addElement(Element element, int n) {
        this.addItem(0, n, element, element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        int n3 = n + 1;
        for (int i = 0; i < n2; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            this.addItem(0, n3, attr, attr.getName());
            this.addText(attr, attr.getValue(), n3 + 1);
        }
        NodeList nodeList = element.getChildNodes();
        n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                this.addElement((Element)node, n3);
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.addText(node, ((Text)node).getData(), n3);
        }
    }

    private void addText(Node node, String string, int n) {
        if (string.trim().length() > 0) {
            this.addItem(1, n, node, string);
        }
    }

    private void addItem(int n, int n2, Node node, Object object) {
        if (n2 + 1 > this.maxCol) {
            this.maxCol = n2 + 1;
        }
        this.panelItems.add(new PanelItem(n, n2, node, object));
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + "   ";
        }
        System.out.print(string);
        if (n == 0) {
            ++this.numRows;
        }
    }

    private void firePropertyChanged(int n, String string, Object object, Node node) {
        int n2 = this.changeListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                PropertyListener propertyListener = (PropertyListener)this.changeListeners.get(i);
                propertyListener.propertyChanged(n, string, object, node);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending propertyChanged: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void forceRepaint() {
        this.revalidate();
        Container container = this.getParent();
        container.validate();
        this.repaint();
    }
}

