/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.cefx3d.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class DynamicGridLayout
implements LayoutManager,
Serializable {
    public static final int DYNAMIC = 0;
    public static final int MINIMUM = -1;
    public static final int ABOVE_MINIMUM = -2;
    public static final int BELOW_MINIMUM = -3;
    private static final int ABOVE_MARKER = -5;
    private static final int BELOW_MARKER = -6;
    public static final int FILL = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    public static final int LABEL_FILL = 6;
    public static final int LABEL_MIN = 7;
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;
    private int[] row_align;
    private int[] col_align;
    private int[] row_size;
    private int[] col_size;
    private int[] row_height;
    private int[] col_width;
    private int vert_align = 1;
    private int horiz_align = 1;

    public DynamicGridLayout() {
        this(1, 0, 0, 0);
    }

    public DynamicGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public DynamicGridLayout(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
        this.resetGrid();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (n == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
        this.resetGrid();
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int n) {
        if (n == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = n;
        this.resetGrid();
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void resetGrid() {
        this.row_align = new int[this.rows];
        this.col_align = new int[this.cols];
        this.row_size = new int[this.rows];
        this.col_size = new int[this.cols];
    }

    public void setStyle(int n) {
        switch (n) {
            case 0: {
                this.setColumnAlignments(0, this.cols - 1, 0);
                this.setRowAlignments(0, this.rows - 1, 0);
                this.setColumnSizes(0, this.cols - 1, 0);
                this.setRowSizes(0, this.rows - 1, 0);
                break;
            }
            case 1: {
                this.setColumnAlignments(0, this.cols - 1, 1);
                this.setRowAlignments(0, this.rows - 1, 1);
                this.setColumnSizes(0, this.cols - 1, 0);
                this.setRowSizes(0, this.rows - 1, 0);
                break;
            }
            case 6: 
            case 7: {
                for (int i = 0; i < this.cols; i += 2) {
                    this.setColumnAlignment(i, 3);
                    this.setColumnSize(i, -1);
                    if (n == 6) {
                        this.setColumnAlignment(i + 1, 0);
                        this.setColumnSize(i + 1, 0);
                        continue;
                    }
                    this.setColumnAlignment(i + 1, 2);
                    this.setColumnSize(i + 1, -3);
                }
                break;
            }
        }
    }

    public void setHorizontalAlignment(int n) {
        this.horiz_align = n;
    }

    public void setVerticalAlignment(int n) {
        this.vert_align = n;
    }

    public void setRowAlignment(int n, int n2) {
        this.row_align[n] = n2;
    }

    public void setRowAlignments(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.row_align[i] = n3;
        }
    }

    public void setColumnAlignment(int n, int n2) {
        this.col_align[n] = n2;
    }

    public void setColumnAlignments(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.col_align[i] = n3;
        }
    }

    public void setRowSize(int n, int n2) {
        this.row_size[n] = n2;
    }

    public void setRowSizes(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.row_size[i] = n3;
        }
    }

    public void setColumnSize(int n, int n2) {
        this.col_size[n] = n2;
    }

    public void setColumnSizes(int n, int n2, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.col_size[i] = n3;
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private void getWidthsAndHeights(Container container, boolean bl) {
        int n = container.getComponentCount();
        this.col_width = new int[this.cols];
        this.row_height = new int[this.rows];
        for (int i = 0; i < n && i < this.rows * this.cols; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
            if (dimension.width > this.col_width[i % this.cols]) {
                this.col_width[i % this.cols] = dimension.width;
            }
            if (dimension.height <= this.row_height[i / this.cols]) continue;
            this.row_height[i / this.cols] = dimension.height;
        }
    }

    private int getMaximumSize(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        for (int i = 0; i < n5; ++i) {
            if (nArray[i] > 0) {
                n = nArray2[i] * 100 / nArray[i];
                if (n > n4) {
                    n4 = n;
                }
                n2 += nArray2[i];
                continue;
            }
            n3 += nArray2[i];
        }
        n = n3 * 100 / (100 - n2);
        if (n > n4) {
            n4 = n;
        }
        return n4;
    }

    private int spaceOut(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = n;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < n5; ++n2) {
            if (nArray[n2] > 0) {
                nArray2[n2] = n * nArray[n2] / 100;
                n6 -= nArray2[n2];
                continue;
            }
            if (nArray[n2] == 0 || nArray[n2] == -2 || nArray[n2] == -5) {
                if (nArray[n2] == -5) {
                    nArray[n2] = -2;
                }
                if (nArray[n2] != 0) {
                    bl = true;
                }
                n3 += nArray2[n2];
                ++n4;
                continue;
            }
            if (nArray[n2] == -6) {
                nArray[n2] = -3;
            }
            if (nArray[n2] != -1) {
                bl2 = true;
            }
            n6 -= nArray2[n2];
        }
        if (bl2) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] != -3 || (n6 + nArray2[n2]) / (n3 + nArray2[n2]) >= 1) continue;
                nArray[n2] = -6;
                n3 += nArray2[n2];
                n6 += nArray2[n2];
                ++n4;
            }
        }
        if (bl) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] != -2 || (n6 - nArray2[n2]) / (n3 - nArray2[n2]) >= 1) continue;
                nArray[n2] = -5;
                n3 -= nArray2[n2];
                n6 -= nArray2[n2];
                --n4;
            }
        }
        if (n4 > 0) {
            n2 = n6;
            int n7 = -1;
            for (int i = 0; i < n5; ++i) {
                if (nArray[i] != 0 && nArray[i] != -6 && nArray[i] != -2) continue;
                nArray2[i] = n3 == 0 ? 0 : Math.round(nArray2[i] * n6 / n3);
                n2 -= nArray2[i];
                n7 = i;
            }
            int n8 = n7;
            nArray2[n8] = nArray2[n8] + n2;
            return 0;
        }
        if (n6 < 0) {
            return 0;
        }
        return n6;
    }

    private void placeComponent(Component component, int n, int n2, int n3, int n4, int n5, int n6) {
        Dimension dimension = component.getPreferredSize();
        if (n5 != 0 && dimension.height < n4) {
            if (n5 == 1) {
                n2 = (int)((long)n2 + Math.round((double)(n4 - dimension.height) / 2.0));
            } else if (n5 == 5) {
                n2 += n4 - dimension.height;
            }
            n4 = dimension.height;
        }
        if (n6 != 0 && dimension.width < n3) {
            if (n6 == 1) {
                n = (int)((long)n + Math.round((double)(n3 - dimension.width) / 2.0));
            } else if (n6 == 3) {
                n += n3 - dimension.width;
            }
            n3 = dimension.width;
        }
        component.setBounds(n, n2, n3, n4);
    }

    public Dimension preferredLayoutSize(Container container) {
        this.getWidthsAndHeights(container, true);
        int n = this.getMaximumSize(this.col_size, this.col_width);
        int n2 = this.getMaximumSize(this.row_size, this.row_height);
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n2 + (this.rows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.getWidthsAndHeights(container, false);
        int n = this.getMaximumSize(this.col_size, this.col_width);
        int n2 = this.getMaximumSize(this.row_size, this.row_height);
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n2 + (this.rows - 1) * this.vgap);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        Dimension dimension = container.getSize();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = dimension.height - (insets.top + insets.bottom);
        this.getWidthsAndHeights(container, true);
        int n4 = this.spaceOut(n3 -= (this.rows - 1) * this.vgap, this.row_size, this.row_height);
        int n5 = this.spaceOut(n2 -= (this.cols - 1) * this.hgap, this.col_size, this.col_width);
        int n6 = 0;
        switch (this.horiz_align) {
            case 1: {
                n6 = (int)Math.round((double)n5 / 2.0);
                break;
            }
            case 3: {
                n6 = n5;
            }
        }
        int n7 = 0;
        switch (this.vert_align) {
            case 1: {
                n7 = (int)Math.round((double)n4 / 2.0);
                break;
            }
            case 5: {
                n7 = n4;
            }
        }
        int n8 = 0;
        int n9 = insets.left + n6;
        while (n8 < this.cols) {
            int n10 = 0;
            int n11 = insets.top + n7;
            while (n10 < this.rows) {
                int n12 = n10 * this.cols + n8;
                if (n12 < n) {
                    this.placeComponent(container.getComponent(n12), n9, n11, this.col_width[n8], this.row_height[n10], this.row_align[n10], this.col_align[n8]);
                }
                n11 += this.row_height[n10++] + this.vgap;
            }
            n9 += this.col_width[n8++] + this.hgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

