/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.cefx3d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.web3d.cefx3d.toolbar.ToolDescriptor;
import org.web3d.cefx3d.toolbar.ToolInstance;
import org.web3d.cefx3d.view.EntityIDManager;
import org.web3d.cefx3d.view.EntityInstance;
import org.web3d.cefx3d.view.View;
import org.web3d.cefx3d.view.ViewListener;

public class PictureView
extends JPanel
implements View,
MouseMotionListener,
MouseListener,
KeyListener {
    private JScrollPane scrollPane;
    private ArrayList viewListeners = new ArrayList(1);
    private HashMap imageMap;
    private Image toolImage;
    private ToolInstance currentTool;
    private Image mapImage;
    private int mouseX;
    private int mouseY;
    private ArrayList entities = new ArrayList(100);
    private AffineTransform toolTransform = new AffineTransform();
    private Cursor blankCursor;
    private boolean insideMap;
    private EntityInstance currentEntity;
    private boolean entityDragging;
    private float xFactor;
    private float yFactor;
    private float xPos;
    private float yPos;
    private boolean swap;
    private float width;
    private float length;
    private float iconScaleX;
    private float iconScaleY;
    private int iconCenterX;
    private int iconCenterY;
    private String imgDir;
    private float[] pos;
    private boolean showIconCenter = false;

    public PictureView() {
        super(new BorderLayout());
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setPreferredSize(new Dimension(512, 512));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.scrollPane.addKeyListener(this);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.addKeyListener(this);
        this.imageMap = new HashMap();
        Image image = new ImageIcon("src/atfp/blankCursor").getImage();
        this.blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(), null);
        this.pos = new float[3];
        this.xPos = 0.0f;
        this.xFactor = 1.0f;
        this.yPos = 0.0f;
        this.yFactor = 1.0f;
        this.swap = false;
        this.width = 1.0f;
        this.length = 1.0f;
        this.iconScaleX = 1.0f;
        this.iconScaleY = 1.0f;
    }

    public void setConversionFactor(float f, float f2, float f3, float f4, boolean bl) {
        this.xPos = f;
        this.yPos = f3;
        this.xFactor = f2;
        this.yFactor = f4;
        this.swap = bl;
    }

    public void setPhysicalSize(float f, float f2) {
        this.width = f;
        this.length = f2;
    }

    public void setImageDirectory(String string) {
        this.imgDir = !string.endsWith("/") ? string + "/" : string;
    }

    public void addViewListener(ViewListener viewListener) {
        if (!this.viewListeners.contains(viewListener)) {
            this.viewListeners.add(viewListener);
        }
    }

    public void setLocation(String string) {
        System.out.println("setLocation: " + string);
        ImageIcon imageIcon = new ImageIcon(string);
        this.mapImage = imageIcon.getImage();
        this.toolTransform.scale(this.iconScaleX, this.iconScaleY);
        System.out.println("Image size: " + this.mapImage.getWidth(null) + " " + this.mapImage.getHeight(null));
        this.setPreferredSize(new Dimension(this.mapImage.getWidth(null), this.mapImage.getHeight(null)));
        this.revalidate();
    }

    public void setTool(ToolInstance toolInstance) {
        String[] stringArray = toolInstance.getURL();
        int n = toolInstance.getToolType();
        if (n == ToolDescriptor.TYPE_WORLD) {
            int n2 = EntityIDManager.getID();
            this.fireEntityAdded(n2, 0.0f, 0.0f, 0.0f, toolInstance);
            String string = stringArray[0];
            int n3 = string.lastIndexOf("/");
            int n4 = string.lastIndexOf(".x3d");
            String string2 = null;
            System.out.println("pos1: " + n3 + " pos2: " + n4);
            if (n4 > 0) {
                if (n3 < 0) {
                    n3 = 0;
                }
                string2 = string.substring(n3, n4);
            } else {
                string2 = string;
            }
            this.setLocation(this.imgDir + string2 + ".png");
            return;
        }
        Image image = (Image)this.imageMap.get(toolInstance);
        if (image == null) {
            String string = toolInstance.getIcon();
            System.out.println("Create image: " + string);
            ImageIcon imageIcon = new ImageIcon(string);
            image = imageIcon.getImage();
            this.imageMap.put(toolInstance, image);
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        float f = toolInstance.getWidth();
        float f2 = toolInstance.getLength();
        if (f2 > f) {
            System.out.println("xFac: " + this.xFactor + " iconFactor: " + f2 / (float)n6 + " fac: " + this.xFactor / (f2 / (float)n6));
            this.iconScaleY = f2 / (float)n6 / Math.abs(this.yFactor);
            this.iconScaleX = f / (float)Math.round(f / f2 * (float)n6) / Math.abs(this.xFactor);
            System.out.println("Icon scale: " + this.iconScaleX + " " + this.iconScaleY);
        }
        this.iconCenterX = (int)Math.ceil((float)(n5 / 2) * this.iconScaleX);
        this.iconCenterY = (int)Math.ceil((float)(n6 / 2) * this.iconScaleY);
        this.toolImage = image;
        this.currentTool = toolInstance;
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.entityDragging && this.currentEntity != null) {
            this.entityDragging = true;
        }
        if (this.entityDragging) {
            this.currentEntity.setScreenPosition(mouseEvent.getX(), mouseEvent.getY());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.toolTransform.setToTranslation(this.mouseX, this.mouseY);
        this.toolTransform.scale(this.iconScaleX, this.iconScaleY);
        if (this.toolImage != null) {
            this.repaint();
        }
        if (!this.isFocusOwner()) {
            this.requestFocusInWindow();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 27: {
                this.toolImage = null;
                this.currentTool = null;
                this.setCursor(null);
                this.repaint();
                break;
            }
            case 127: {
                if (this.currentEntity == null) break;
                System.out.println("Delete Entity: " + this.currentEntity.entityID);
                this.entities.remove(this.currentEntity);
                this.fireEntityRemoved(this.currentEntity.entityID);
                this.currentEntity = null;
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (n != 1) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        System.out.println("MM: " + n2 + " " + n3);
        if (this.currentTool != null) {
            int n4 = EntityIDManager.getID();
            this.entities.add(new EntityInstance(n4, this.currentTool, this.toolImage, n2, n3, this.iconScaleX, this.iconScaleY));
            this.convertScreenPosToWorldPos(n2 + this.iconCenterX, n3 + this.iconCenterY, this.pos);
            this.fireEntityAdded(n4, this.pos[0], this.pos[1], this.pos[2], this.currentTool);
            this.repaint();
        } else {
            EntityInstance entityInstance = this.findEntity(n2, n3);
            if (entityInstance == null && this.currentEntity != null) {
                this.currentEntity = null;
                this.fireEntitySelected(-1);
            }
            if (entityInstance != null) {
                this.currentEntity = entityInstance;
                System.out.println("Entity Found: " + entityInstance.entityID);
                this.fireEntitySelected(entityInstance.entityID);
            }
        }
        this.requestFocusInWindow();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        if (n == 1 && this.entityDragging) {
            this.entityDragging = false;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            this.convertScreenPosToWorldPos(n2 + this.iconCenterX, n3 + this.iconCenterY, this.pos);
            this.fireEntityMoved(this.currentEntity.entityID, this.pos[0], this.pos[1], this.pos[2]);
        }
        if (n == 3) {
            this.toolImage = null;
            this.currentTool = null;
            this.setCursor(null);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.toolImage != null) {
            this.setCursor(this.blankCursor);
        }
        this.insideMap = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(null);
        this.insideMap = false;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.mapImage != null) {
            graphics.drawImage(this.mapImage, 0, 0, null);
        }
        int n = this.entities.size();
        for (int i = 0; i < n; ++i) {
            EntityInstance entityInstance = (EntityInstance)this.entities.get(i);
            graphics2D.drawImage(entityInstance.image, entityInstance.xform, null);
        }
        if (this.insideMap && this.toolImage != null) {
            graphics2D.drawImage(this.toolImage, this.toolTransform, null);
            if (this.showIconCenter) {
                graphics2D.setColor(Color.red);
                graphics2D.drawRect(this.mouseX + this.iconCenterX, this.mouseY + this.iconCenterY, 1, 1);
            }
        }
    }

    private EntityInstance findEntity(int n, int n2) {
        int n3 = this.entities.size();
        EntityInstance entityInstance = null;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < n3; ++i) {
            int n5;
            int n6;
            int n7;
            EntityInstance entityInstance2 = (EntityInstance)this.entities.get(i);
            int n8 = n - entityInstance2.getPositionX();
            int n9 = n2 - entityInstance2.getPositionY();
            if (n8 <= 0 || n8 >= entityInstance2.screenMaxX || n9 <= 0 || n9 >= entityInstance2.screenMaxY || (n7 = (n6 = entityInstance2.screenCenterX - n) * n6 + (n5 = entityInstance2.screenCenterY - n2) * n5) >= n4) continue;
            n4 = n7;
            entityInstance = entityInstance2;
        }
        return entityInstance;
    }

    private void convertScreenPosToWorldPos(int n, int n2, float[] fArray) {
        if (!this.swap) {
            fArray[0] = this.xPos + (float)n * this.xFactor;
            fArray[1] = 0.0f;
            fArray[2] = this.yPos + (float)n2 * this.yFactor;
        } else {
            fArray[0] = this.yPos + (float)n2 * this.yFactor;
            fArray[1] = 0.0f;
            fArray[2] = this.xPos + (float)n * this.xFactor;
        }
    }

    private void fireEntityAdded(int n, float f, float f2, float f3, ToolInstance toolInstance) {
        int n2 = this.viewListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                ViewListener viewListener = (ViewListener)this.viewListeners.get(i);
                viewListener.entityAdded(n, f, f2, f3, toolInstance);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending entityAdded: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void fireEntityMoved(int n, float f, float f2, float f3) {
        int n2 = this.viewListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                ViewListener viewListener = (ViewListener)this.viewListeners.get(i);
                viewListener.entityMoved(n, f, f2, f3);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending entityAdded: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void fireEntitySelected(int n) {
        int n2 = this.viewListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                ViewListener viewListener = (ViewListener)this.viewListeners.get(i);
                viewListener.entitySelected(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending entityAdded: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void fireEntityRemoved(int n) {
        int n2 = this.viewListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                ViewListener viewListener = (ViewListener)this.viewListeners.get(i);
                viewListener.entityRemoved(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending entityAdded: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

