/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.ProtoScene;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.CRROUTE;
import org.web3d.vrml.renderer.NodeCopier;
import org.web3d.vrml.renderer.ProtoCopier;

public abstract class CRProtoCreator
implements NodeTemplateToInstanceCreator,
SceneGraphTraversalSimpleObserver {
    protected VRMLNodeFactory factory;
    protected SceneGraphTraverser traverser;
    protected ProtoScene scene;
    protected FrameStateManager stateManager;
    protected HashMap nodeMap;
    protected HashMap importMap;
    protected CRProtoInstance protoInstance;
    protected VRMLExecutionSpace rootSpace;
    protected NodeCopier nodeCopier;
    protected ProtoCopier protoCopier;
    protected SceneGraphTraversalSimpleObserver currentObserver;
    protected ErrorReporter errorReporter;
    protected boolean isVRML97;
    protected int majorVersion;
    protected int minorVersion;
    protected String worldURL;

    protected CRProtoCreator(VRMLNodeFactory vRMLNodeFactory, String string, int n, int n2) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("No node factory supplied");
        }
        this.worldURL = string;
        this.factory = vRMLNodeFactory;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.traverser = new SceneGraphTraverser();
        this.traverser.setObserver(this);
        this.traverser.setErrorReporter(this.errorReporter);
        this.nodeMap = new HashMap();
        this.importMap = new HashMap();
        this.protoCopier = new ProtoCopier(this.factory, string);
        this.protoCopier.setErrorReporter(this.errorReporter);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.protoCopier.setErrorReporter(this.errorReporter);
        this.traverser.setErrorReporter(this.errorReporter);
        if (this.nodeCopier != null) {
            this.nodeCopier.setErrorReporter(this.errorReporter);
        }
    }

    public void fillinInstance(VRMLNodeTemplate vRMLNodeTemplate, VRMLNode vRMLNode, VRMLExecutionSpace vRMLExecutionSpace) {
        this.protoInstance = (CRProtoInstance)vRMLNode;
        this.rootSpace = vRMLExecutionSpace;
        PrototypeDecl prototypeDecl = (PrototypeDecl)vRMLNodeTemplate;
        List list = prototypeDecl.getAllFields();
        VRMLFieldDeclaration[] vRMLFieldDeclarationArray = new VRMLFieldDeclaration[list.size()];
        list.toArray(vRMLFieldDeclarationArray);
        for (int i = vRMLFieldDeclarationArray.length - 1; i >= 0; --i) {
            int n = this.protoInstance.getFieldIndex(vRMLFieldDeclarationArray[i].getName());
            if (n != -1) continue;
            try {
                this.protoInstance.appendField(vRMLFieldDeclarationArray[i]);
                continue;
            }
            catch (FieldExistsException fieldExistsException) {
                this.errorReporter.messageReport("CRProtoCreator: Field exists?");
            }
        }
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        this.protoInstance.setNumBodyNodes(vRMLGroupingNodeType.getChildrenSize());
        this.protoInstance.setBackFill(true);
        this.finishCreate(prototypeDecl);
        this.protoInstance.setImports(this.importMap);
        this.protoInstance.setBackFill(false);
        this.protoInstance.resendIS();
        this.protoInstance.setComplete();
        this.protoInstance.propagateSetupFinished();
        this.protoInstance.sendUpdateMessage();
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        if (vRMLNodeType2 instanceof VRMLProtoInstance) {
            this.protoNode(vRMLNodeType, (VRMLProtoInstance)vRMLNodeType2, n, bl);
        } else {
            this.currentObserver.observedNode(vRMLNodeType, vRMLNodeType2, n, bl);
        }
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        this.protoCopier.setFrameStateManager(frameStateManager);
    }

    protected abstract void protoNode(VRMLNodeType var1, VRMLProtoInstance var2, int var3, boolean var4);

    protected void finishCreate(PrototypeDecl prototypeDecl) {
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        BasicScene basicScene = this.rootSpace.getContainedScene();
        this.scene = new ProtoScene(this.majorVersion, this.minorVersion);
        this.scene.mergeScene(basicScene);
        this.protoCopier.copyNode(this.protoInstance, this.scene, this.nodeMap, this.majorVersion, this.minorVersion, false);
        this.currentObserver = this.protoCopier;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
        this.traverser.reset();
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.traverser.traverseGraph(this.protoInstance, vRMLNodeTypeArray[i]);
        }
        this.traverser.reset();
        this.processDEFs(prototypeDecl.getDEFMap());
        this.processImports(prototypeDecl.getImportDecls());
        this.processRoutes(prototypeDecl.getRouteDecls());
        this.processIS(prototypeDecl.getISMaps(), prototypeDecl);
        this.processFields(prototypeDecl);
        this.protoInstance.setContainedScene(this.scene);
        this.nodeMap.clear();
        this.importMap.clear();
    }

    private void processDEFs(Map map) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            Object v2 = this.nodeMap.get(v);
            this.scene.addDEFNode(string, (VRMLNode)((VRMLNodeType)v2));
        }
    }

    private void processImports(Map map) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        Map map2 = this.scene.getDEFNodes();
        HashMap<String, HashMap<String, ImportNodeProxy>> hashMap = new HashMap<String, HashMap<String, ImportNodeProxy>>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                ImportNodeProxy importNodeProxy = (ImportNodeProxy)entry.getValue();
                Object k = entry.getKey();
                ImportNodeProxy importNodeProxy2 = (ImportNodeProxy)importNodeProxy.clone();
                String string = importNodeProxy.getInlineDEFName();
                HashMap<String, ImportNodeProxy> hashMap2 = (HashMap<String, ImportNodeProxy>)hashMap.get(string);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, ImportNodeProxy>();
                    hashMap.put(string, hashMap2);
                    VRMLInlineNodeType vRMLInlineNodeType = (VRMLInlineNodeType)map2.get(string);
                    vRMLInlineNodeType.setImportNodes(hashMap2);
                }
                hashMap2.put(importNodeProxy2.getExportedName(), importNodeProxy2);
                this.importMap.put(k, importNodeProxy2);
                this.nodeMap.put(importNodeProxy, importNodeProxy2);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.errorReporter.warningReport("Error during clone of an import proxy during proto creation", cloneNotSupportedException);
            }
        }
    }

    private void processRoutes(Set set) {
        if (set.size() == 0) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ROUTE rOUTE = (ROUTE)iterator.next();
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeMap.get(rOUTE.getSourceNode());
            if (vRMLNodeType == null) {
                this.errorReporter.warningReport("Unable to find matching source node copy for route " + rOUTE, null);
                continue;
            }
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(rOUTE.getDestinationNode());
            if (vRMLNodeType2 == null) {
                this.errorReporter.warningReport("Unable to find matching destination node copy for route " + rOUTE, null);
                continue;
            }
            VRMLNode vRMLNode = rOUTE.getSourceNode();
            int n = rOUTE.getSourceIndex();
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(n);
            n = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName());
            vRMLNode = rOUTE.getDestinationNode();
            int n2 = rOUTE.getDestinationIndex();
            vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(n2);
            n2 = vRMLNodeType2.getFieldIndex(vRMLFieldDeclaration.getName());
            CRROUTE cRROUTE = new CRROUTE(vRMLNodeType, n, vRMLNodeType2, n2);
            this.scene.addRoute((ROUTE)cRROUTE);
        }
    }

    private void processIS(Map map, PrototypeDecl prototypeDecl) {
        if (map.size() == 0) {
            return;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = n;
            VRMLFieldDeclaration vRMLFieldDeclaration = prototypeDecl.getFieldDeclaration(n2);
            int n3 = this.protoInstance.getFieldIndex(vRMLFieldDeclaration.getName());
            List list = (List)map.get(n);
            Iterator iterator2 = list.iterator();
            ArrayList<ProtoFieldInfo> arrayList = new ArrayList<ProtoFieldInfo>(list.size());
            while (iterator2.hasNext()) {
                ProtoFieldInfo protoFieldInfo = (ProtoFieldInfo)iterator2.next();
                VRMLNodeType vRMLNodeType = (VRMLNodeType)this.nodeMap.get(protoFieldInfo.node);
                if (vRMLNodeType == null) {
                    this.errorReporter.messageReport("Unable to find IS dest node copy: " + protoFieldInfo + "\nSource for IS " + vRMLFieldDeclaration);
                    this.errorReporter.messageReport("IS ignored");
                    continue;
                }
                vRMLFieldDeclaration = protoFieldInfo.node.getFieldDeclaration(protoFieldInfo.field);
                if (vRMLFieldDeclaration == null) {
                    this.errorReporter.messageReport("Invalid source field for: " + protoFieldInfo.node);
                    this.errorReporter.messageReport("IS ignored");
                    continue;
                }
                int n4 = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName());
                ProtoFieldInfo protoFieldInfo2 = new ProtoFieldInfo(vRMLNodeType, n4);
                arrayList.add(protoFieldInfo2);
            }
            this.protoInstance.setIsMapping(n3, arrayList);
        }
    }

    private void processFields(PrototypeDecl prototypeDecl) {
        List list = prototypeDecl.getAllFields();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            int n = vRMLFieldDeclaration.getAccessType();
            if (n == 1 || n == 4) continue;
            try {
                String string = vRMLFieldDeclaration.getName();
                int n2 = prototypeDecl.getFieldIndex(string);
                int n3 = this.protoInstance.getFieldIndex(string);
                VRMLFieldData vRMLFieldData = prototypeDecl.getFieldValue(n2);
                if (vRMLFieldData == null) continue;
                this.setProtoField(this.protoInstance, n3, vRMLFieldDeclaration.getFieldSize(), vRMLFieldData);
            }
            catch (FieldException fieldException) {
                this.errorReporter.errorReport("Proto create field types don't match!", fieldException);
            }
        }
    }

    protected void setProtoField(VRMLNodeType vRMLNodeType, int n, int n2, VRMLFieldData vRMLFieldData) throws FieldException {
        switch (vRMLFieldData.dataType) {
            case 1: {
                vRMLNodeType.setValue(n, vRMLFieldData.booleanValue);
                break;
            }
            case 8: {
                vRMLNodeType.setValue(n, vRMLFieldData.booleanArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 2: {
                vRMLNodeType.setValue(n, vRMLFieldData.intValue);
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, vRMLFieldData.intArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 3: {
                vRMLNodeType.setValue(n, vRMLFieldData.longValue);
                break;
            }
            case 10: {
                vRMLNodeType.setValue(n, vRMLFieldData.longArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 4: {
                vRMLNodeType.setValue(n, vRMLFieldData.floatValue);
                break;
            }
            case 11: {
                vRMLNodeType.setValue(n, vRMLFieldData.floatArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, vRMLFieldData.doubleValue);
                break;
            }
            case 12: {
                vRMLNodeType.setValue(n, vRMLFieldData.doubleArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 6: {
                vRMLNodeType.setValue(n, vRMLFieldData.stringValue);
                break;
            }
            case 14: {
                vRMLNodeType.setValue(n, vRMLFieldData.stringArrayValue, vRMLFieldData.numElements * n2);
                break;
            }
            case 7: {
                if (vRMLFieldData.nodeValue == null) break;
                vRMLNodeType.setValue(n, this.processNodeField((VRMLNodeType)vRMLFieldData.nodeValue));
                break;
            }
            case 13: {
                if (vRMLFieldData.nodeArrayValue == null || vRMLFieldData.numElements * n2 == 0) break;
                vRMLNodeType.setValue(n, this.processNodeField((VRMLNodeType[])vRMLFieldData.nodeArrayValue, vRMLFieldData.numElements * n2), vRMLFieldData.numElements * n2);
            }
        }
    }

    private VRMLNodeType processNodeField(VRMLNodeType vRMLNodeType) {
        if (this.nodeCopier == null) {
            this.nodeCopier = new NodeCopier(this.factory, this.worldURL);
            this.nodeCopier.setErrorReporter(this.errorReporter);
        }
        this.currentObserver = this.nodeCopier;
        System.out.println("Proto contains nodes in the declaration. We must do something about processing the scene generated");
        ProtoScene protoScene = new ProtoScene(this.majorVersion, this.minorVersion);
        VRMLNodeType vRMLNodeType2 = this.nodeCopier.copyNode(vRMLNodeType, protoScene, this.rootSpace, this.majorVersion, this.minorVersion, false);
        return vRMLNodeType2;
    }

    private VRMLNodeType[] processNodeField(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        if (this.nodeCopier == null) {
            this.nodeCopier = new NodeCopier(this.factory, this.worldURL);
        }
        this.currentObserver = this.nodeCopier;
        ProtoScene protoScene = new ProtoScene(this.majorVersion, this.minorVersion);
        VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[n];
        System.out.println("Proto contains nodes in the declaration. We must do something about processing the scene generated");
        for (int i = 0; i < n; ++i) {
            if (vRMLNodeTypeArray[i] == null) continue;
            vRMLNodeTypeArray2[i] = this.nodeCopier.copyNode(vRMLNodeTypeArray[i], protoScene, this.rootSpace, this.majorVersion, this.minorVersion, false);
        }
        return vRMLNodeTypeArray2;
    }
}

