/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.ProfileInfo;
import org.web3d.vrml.lang.UnsupportedComponentException;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.UnsupportedSpecVersionException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.xml.sax.SAXException;

public class DefaultNodeFactory
implements VRMLNodeFactory,
Cloneable {
    public static final String JAVA3D_RENDERER = "java3d";
    public static final String NULL_RENDERER = "null";
    public static final String OPENGL_RENDERER = "ogl";
    public static final String MOBILE_RENDERER = "mobile";
    private static final int INC_SIZE = 4;
    private static final Class[] NODE_CLASS = new Class[]{class$org$web3d$vrml$nodes$VRMLNodeType == null ? (class$org$web3d$vrml$nodes$VRMLNodeType = DefaultNodeFactory.class$("org.web3d.vrml.nodes.VRMLNodeType")) : class$org$web3d$vrml$nodes$VRMLNodeType};
    private static final String INVALID_VRML_SPEC_VERSION = "The only valid version number for VRML is 2.0. The minorVersion version provided is not 0: ";
    private static final String INVALID_X3D_SPEC_VERSION = "An invalid minorVersion version number has been provided for X3D: ";
    private static final String UNKNOWN_SPEC_VERSION = "An unknown specification majorVersion version is provided, for which we have no known configuration information: ";
    private static final String NO_COMP_DEF_MSG = "There is no definition information for the component ";
    private static final String NO_COMP_FILE_MSG = "Could not find the definition file for the component ";
    private static final String NO_PROF_FILE_MSG = "Could not find the definition file for the profile ";
    private static final String CREATE_MSG = "New node instantiation exception";
    private static final String ACCESS_MSG = "New now IllegalAccess exception";
    private static final String COPY_CON_MSG = "Node without copy constructor: ";
    private static final String EXCEPT_CON_MSG = "Exception in copy constructor: ";
    private static final String PROTO_CREATE_MSG = "Attempting to create a copy of a node that is a PROTO instance already. This is not allowed here. The offending node to copy is: ";
    private static final String NO_COMP_LVL_MSG = "The component does not support the level requested ";
    private static HashMap globalAvailableProfileNames;
    private static HashMap globalComponentLevels;
    private static HashMap globalNodeNameComponentMap;
    private static HashMap globalComponentToNodeMap;
    private static HashMap globalNodeNameLevelMap;
    private static HashMap globalNodeClassMap;
    private static HashMap rendererNodeClassMap;
    private static HashMap globalConstructorMap;
    private static HashMap globalProfileList;
    private static HashMap globalComponentList;
    private static HashMap globalComponentNameMap;
    private static HashMap globalRendererPrefixMap;
    private static HashMap globalInvalidProfiles;
    private static HashMap globalInvalidComponents;
    private static HashMap factoryInstances;
    private Float specVersion;
    private HashMap componentLevels;
    private HashMap nodeNameComponentMap;
    private HashMap componentNameMap;
    private HashMap componentToNodeMap;
    private HashMap nodeNameLevelMap;
    private HashMap nodeClassMap;
    private HashMap constructorMap;
    private ProfileInfo[] profileList;
    private ComponentInfo[] componentList;
    private String[] usableComponents;
    private int[] usableLevels;
    private int numUsableComponents;
    private HashSet currentValidNodes;
    private HashSet invalidProfiles;
    private HashSet invalidComponents;
    private Object[] constructorArgs;
    private String namePrefix;
    private final String renderer;
    private ErrorReporter errorReporter;
    protected int majorVersion;
    protected int minorVersion;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$VRMLNodeType;
    static /* synthetic */ Class class$org$web3d$vrml$renderer$DefaultNodeFactory;

    protected DefaultNodeFactory(String string) {
        this.renderer = string;
        this.constructorArgs = new Object[1];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.currentValidNodes = new HashSet();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setSpecVersion(int n, int n2) throws UnsupportedSpecVersionException {
        switch (n) {
            case 2: {
                if (n2 == 0) break;
                throw new UnsupportedSpecVersionException(INVALID_VRML_SPEC_VERSION + n2);
            }
            case 3: {
                if (n2 >= 0 && n2 <= 1) break;
                throw new UnsupportedSpecVersionException(INVALID_X3D_SPEC_VERSION + n2);
            }
            default: {
                throw new UnsupportedSpecVersionException(UNKNOWN_SPEC_VERSION);
            }
        }
        this.majorVersion = n;
        this.minorVersion = n2;
        this.specVersion = new Float((float)this.majorVersion + (float)this.minorVersion * 0.1f);
        HashMap hashMap = (HashMap)globalRendererPrefixMap.get(this.specVersion);
        if (hashMap == null) {
            hashMap = new HashMap();
            globalRendererPrefixMap.put(this.specVersion, hashMap);
            globalProfileList.put(this.specVersion, new ProfileInfo[0]);
            globalComponentList.put(this.specVersion, new ComponentInfo[0]);
            globalComponentToNodeMap.put(this.specVersion, new HashMap());
            globalComponentLevels.put(this.specVersion, new HashMap());
            globalComponentNameMap.put(this.specVersion, new HashMap());
            globalNodeNameLevelMap.put(this.specVersion, new HashMap());
            globalNodeClassMap.put(this.specVersion, new HashMap());
            globalConstructorMap.put(this.specVersion, new HashMap());
            globalInvalidProfiles.put(this.specVersion, new HashSet());
            globalInvalidComponents.put(this.specVersion, new HashSet());
            globalNodeNameComponentMap.put(this.specVersion, new HashMap());
            this.loadSpecDefinition(this.specVersion);
        }
        this.namePrefix = (String)hashMap.get(this.renderer);
        this.profileList = (ProfileInfo[])globalProfileList.get(this.specVersion);
        this.componentList = (ComponentInfo[])globalComponentList.get(this.specVersion);
        this.componentToNodeMap = (HashMap)globalComponentToNodeMap.get(this.specVersion);
        this.componentLevels = (HashMap)globalComponentLevels.get(this.specVersion);
        this.componentNameMap = (HashMap)globalComponentNameMap.get(this.specVersion);
        this.nodeNameLevelMap = (HashMap)globalNodeNameLevelMap.get(this.specVersion);
        HashMap hashMap2 = (HashMap)globalNodeClassMap.get(this.specVersion);
        this.nodeClassMap = (HashMap)hashMap2.get(this.renderer);
        if (this.nodeClassMap == null) {
            this.nodeClassMap = new HashMap();
            globalNodeClassMap.put(this.renderer, this.nodeClassMap);
        }
        hashMap2 = (HashMap)globalConstructorMap.get(this.specVersion);
        this.constructorMap = (HashMap)hashMap2.get(this.renderer);
        if (this.constructorMap == null) {
            this.constructorMap = new HashMap();
            this.constructorMap.put(this.renderer, this.constructorMap);
        }
        this.invalidProfiles = (HashSet)globalInvalidProfiles.get(this.specVersion);
        this.invalidComponents = (HashSet)globalInvalidComponents.get(this.specVersion);
        this.nodeNameComponentMap = (HashMap)globalNodeNameComponentMap.get(this.specVersion);
    }

    public void setProfile(String string) throws UnsupportedProfileException {
        this.numUsableComponents = 0;
        ProfileInfo profileInfo = null;
        for (int i = 0; i < this.profileList.length && profileInfo == null; ++i) {
            if (!this.profileList[i].getName().equals(string)) continue;
            profileInfo = this.profileList[i];
        }
        if (profileInfo == null) {
            profileInfo = this.loadProfile(string);
        }
        ComponentInfo[] componentInfoArray = profileInfo.getComponents();
        int n = componentInfoArray.length;
        if (this.usableComponents == null || this.usableComponents.length < n) {
            this.usableComponents = new String[n];
            this.usableLevels = new int[n];
        }
        this.currentValidNodes.clear();
        for (int i = 0; i < n; ++i) {
            String string2 = componentInfoArray[i].getName();
            int n2 = componentInfoArray[i].getLevel();
            this.usableComponents[i] = string2;
            this.usableLevels[i] = n2;
            String[] stringArray = (String[])this.componentToNodeMap.get(string2);
            for (int j = 0; j < stringArray.length; ++j) {
                Integer n3 = (Integer)this.nodeNameLevelMap.get(stringArray[j]);
                if (n3 > n2) continue;
                this.currentValidNodes.add(stringArray[j]);
            }
        }
        this.numUsableComponents = n;
    }

    public int[] getMaxSupportedSpecVersion() {
        return new int[]{3, 1};
    }

    public void disableComponent(int[] nArray, String string, int n) {
        System.out.println("Disable component not implemented");
    }

    public ComponentInfo addComponent(String string, int n) throws UnsupportedComponentException {
        Object[] objectArray;
        Integer n2 = null;
        if (!this.componentToNodeMap.containsKey(string)) {
            if (this.invalidComponents.contains(string)) {
                throw new UnsupportedComponentException(NO_COMP_DEF_MSG + string);
            }
            n2 = this.loadComponent(string);
        } else {
            n2 = (Integer)this.componentLevels.get(string);
            this.profileList = (ProfileInfo[])globalProfileList.get(this.specVersion);
            this.componentList = (ComponentInfo[])globalComponentList.get(this.specVersion);
        }
        if (n != -1 && n2 < n) {
            throw new UnsupportedComponentException(NO_COMP_LVL_MSG + n);
        }
        boolean bl = false;
        for (int i = 0; i < this.numUsableComponents; ++i) {
            if (!string.equals(this.usableComponents[i])) continue;
            bl = true;
            if (this.usableLevels[i] >= n) continue;
            this.usableLevels[i] = n;
            objectArray = (String[])this.componentToNodeMap.get(string);
            for (int j = 0; j < objectArray.length; ++j) {
                Integer n3 = (Integer)this.nodeNameLevelMap.get(objectArray[j]);
                if (n3 > n) continue;
                this.currentValidNodes.add(objectArray[j]);
            }
        }
        if (!bl) {
            if (this.usableComponents == null) {
                this.usableComponents = new String[5];
                this.usableLevels = new int[5];
            } else if (this.numUsableComponents == this.usableComponents.length) {
                String[] stringArray = new String[this.numUsableComponents + 4];
                System.arraycopy(this.usableComponents, 0, stringArray, 0, this.numUsableComponents);
                this.usableComponents = stringArray;
                objectArray = new int[this.numUsableComponents + 4];
                System.arraycopy(this.usableLevels, 0, objectArray, 0, this.numUsableComponents);
                this.usableLevels = (int[])objectArray;
            }
            this.usableComponents[this.numUsableComponents] = string;
            this.usableLevels[this.numUsableComponents] = n;
            ++this.numUsableComponents;
            String[] stringArray = (String[])this.componentToNodeMap.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n4 = (Integer)this.nodeNameLevelMap.get(stringArray[i]);
                if (n4 > n) continue;
                this.currentValidNodes.add(stringArray[i]);
            }
        }
        ComponentInfo componentInfo = null;
        for (int i = 0; i < this.componentList.length && componentInfo == null; ++i) {
            if (!this.componentList[i].getName().equals(string)) continue;
            componentInfo = this.componentList[i];
        }
        if (componentInfo == null) {
            System.out.println("Can't find comp: " + string + " level: " + n);
        }
        if (n != -1 && componentInfo.getLevel() != n) {
            componentInfo = new ComponentInfo(componentInfo, n);
        }
        return componentInfo;
    }

    public ProfileInfo[] getAvailableProfiles() {
        return (ProfileInfo[])globalProfileList.get(this.specVersion);
    }

    public String[] getAvailableProfileNames() {
        return (String[])globalAvailableProfileNames.get(this.specVersion);
    }

    public ComponentInfo[] getAvailableComponents() {
        return (ComponentInfo[])globalComponentList.get(this.specVersion);
    }

    public synchronized VRMLNode createVRMLNode(String string, boolean bl) throws UnsupportedNodeException {
        if (!this.currentValidNodes.contains(string)) {
            throw new UnsupportedNodeException(string);
        }
        VRMLNode vRMLNode = null;
        try {
            Class clazz = this.findNode(string);
            if (clazz != null) {
                vRMLNode = (VRMLNode)clazz.newInstance();
                vRMLNode.setVersion(this.majorVersion, this.minorVersion, bl);
            }
        }
        catch (InstantiationException instantiationException) {
            this.errorReporter.errorReport(CREATE_MSG, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.errorReporter.errorReport(ACCESS_MSG, illegalAccessException);
        }
        return vRMLNode;
    }

    public synchronized VRMLNode createVRMLNode(String string, String string2, boolean bl) throws UnsupportedComponentException, UnsupportedNodeException {
        if (!this.componentToNodeMap.containsKey(string)) {
            if (this.invalidComponents.contains(string)) {
                throw new UnsupportedComponentException(string);
            }
            this.loadComponent(string);
        } else {
            this.profileList = (ProfileInfo[])globalProfileList.get(this.specVersion);
            this.componentList = (ComponentInfo[])globalComponentList.get(this.specVersion);
        }
        VRMLNode vRMLNode = null;
        ComponentInfo componentInfo = (ComponentInfo)this.nodeNameComponentMap.get(string2);
        if (!componentInfo.getName().equals(string)) {
            throw new UnsupportedNodeException(string2);
        }
        StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
        try {
            stringBuffer.append('.');
            stringBuffer.append(this.namePrefix);
            stringBuffer.append(string2);
            Class<?> clazz = Class.forName(stringBuffer.toString());
            vRMLNode = (VRMLNode)clazz.newInstance();
            vRMLNode.setVersion(this.majorVersion, this.minorVersion, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            this.errorReporter.errorReport(CREATE_MSG, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.errorReporter.errorReport(ACCESS_MSG, illegalAccessException);
        }
        return vRMLNode;
    }

    public synchronized VRMLNode createVRMLNode(VRMLNode vRMLNode, boolean bl) {
        if (vRMLNode instanceof VRMLProtoInstance) {
            this.errorReporter.errorReport(PROTO_CREATE_MSG + vRMLNode.getVRMLNodeName(), null);
            return null;
        }
        VRMLNode vRMLNode2 = null;
        String string = vRMLNode.getVRMLNodeName();
        ComponentInfo componentInfo = (ComponentInfo)this.nodeNameComponentMap.get(string);
        StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
        stringBuffer.append('.');
        stringBuffer.append(this.namePrefix);
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        Constructor constructor = (Constructor)this.constructorMap.get(string2);
        try {
            Class clazz;
            if (constructor == null && (clazz = this.findNode(string)) != null) {
                constructor = clazz.getConstructor(NODE_CLASS);
                this.constructorMap.put(string2, constructor);
            }
            if (constructor != null) {
                this.constructorArgs[0] = vRMLNode;
                vRMLNode2 = (VRMLNode)constructor.newInstance(this.constructorArgs);
                vRMLNode2.setVersion(this.majorVersion, this.minorVersion, bl);
                this.constructorArgs[0] = null;
            }
        }
        catch (InstantiationException instantiationException) {
            this.errorReporter.errorReport(CREATE_MSG, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.errorReporter.errorReport(ACCESS_MSG, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.errorReporter.errorReport(COPY_CON_MSG + string, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errorReporter.errorReport(EXCEPT_CON_MSG + string, invocationTargetException);
        }
        return vRMLNode2;
    }

    public static VRMLNodeFactory createFactory(String string) {
        VRMLNodeFactory vRMLNodeFactory = (VRMLNodeFactory)factoryInstances.get(string);
        if (vRMLNodeFactory == null) {
            vRMLNodeFactory = new DefaultNodeFactory(string);
            factoryInstances.put(string, vRMLNodeFactory);
        }
        return vRMLNodeFactory;
    }

    public static VRMLNodeFactory newInstance(String string) {
        return new DefaultNodeFactory(string);
    }

    public static void clearCachedInfo() {
        globalNodeClassMap.clear();
        globalConstructorMap.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultNodeFactory defaultNodeFactory = (DefaultNodeFactory)super.clone();
        defaultNodeFactory.constructorArgs = new Object[1];
        if (this.usableComponents != null) {
            defaultNodeFactory.usableComponents = (String[])this.usableComponents.clone();
        }
        if (this.usableLevels != null) {
            defaultNodeFactory.usableLevels = (int[])this.usableLevels.clone();
        }
        defaultNodeFactory.currentValidNodes = new HashSet();
        defaultNodeFactory.currentValidNodes.addAll(this.currentValidNodes);
        defaultNodeFactory.profileList = (ProfileInfo[])globalProfileList.get(this.specVersion);
        defaultNodeFactory.componentList = (ComponentInfo[])globalComponentList.get(this.specVersion);
        defaultNodeFactory.componentToNodeMap = (HashMap)globalComponentToNodeMap.get(this.specVersion);
        defaultNodeFactory.componentLevels = (HashMap)globalComponentLevels.get(this.specVersion);
        defaultNodeFactory.nodeNameLevelMap = (HashMap)globalNodeNameLevelMap.get(this.specVersion);
        defaultNodeFactory.nodeClassMap = (HashMap)globalNodeClassMap.get(this.specVersion);
        defaultNodeFactory.constructorMap = (HashMap)globalConstructorMap.get(this.specVersion);
        defaultNodeFactory.invalidProfiles = (HashSet)globalInvalidProfiles.get(this.specVersion);
        defaultNodeFactory.invalidComponents = (HashSet)globalInvalidComponents.get(this.specVersion);
        defaultNodeFactory.nodeNameComponentMap = (HashMap)globalNodeNameComponentMap.get(this.specVersion);
        return defaultNodeFactory;
    }

    private Class findNode(String string) {
        Class<?> clazz = (Class<?>)this.nodeClassMap.get(string);
        if (clazz == null) {
            try {
                ComponentInfo componentInfo = (ComponentInfo)this.nodeNameComponentMap.get(string);
                if (componentInfo != null) {
                    StringBuffer stringBuffer = new StringBuffer(componentInfo.getPackage(this.renderer));
                    stringBuffer.append('.');
                    stringBuffer.append(this.namePrefix);
                    stringBuffer.append(string);
                    String string2 = stringBuffer.toString();
                    clazz = Class.forName(string2);
                    this.nodeClassMap.put(string, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private void loadSpecDefinition(Float f) {
        Object object;
        String[] stringArray;
        NodeList nodeList;
        Object object2;
        Object object3;
        String string = "config/" + f + "/profiles.xml";
        InputStream inputStream = this.locateConfigFile(string);
        if (inputStream == null) {
            return;
        }
        Document document = null;
        try {
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setValidating(false);
            ((DocumentBuilderFactory)object3).setNamespaceAware(false);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            document = ((DocumentBuilder)object2).parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.errorReporter.errorReport("Can't create XML DOM factory: " + factoryConfigurationError.getMessage(), null);
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorReporter.errorReport("Can't create XML DOM parser", parserConfigurationException);
            return;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (exception != null) {
                exception.printStackTrace(printWriter);
            } else {
                sAXException.printStackTrace(printWriter);
            }
            StringBuffer stringBuffer = new StringBuffer("SAX Error: ");
            stringBuffer.append(sAXException.toString());
            throw new VRMLException(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport("Error reading profile.xml stream", iOException);
            return;
        }
        object3 = document.getDocumentElement();
        object2 = object3.getElementsByTagName("rendererConfig");
        this.processRendererConfig((Element)object2.item(0), f);
        NodeList nodeList2 = object3.getElementsByTagName("componentConfig");
        Element element = (Element)nodeList2.item(0);
        if (element != null) {
            nodeList = element.getElementsByTagName("component");
            Map map = (Map)globalComponentLevels.get(f);
            stringArray = (String[])globalComponentNameMap.get(f);
            int n = nodeList.getLength();
            ComponentInfo[] componentInfoArray = new ComponentInfo[n];
            for (int i = 0; i < n; ++i) {
                object = (Element)nodeList.item(i);
                ComponentInfo componentInfo = this.processComponentElement((Element)object);
                map.put(componentInfo.getName(), new Integer(componentInfo.getLevel()));
                stringArray.put(componentInfo.getName(), componentInfo);
                componentInfoArray[i] = componentInfo;
            }
            globalComponentList.put(f, componentInfoArray);
        }
        if ((element = (Element)(nodeList2 = object3.getElementsByTagName("profileConfig")).item(0)) != null) {
            nodeList = element.getElementsByTagName("profile");
            int n = nodeList.getLength();
            stringArray = new String[n];
            ProfileInfo[] profileInfoArray = new ProfileInfo[n];
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                profileInfoArray[i] = object = this.processProfileElement(element2);
                stringArray[i] = ((ProfileInfo)object).getName();
            }
            globalAvailableProfileNames.put(f, stringArray);
            globalProfileList.put(f, profileInfoArray);
        }
    }

    private void processRendererConfig(Element element, Float f) {
        Map map = (Map)globalRendererPrefixMap.get(f);
        NodeList nodeList = element.getElementsByTagName("renderer");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("type");
            String string2 = element2.getAttribute("prefix");
            map.put(string, string2);
        }
    }

    private ComponentInfo processComponentElement(Element element) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("title");
        String string3 = element.getAttribute("levels");
        String string4 = element.getAttribute("url");
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.errorReporter.warningReport("Component level definition is not an integer", null);
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        NodeList nodeList = element.getElementsByTagName("nodeLocation");
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            object4 = (Element)nodeList.item(i);
            object3 = object4.getAttribute("type");
            object2 = object4.getAttribute("package");
            hashMap.put((String)object3, (String)object2);
        }
        ComponentInfo componentInfo = new ComponentInfo(string, n, string2, string4, hashMap);
        object4 = element.getElementsByTagName("componentLevel");
        object3 = (Map)globalNodeNameLevelMap.get(this.specVersion);
        object2 = (Map)globalNodeNameComponentMap.get(this.specVersion);
        n2 = object4.getLength();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            object = (Element)object4.item(i);
            string3 = object.getAttribute("level");
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.warningReport("Component level required is not an integer", null);
            }
            if (n3 > n) {
                this.errorReporter.errorReport("Component " + string + "level definition specifies a level value " + n3 + " greater than the max defined for " + " this component's max " + n, null);
                continue;
            }
            NodeList nodeList2 = object.getElementsByTagName("node");
            int n4 = nodeList2.getLength();
            Integer n5 = new Integer(n3);
            for (int j = 0; j < n4; ++j) {
                Element element2 = (Element)nodeList2.item(j);
                String string5 = element2.getAttribute("name");
                arrayList.add(string5);
                object2.put(string5, componentInfo);
                object3.put(string5, n5);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        object = (Map)globalComponentToNodeMap.get(this.specVersion);
        object.put(string, stringArray);
        return componentInfo;
    }

    private ProfileInfo processProfileElement(Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("title");
        NodeList nodeList = element.getElementsByTagName("component");
        int n = nodeList.getLength();
        Map map = (Map)globalComponentNameMap.get(this.specVersion);
        ComponentInfo[] componentInfoArray = new ComponentInfo[n];
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("name");
            String string4 = element2.getAttribute("level");
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.warningReport("Component level definition in profile is not an integer", null);
            }
            ComponentInfo componentInfo = (ComponentInfo)map.get(string3);
            componentInfoArray[i] = new ComponentInfo(componentInfo, n2);
        }
        return new ProfileInfo(string, string2, componentInfoArray);
    }

    private Integer loadComponent(String string) throws UnsupportedComponentException {
        Object object;
        Object object2;
        if (this.invalidComponents.contains(string)) {
            throw new UnsupportedComponentException(NO_COMP_FILE_MSG + string);
        }
        Integer n = null;
        String string2 = "config/" + this.specVersion + "/component/" + string + ".xml";
        InputStream inputStream = this.locateConfigFile(string2);
        if (inputStream == null) {
            this.invalidComponents.add(string);
            throw new UnsupportedComponentException(NO_COMP_FILE_MSG + string);
        }
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.errorReporter.errorReport("Can't create XML DOM factory: " + factoryConfigurationError.getMessage(), null);
            return n;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorReporter.errorReport("Can't create XML DOM parser", parserConfigurationException);
            return n;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (exception != null) {
                exception.printStackTrace(printWriter);
            } else {
                sAXException.printStackTrace(printWriter);
            }
            StringBuffer stringBuffer = new StringBuffer("SAX Error: ");
            stringBuffer.append(sAXException.toString() + " parsing file: " + string2);
            throw new VRMLException(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport("Error reading profile.xml stream", iOException);
            return n;
        }
        object2 = document.getDocumentElement();
        object = object2.getElementsByTagName("component");
        if (object.getLength() > 0) {
            Element element = (Element)object.item(0);
            ComponentInfo componentInfo = this.processComponentElement(element);
            n = new Integer(componentInfo.getLevel());
            Map map = (Map)globalComponentLevels.get(this.specVersion);
            Map map2 = (Map)globalComponentNameMap.get(this.specVersion);
            map.put(componentInfo.getName(), new Integer(componentInfo.getLevel()));
            map2.put(componentInfo.getName(), componentInfo);
            ComponentInfo[] componentInfoArray = (ComponentInfo[])globalComponentList.get(this.specVersion);
            ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length + 1];
            System.arraycopy(componentInfoArray, 0, componentInfoArray2, 0, componentInfoArray.length);
            componentInfoArray2[componentInfoArray.length] = componentInfo;
            globalComponentList.put(this.specVersion, componentInfoArray2);
            this.componentList = componentInfoArray2;
        }
        return n;
    }

    private ProfileInfo loadProfile(String string) throws UnsupportedProfileException {
        Object object;
        Object object2;
        if (this.invalidProfiles.contains(string)) {
            throw new UnsupportedProfileException(NO_PROF_FILE_MSG + string);
        }
        ProfileInfo profileInfo = null;
        String string2 = "config/" + this.specVersion + "/profile/" + string + ".xml";
        InputStream inputStream = this.locateConfigFile(string2);
        if (inputStream == null) {
            this.invalidProfiles.add(string);
            System.out.println("Looking for profile at: " + string2);
            throw new UnsupportedProfileException(NO_PROF_FILE_MSG + string);
        }
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.errorReporter.errorReport("Can't create XML DOM factory: " + factoryConfigurationError.getMessage(), null);
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errorReporter.errorReport("Can't create XML DOM parser", parserConfigurationException);
            return null;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (exception != null) {
                exception.printStackTrace(printWriter);
            } else {
                sAXException.printStackTrace(printWriter);
            }
            StringBuffer stringBuffer = new StringBuffer("SAX Error: ");
            stringBuffer.append(sAXException.toString());
            throw new VRMLException(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport("Error reading external profile stream " + string2, iOException);
            return null;
        }
        object2 = document.getDocumentElement();
        object = object2.getElementsByTagName("profile");
        if (object.getLength() > 0) {
            Element element = (Element)object.item(0);
            profileInfo = this.processProfileElement(element);
            ProfileInfo[] profileInfoArray = (ProfileInfo[])globalProfileList.get(this.specVersion);
            ProfileInfo[] profileInfoArray2 = new ProfileInfo[profileInfoArray.length + 1];
            System.arraycopy(profileInfoArray, 0, profileInfoArray2, 0, profileInfoArray.length);
            profileInfoArray2[profileInfoArray.length] = profileInfo;
            globalProfileList.put(this.specVersion, profileInfoArray2);
        }
        return profileInfo;
    }

    private InputStream locateConfigFile(final String string) {
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemResourceAsStream(string);
            }
        });
        if (inputStream == null) {
            ClassLoader classLoader = (class$org$web3d$vrml$renderer$DefaultNodeFactory == null ? (class$org$web3d$vrml$renderer$DefaultNodeFactory = DefaultNodeFactory.class$("org.web3d.vrml.renderer.DefaultNodeFactory")) : class$org$web3d$vrml$renderer$DefaultNodeFactory).getClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
        }
        return inputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        factoryInstances = new HashMap();
        globalAvailableProfileNames = new HashMap();
        globalRendererPrefixMap = new HashMap();
        globalComponentLevels = new HashMap();
        globalComponentNameMap = new HashMap();
        globalNodeNameComponentMap = new HashMap();
        globalComponentToNodeMap = new HashMap();
        globalNodeNameLevelMap = new HashMap();
        globalNodeClassMap = new HashMap();
        globalConstructorMap = new HashMap();
        globalProfileList = new HashMap();
        globalComponentList = new HashMap();
        globalInvalidProfiles = new HashMap();
        globalInvalidComponents = new HashMap();
    }
}

