/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.proto.ProtoScene;
import org.web3d.vrml.renderer.CRProtoInstance;

public class ProtoCopier
implements SceneGraphTraversalSimpleObserver {
    private VRMLNodeFactory factory;
    private ProtoScene scene;
    private FrameStateManager stateManager;
    private ErrorReporter errorReporter;
    private Map nodeMap;
    private CRProtoInstance protoInstance;
    private String worldURL;
    private int majorVersion;
    private int minorVersion;
    private boolean staticNodes;

    public ProtoCopier(VRMLNodeFactory vRMLNodeFactory, String string) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("No node factory supplied");
        }
        this.factory = vRMLNodeFactory;
        this.worldURL = string;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    void copyNode(CRProtoInstance cRProtoInstance, ProtoScene protoScene, Map map, int n, int n2, boolean bl) {
        if (protoScene == null) {
            throw new NullPointerException("No scene supplied");
        }
        this.scene = protoScene;
        this.protoInstance = cRProtoInstance;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.nodeMap = map;
        this.staticNodes = bl;
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        VRMLNodeType vRMLNodeType3;
        if (bl) {
            vRMLNodeType3 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType2);
            if (!vRMLNodeType3.isDEF()) {
                vRMLNodeType3.setDEF();
            }
        } else if (!(vRMLNodeType2 instanceof VRMLProtoInstance)) {
            vRMLNodeType3 = (VRMLNodeType)this.factory.createVRMLNode(vRMLNodeType2, this.staticNodes);
            if (vRMLNodeType3 == null) {
                this.errorReporter.warningReport("ProtoCopier is unable to make a copy of " + vRMLNodeType2.getVRMLNodeName(), null);
                return;
            }
            vRMLNodeType3.setFrameStateManager(this.stateManager);
            this.scene.addNode((VRMLNode)vRMLNodeType3);
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
            if (vRMLNodeType3 instanceof VRMLInlineNodeType) {
                ((VRMLInlineNodeType)vRMLNodeType3).setParentSpace(this.protoInstance);
            } else if (vRMLNodeType3 instanceof VRMLScriptNodeType) {
                ((VRMLScriptNodeType)vRMLNodeType3).setExecutionSpace(this.protoInstance);
            }
            if (vRMLNodeType3 instanceof VRMLExternalNodeType) {
                ((VRMLExternalNodeType)((Object)vRMLNodeType3)).setWorldUrl(this.worldURL);
            }
        } else {
            this.scene.addNode((VRMLNode)vRMLNodeType2);
            vRMLNodeType3 = vRMLNodeType2;
            vRMLNodeType3.setFrameStateManager(this.stateManager);
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
        }
        if (vRMLNodeType == null || n == -1) {
            this.protoInstance.addBodyChild(vRMLNodeType3);
        } else {
            VRMLNodeType vRMLNodeType4 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
            int n2 = vRMLNodeType4.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLNodeType4.setValue(n2, vRMLNodeType3);
            }
            catch (FieldException fieldException) {
                this.errorReporter.warningReport("ProtoCopier error setting copied node! Parent:" + vRMLNodeType.getClass() + " child: " + vRMLNodeType2.getClass() + " field " + n, fieldException);
            }
        }
    }

    public void protoNode(VRMLNodeType vRMLNodeType, CRProtoInstance cRProtoInstance) {
        if (vRMLNodeType == null) {
            this.protoInstance.addBodyChild(cRProtoInstance);
            return;
        }
        this.scene.addNode((VRMLNode)cRProtoInstance);
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
        int n = vRMLNodeType.getPrimaryType();
        int n2 = cRProtoInstance.getImplementationNode().getPrimaryType();
        switch (n) {
            case 22: {
                ((VRMLGroupingNodeType)vRMLNodeType2).addChild(cRProtoInstance);
                break;
            }
            case 43: {
                int n3 = n2 == 2 ? vRMLNodeType2.getFieldIndex("appearance") : vRMLNodeType2.getFieldIndex("geometry");
                try {
                    ((VRMLShapeNodeType)vRMLNodeType2).setValue(n3, cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 2: {
                int n4;
                switch (n2) {
                    case 29: {
                        n4 = vRMLNodeType2.getFieldIndex("material");
                        break;
                    }
                    case 50: {
                        n4 = vRMLNodeType2.getFieldIndex("texture");
                        break;
                    }
                    case 51: {
                        n4 = vRMLNodeType2.getFieldIndex("textureTransform");
                        break;
                    }
                    default: {
                        n4 = -1;
                    }
                }
                try {
                    ((VRMLAppearanceNodeType)vRMLNodeType2).setValue(n4, cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 45: {
                int n5 = vRMLNodeType2.getFieldIndex("source");
                try {
                    ((VRMLSoundNodeType)vRMLNodeType2).setValue(n5, cRProtoInstance);
                }
                catch (FieldException fieldException) {}
                break;
            }
            case 3: 
            case 5: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 42: 
            case 50: 
            case 51: 
            case 78: {
                break;
            }
            case 41: {
                System.out.println("ProtoCopier can't handle script fields containing protos. Must fix");
            }
        }
    }
}

