/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URL;

class JavascriptResourceConnection
extends ResourceConnection {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-javascript";
    private static final String ECMA_CONTENT_TYPE = "application/ecmascript";
    private String script;
    private String contentType = "application/x-javascript";
    private int contentLength = -1;
    private ByteArrayInputStream stream;

    JavascriptResourceConnection(boolean bl, URL uRL, String string) throws MalformedURLException {
        super(uRL);
        this.script = string;
        this.contentLength = string.length();
        if (bl) {
            this.contentType = ECMA_CONTENT_TYPE;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.stream == null) {
            this.stream = new ByteArrayInputStream(this.script.substring(11).getBytes());
            this.contentLength = this.stream.available();
        }
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void connect() throws IOException {
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            this.contentLength = -1;
        }
        return this.contentLength;
    }
}

