/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.protocol;

import org.ietf.uri.URIResourceStream;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.net.protocol.FileResourceStream;
import org.web3d.net.protocol.JarResourceStream;
import org.web3d.net.protocol.JavascriptResourceStream;
import org.web3d.util.HashSet;

public class Web3DResourceFactory
implements URIResourceStreamFactory {
    private static HashSet supportedTypes = new HashSet();
    private URIResourceStreamFactory nestedFactory;

    public Web3DResourceFactory(URIResourceStreamFactory uRIResourceStreamFactory) {
        this.nestedFactory = uRIResourceStreamFactory;
    }

    public URIResourceStream createURIResourceStream(String string) {
        URIResourceStream uRIResourceStream = null;
        if (supportedTypes.contains(string)) {
            switch (string.charAt(2)) {
                case 'r': {
                    uRIResourceStream = new JarResourceStream();
                    break;
                }
                case 'm': {
                    uRIResourceStream = new JavascriptResourceStream(true);
                    break;
                }
                case 'v': {
                    uRIResourceStream = new JavascriptResourceStream(false);
                    break;
                }
                case 'f': {
                    uRIResourceStream = new FileResourceStream();
                }
            }
        } else if (this.nestedFactory != null) {
            uRIResourceStream = this.nestedFactory.createURIResourceStream(string);
        }
        return uRIResourceStream;
    }

    static {
        supportedTypes.add("jar");
        supportedTypes.add("ecmascript");
        supportedTypes.add("javascript");
        supportedTypes.add("file");
    }
}

