/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.net.resolve;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URIResourceFactory;
import org.ietf.uri.URL;
import org.ietf.uri.URN;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.UnsupportedServiceException;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;

public class Web3DURNResolver
implements URNResolverService {
    private static final String WEB3D_NID = "web3d";
    private URIResourceFactory resourceFactory;
    private HashMap spaceMap = new HashMap();
    private static HashSet validNIDs = new HashSet();
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public boolean canResolve(String string) {
        return validNIDs.contains(string);
    }

    public Object decode(URN uRN, int n) throws UnsupportedServiceException {
        if (n != 1 && n != 3) {
            throw new UnsupportedServiceException("Don't support this");
        }
        String string = uRN.getNSS();
        Object object = null;
        int n2 = string.indexOf(58);
        String string2 = string.substring(0, n2);
        String string3 = (String)this.spaceMap.get(string2);
        if (string3 != null) {
            String string4 = string.substring(n2 + 1);
            String string5 = string3 + string4;
            object = this.setupResource(string5, n);
        }
        return object;
    }

    public Object[] decodeList(URN uRN, int n) throws UnsupportedServiceException {
        if (n != 2 && n != 4) {
            throw new UnsupportedServiceException("Don't support this");
        }
        Object object = this.decode(uRN, n == 2 ? 1 : 3);
        Object[] objectArray = null;
        if (object != null) {
            if (n == 4) {
                ResourceConnection[] resourceConnectionArray = new ResourceConnection[]{(ResourceConnection)object};
                objectArray = resourceConnectionArray;
            } else {
                URL[] uRLArray = new URL[]{(URL)object};
                objectArray = uRLArray;
            }
        }
        return objectArray;
    }

    public boolean checkService(int n) {
        boolean bl;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
            }
        }
        bl = false;
        return bl;
    }

    public void init() {
    }

    public void setResourceFactory(URIResourceFactory uRIResourceFactory) {
        this.resourceFactory = uRIResourceFactory;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void registerPrefixLocation(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Subspace prefix is null");
        }
        if (string2 == null) {
            this.spaceMap.remove(string);
        } else {
            this.checkDir(string2);
            String string3 = string2.replace('\\', '/');
            if (!string3.endsWith("/")) {
                string3 = string3 + '/';
            }
            this.spaceMap.put(string, string3);
        }
    }

    private void checkDir(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Gave a file, need directory");
        }
    }

    private Object setupResource(String string, int n) {
        Object object = null;
        if (n == 1) {
            try {
                object = new URL("file", null, -1, string);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            try {
                object = this.resourceFactory.requestResource("file", null, -1, string);
            }
            catch (IOException iOException) {
                this.errorReporter.warningReport("I/O Error attempting to fetch the resource from the URN resolver.", iOException);
            }
        }
        return object;
    }

    static {
        validNIDs.add(WEB3D_NID);
    }
}

