/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.plugins.logs.HistoryPanel;

public class EventsPanel
extends HistoryPanel {
    private static final long serialVersionUID = 1L;

    public EventsPanel(ConsoleLayout console) {
        super(console, false);
    }

    public void addMessage(HistoryMessage hmessage) {
        this.myMessages.add(hmessage);
        this.setMessages(this.myMessages);
    }

    @Override
    public void setMessages(Vector<HistoryMessage> messages) {
        this.mainPanel.removeAll();
        for (HistoryMessage m : messages) {
            if (m.type == HistoryMessage.msg_type.info && !this.showInfo) continue;
            JLabel l = new JLabel(m.toString(), this.getIcon(m.type), 2);
            l.setToolTipText("Received on " + new Date(m.timestamp) + " (" + m.context + ")");
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 3));
            l.setOpaque(true);
            l.setBackground((Color)this.bgColors.get((Object)m.type));
            if (m.type == HistoryMessage.msg_type.critical) {
                l.setForeground(Color.yellow);
            }
            this.mainPanel.add(l);
        }
        this.invalidate();
        this.validate();
        this.mainPanel.scrollRectToVisible(new Rectangle(0, this.mainPanel.getHeight() + 22, 1, 1));
        this.repaint();
    }
}

