/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HistoryMessage
implements Comparable<HistoryMessage> {
    protected static final DateFormat format = new SimpleDateFormat("HH:mm:ss");
    public long timestamp;
    public String text;
    public String context;
    public boolean assynchronous = false;
    public msg_type type = msg_type.info;

    public HistoryMessage() {
    }

    public String toString() {
        return "[" + format.format(new Date(this.timestamp)) + "] " + " [" + this.context + "] " + this.text;
    }

    public HistoryMessage(long timestamp, String text, String context, boolean assynchronous, msg_type type) {
        this.timestamp = timestamp;
        this.text = text;
        this.context = context;
        this.assynchronous = assynchronous;
        this.type = type;
    }

    public boolean equals(Object obj) {
        HistoryMessage o;
        try {
            o = (HistoryMessage)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.timestamp == o.timestamp && this.text.equalsIgnoreCase(o.text) && this.context.equalsIgnoreCase(o.context) && this.type == o.type;
    }

    @Override
    public int compareTo(HistoryMessage o) {
        return (int)(this.timestamp - o.timestamp);
    }

    public int hashCode() {
        return (this.context + this.text + this.timestamp).hashCode();
    }

    public static enum msg_type {
        info,
        warning,
        error,
        critical,
        debug;

    }
}

