/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.util.ImageUtils;

public class HistoryPanel
extends JPanel {
    protected JPanel mainPanel = new JPanel();
    protected Vector<HistoryMessage> myMessages = new Vector();
    protected JScrollPane scroll = new JScrollPane(this.mainPanel, 22, 30);
    protected ConsoleLayout console = null;
    protected boolean showInfo = true;
    protected boolean showReload = true;
    protected LinkedHashMap<HistoryMessage.msg_type, Color> bgColors = new LinkedHashMap();

    public HistoryPanel(ConsoleLayout console, boolean showReload) {
        this.bgColors.put(HistoryMessage.msg_type.critical, Color.black);
        this.bgColors.put(HistoryMessage.msg_type.error, new Color(255, 128, 128));
        this.bgColors.put(HistoryMessage.msg_type.warning, new Color(255, 255, 128));
        this.bgColors.put(HistoryMessage.msg_type.info, new Color(200, 255, 200));
        this.bgColors.put(HistoryMessage.msg_type.debug, new Color(217, 217, 217));
        this.console = console;
        this.showReload = showReload;
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridLayout(0, 1));
        this.mainPanel.setBackground(Color.white);
        this.scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scroll, "Center");
        JPanel bottom = new JPanel(new FlowLayout(2));
        if (showReload) {
            ToolbarButton btn = new ToolbarButton(new AbstractAction(I18n.text((String)"Reload"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/reload.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (HistoryPanel.this.console == null) {
                        return;
                    }
                    IMCMessage m = IMCDefinition.getInstance().create("LogBookControl", new Object[]{"command", "GET"});
                    ImcMsgManager.getManager().sendMessageToVehicle(m, HistoryPanel.this.console.getMainSystem(), null);
                    m = IMCDefinition.getInstance().create("LogBookControl", new Object[]{"command", "GET_ERR"});
                    ImcMsgManager.getManager().sendMessageToVehicle(m, HistoryPanel.this.console.getMainSystem(), null);
                }
            });
            btn.setText(I18n.text((String)"Reload"));
            bottom.add((Component)btn);
        }
        ToolbarSwitch sw = new ToolbarSwitch(new AbstractAction(I18n.text((String)"Show all"), ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/info.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryPanel.this.console == null) {
                    return;
                }
                HistoryPanel.this.showInfo = ((ToolbarSwitch)e.getSource()).isSelected();
                Vector<HistoryMessage> tmp = new Vector<HistoryMessage>();
                tmp.addAll(HistoryPanel.this.myMessages);
                HistoryPanel.this.myMessages.clear();
                HistoryPanel.this.mainPanel.removeAll();
                HistoryPanel.this.setMessages(tmp);
            }
        });
        sw.setText(I18n.text((String)"Show info"));
        bottom.add((Component)sw);
        this.add((Component)bottom, "South");
    }

    public HistoryPanel() {
        this((ConsoleLayout)null, true);
    }

    public void setMessages(Vector<HistoryMessage> messages) {
        for (HistoryMessage m : messages) {
            if (this.myMessages.contains(m)) continue;
            this.myMessages.add(m);
            if (m.type == HistoryMessage.msg_type.info && !this.showInfo) continue;
            JLabel l = new JLabel(m.toString(), this.getIcon(m.type), 2);
            l.setToolTipText(I18n.textf((String)"Received on %timeStamp (%context)", (Object[])new Object[]{new Date(m.timestamp), m.context}));
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 3));
            l.setOpaque(true);
            l.setBackground(this.bgColors.get((Object)m.type));
            if (m.type == HistoryMessage.msg_type.critical) {
                l.setForeground(Color.yellow);
            }
            this.mainPanel.add(l);
        }
        this.invalidate();
        this.validate();
        this.mainPanel.scrollRectToVisible(new Rectangle(0, this.mainPanel.getHeight() + 22, 1, 1));
        this.repaint();
    }

    public ImageIcon getIcon(HistoryMessage.msg_type type) {
        switch (type) {
            case info: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/info.png");
            }
            case warning: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/warning.png");
            }
            case error: 
            case critical: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/error.png");
            }
            case debug: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/unknown.png");
            }
        }
        return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/queue2.png");
    }
}

