/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class LogBookHistory
extends AbstractListModel<HistoryMessage>
implements ListCellRenderer<HistoryMessage> {
    private static final long serialVersionUID = 2382030731540409061L;
    protected LinkedList<HistoryMessage> messages = new LinkedList();
    protected String sysname;
    protected int maxSize = 250;
    protected LinkedHashMap<HistoryMessage.msg_type, Color> bgColors = new LinkedHashMap();
    JLabel l;

    public LogBookHistory(String sysname) {
        this.bgColors.put(HistoryMessage.msg_type.critical, Color.black);
        this.bgColors.put(HistoryMessage.msg_type.error, new Color(255, 128, 128));
        this.bgColors.put(HistoryMessage.msg_type.warning, new Color(255, 255, 128));
        this.bgColors.put(HistoryMessage.msg_type.info, new Color(200, 255, 200));
        this.bgColors.put(HistoryMessage.msg_type.debug, new Color(217, 217, 217));
        this.l = new JLabel("", 2);
        this.sysname = sysname;
    }

    public void add(HistoryMessage msg) {
        if (!this.messages.contains(msg)) {
            this.messages.add(msg);
            Collections.sort(this.messages);
            int idx = Collections.binarySearch(this.messages, (Object)msg);
            this.fireIntervalAdded(this, idx, idx);
        }
        if (this.getSize() > this.maxSize) {
            this.messages.removeFirst();
            this.fireIntervalRemoved(this, 0, 0);
        }
    }

    public void clear() {
        int size = this.getSize();
        this.messages.clear();
        this.fireIntervalRemoved(this, 0, size);
    }

    public Collection<HistoryMessage> add(Collection<HistoryMessage> msgs) {
        Vector<HistoryMessage> notExisting = new Vector<HistoryMessage>();
        for (HistoryMessage msg : msgs) {
            if (this.messages.contains(msg)) continue;
            this.messages.add(msg);
            notExisting.add(msg);
        }
        if (notExisting.isEmpty()) {
            return notExisting;
        }
        Collections.sort(this.messages);
        while (this.getSize() > this.maxSize) {
            this.messages.removeFirst();
        }
        this.fireContentsChanged(this, 0, this.getSize());
        Collections.sort(notExisting);
        return notExisting;
    }

    public long lastMessageTimestamp() {
        return this.messages.getLast().timestamp;
    }

    @Override
    public HistoryMessage getElementAt(int index) {
        return this.messages.get(index);
    }

    @Override
    public int getSize() {
        return this.messages.size();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends HistoryMessage> list, HistoryMessage value, int index, boolean isSelected, boolean cellHasFocus) {
        this.l.setText(value.toString());
        this.l.setToolTipText(I18n.textf((String)"Received on %timeStamp (%context)", (Object[])new Object[]{new Date(value.timestamp), value.context}));
        this.l.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 3));
        this.l.setOpaque(true);
        this.l.setBackground(this.bgColors.get((Object)value.type));
        if (value.type == HistoryMessage.msg_type.critical) {
            this.l.setForeground(Color.yellow);
        }
        return this.l;
    }

    public ImageIcon getIcon(HistoryMessage.msg_type type) {
        switch (type) {
            case info: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/info.png");
            }
            case warning: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/warning.png");
            }
            case error: 
            case critical: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/error.png");
            }
            case debug: {
                return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/unknown.png");
            }
        }
        return ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/queue2.png");
    }

    public static void main(String[] args) throws Exception {
        LogBookHistory hist = new LogBookHistory("lauv");
        JList<HistoryMessage> panel = new JList<HistoryMessage>(hist);
        panel.setCellRenderer(hist);
        GuiUtils.testFrame((JComponent)new JScrollPane(panel));
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(30L);
            hist.add(new HistoryMessage(System.currentTimeMillis(), "teste1", "ctx", true, HistoryMessage.msg_type.error));
            Thread.sleep(30L);
            hist.add(new HistoryMessage(System.currentTimeMillis(), "teste2", "ctx", true, HistoryMessage.msg_type.info));
            Thread.sleep(30L);
            hist.add(new HistoryMessage(System.currentTimeMillis() - 5000L, "teste3", "ctx", true, HistoryMessage.msg_type.critical));
            Thread.sleep(30L);
            hist.add(new HistoryMessage(System.currentTimeMillis() - 5000L, "teste3", "ctx", true, HistoryMessage.msg_type.warning));
        }
    }
}

