/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LogBookControl;
import pt.lsts.imc.LogBookEntry;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventSystemAuthorityStateChanged;
import pt.lsts.neptus.console.events.ConsoleEventVehicleStateChanged;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.plugins.logs.MultiSystemHistory;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.vehicle.VehicleType;

@PluginDescription(name="Logbook History")
@Popup(accelerator=72, height=400, width=600, name="Logbook History", pos=Popup.POSITION.CENTER, icon="pt/lsts/neptus/plugins/logs/queue.png")
public class LogBookSubPanel
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Seconds between history update requests")
    public int secondsBetweenRequests = 60;
    protected MultiSystemHistory history = new MultiSystemHistory();
    protected LinkedHashMap<String, Double> lastMessagesUpdate = new LinkedHashMap();

    public LogBookSubPanel(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.add(this.history, "Center");
    }

    @Subscribe
    public void consume(LogBookControl logControl) {
        ImcSystem sys = ImcSystemsHolder.lookupSystem((int)logControl.getSrc());
        if (sys == null) {
            return;
        }
        if (sys.getAuthorityState().ordinal() <= ImcSystem.IMCAuthorityState.NONE.ordinal()) {
            return;
        }
        HashSet<HistoryMessage> msgs = new HashSet<HistoryMessage>();
        if (logControl.getCommand() == LogBookControl.COMMAND.REPLY) {
            for (LogBookEntry entry : logControl.getMsg()) {
                msgs.add(this.generate(logControl.getSourceName(), entry, false));
            }
            Collection<HistoryMessage> newMessages = this.history.add(msgs, logControl.getSourceName());
            Vector<HistoryMessage> msgsVec = new Vector<HistoryMessage>();
            msgsVec.addAll(newMessages);
            Collections.reverse(msgsVec);
            this.lastMessagesUpdate.put(logControl.getSourceName(), logControl.getHtime());
            if (!newMessages.isEmpty()) {
                String text = "";
                boolean error = false;
                int count = 0;
                for (HistoryMessage m : msgsVec) {
                    if (m.type != HistoryMessage.msg_type.critical && m.type != HistoryMessage.msg_type.error) continue;
                    error = true;
                    text = "<i>" + m.toString() + "</i><br/>" + text;
                    if (++count != 3) continue;
                    break;
                }
                if (!error) {
                    for (HistoryMessage m : msgsVec) {
                        if (m.type == HistoryMessage.msg_type.critical || m.type == HistoryMessage.msg_type.error) continue;
                        text = "<i>" + m.toString() + "</i><br/>" + text;
                        if (++count != 3) continue;
                        break;
                    }
                }
                if (count < newMessages.size()) {
                    text = "...<br/>" + text;
                }
                text = I18n.textf((String)"Received %nMessages previous entries from %systemName including: ", (Object[])new Object[]{newMessages.size(), logControl.getSourceName()}) + " <br/>" + text;
                if (error) {
                    this.post(Notification.error((String)I18n.text((String)"Log Book"), (String)text));
                } else {
                    this.post(Notification.info((String)I18n.text((String)"Log Book"), (String)text));
                }
            }
        }
    }

    @Subscribe
    public void consume(LogBookEntry logEntry) {
        if (!this.isShowing()) {
            return;
        }
        ImcSystem sys = ImcSystemsHolder.lookupSystem((int)logEntry.getSrc());
        if (sys == null) {
            return;
        }
        if (sys.getAuthorityState().ordinal() <= ImcSystem.IMCAuthorityState.NONE.ordinal()) {
            return;
        }
        this.history.add(this.generate(logEntry.getSourceName(), logEntry, true), logEntry.getSourceName());
    }

    @Subscribe
    public void consume(ConsoleEventSystemAuthorityStateChanged authChanged) {
        if (ImcSystemsHolder.getSystemWithName((String)authChanged.getSystem()).getType() != VehicleType.SystemTypeEnum.VEHICLE) {
            return;
        }
        if (authChanged.getPreviousAuthorityState().ordinal() <= ImcSystem.IMCAuthorityState.NONE.ordinal() && authChanged.getAuthorityState().ordinal() > ImcSystem.IMCAuthorityState.NONE.ordinal()) {
            this.history.createHistory(authChanged.getSystem());
        } else if (authChanged.getPreviousAuthorityState().ordinal() > ImcSystem.IMCAuthorityState.NONE.ordinal() && authChanged.getAuthorityState().ordinal() <= ImcSystem.IMCAuthorityState.NONE.ordinal()) {
            this.history.removeHistory(authChanged.getSystem());
        }
    }

    @Subscribe
    public void consume(ConsoleEventVehicleStateChanged stateChanged) {
        String vName = stateChanged.getVehicle();
        if (vName == null || vName.length() == 0) {
            return;
        }
        ImcSystem sys = ImcSystemsHolder.getSystemWithName((String)vName);
        if (sys == null || sys.getAuthorityState().ordinal() < ImcSystem.IMCAuthorityState.NONE.ordinal()) {
            return;
        }
        if (stateChanged.getState() != ConsoleEventVehicleStateChanged.STATE.DISCONNECTED && (this.lastMessagesUpdate.get(stateChanged.getVehicle()) == null || (double)(System.currentTimeMillis() / 1000L) - this.lastMessagesUpdate.get(stateChanged.getVehicle()) > (double)this.secondsBetweenRequests)) {
            this.update();
        }
    }

    public long millisBetweenUpdates() {
        return this.secondsBetweenRequests * 1000;
    }

    protected HistoryMessage generate(String src, LogBookEntry entry, boolean async) {
        HistoryMessage.msg_type type = HistoryMessage.msg_type.info;
        switch (entry.getType()) {
            case ERROR: {
                type = HistoryMessage.msg_type.error;
                break;
            }
            case WARNING: {
                type = HistoryMessage.msg_type.warning;
                break;
            }
            case CRITICAL: {
                type = HistoryMessage.msg_type.critical;
                break;
            }
            case DEBUG: {
                type = HistoryMessage.msg_type.debug;
                break;
            }
        }
        return new HistoryMessage((long)(entry.getHtime() * 1000.0), entry.getText(), entry.getContext(), async, type);
    }

    protected void requestMessages() {
        for (ImcSystem s : ImcSystemsHolder.lookupActiveSystemVehicles()) {
            double timestamp = 0.0;
            if (this.lastMessagesUpdate.containsKey(s.getName()) && this.lastMessagesUpdate.get(s.getName()) != 0.0) {
                timestamp = this.lastMessagesUpdate.get(s.getName());
            }
            if ((double)(System.currentTimeMillis() / 1000L) - timestamp < (double)(this.secondsBetweenRequests / 2)) {
                return;
            }
            LogBookControl msg = new LogBookControl();
            msg.setCommand(LogBookControl.COMMAND.GET);
            msg.setHtime(timestamp);
            this.send(s.getName(), (IMCMessage)msg);
            msg = new LogBookControl();
            msg.setCommand(LogBookControl.COMMAND.GET_ERR);
            msg.setHtime(timestamp);
            this.send(s.getName(), (IMCMessage)msg);
        }
    }

    public boolean update() {
        this.requestMessages();
        return true;
    }

    public void initSubPanel() {
        for (ImcSystem s : ImcSystemsHolder.lookupActiveSystemVehicles()) {
            if (s.getAuthorityState().ordinal() <= ImcSystem.IMCAuthorityState.NONE.ordinal()) continue;
            this.history.createHistory(s.getName());
        }
        this.requestMessages();
    }

    public void cleanSubPanel() {
    }
}

