/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.util.Vector;
import javax.swing.JComponent;
import pt.lsts.imc.LogBookEntry;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.plugins.logs.HistoryPanel;

@PluginDescription(author="zp", name="Log Book", icon="pt/lsts/neptus/plugins/logs/log.png")
public class LogBookVisualization
extends SimpleMRAVisualization {
    private static final long serialVersionUID = 1L;
    protected HistoryPanel hpanel = null;

    public LogBookVisualization(MRAPanel panel) {
        super(panel);
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLog("LogBookEntry") != null;
    }

    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        if (this.hpanel != null) {
            return this.hpanel;
        }
        this.hpanel = new HistoryPanel();
        Vector<HistoryMessage> messages = new Vector<HistoryMessage>();
        for (LogBookEntry entry : source.getLsfIndex().getIterator(LogBookEntry.class)) {
            HistoryMessage msg = new HistoryMessage();
            msg.timestamp = entry.getTimestampMillis();
            msg.text = entry.getText();
            msg.context = entry.getContext();
            LogBookEntry.TYPE type = entry.getType();
            switch (type) {
                case INFO: {
                    msg.type = HistoryMessage.msg_type.info;
                    break;
                }
                case WARNING: {
                    msg.type = HistoryMessage.msg_type.warning;
                    break;
                }
                case ERROR: {
                    msg.type = HistoryMessage.msg_type.error;
                    break;
                }
                case CRITICAL: {
                    msg.type = HistoryMessage.msg_type.critical;
                    break;
                }
                case DEBUG: {
                    msg.type = HistoryMessage.msg_type.debug;
                    break;
                }
            }
            msg.assynchronous = false;
            messages.add(msg);
        }
        this.hpanel.setMessages(messages);
        this.hpanel.remove(1);
        return this.hpanel;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }
}

