/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;

public class LogMerger
extends JDialog {
    private static final long serialVersionUID = 1L;
    JFileChooser fileChooser = new JFileChooser();
    JButton btnAdd;
    JButton btnRemove;
    JButton btnMerge;
    JButton btnOutDir;
    DefaultListModel<String> listModel = new DefaultListModel();
    JList<String> list = new JList<String>(this.listModel);
    JTextField txtOutDir = new JTextField();
    Vector<String> selectedValues = new Vector();

    public LogMerger() {
        this.initialize();
        this.setVisible(true);
    }

    public void initialize() {
        this.setLayout((LayoutManager)new MigLayout());
        this.setSize(400, 400);
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.list.setBackground(Color.white);
        this.list.setBorder(new TitledBorder(I18n.text((String)"Log folders list")));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogMerger.this.selectedValues.clear();
                List<String> values = LogMerger.this.list.getSelectedValuesList();
                for (String s : values) {
                    LogMerger.this.selectedValues.add(s);
                }
            }
        });
        this.btnAdd = new JButton(new AbstractAction(I18n.text((String)"Add")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int opt = LogMerger.this.fileChooser.showOpenDialog(LogMerger.this);
                if (opt == 0) {
                    for (File f : LogMerger.this.fileChooser.getSelectedFiles()) {
                        LogMerger.this.listModel.addElement(f.getAbsolutePath());
                    }
                }
            }
        });
        this.btnRemove = new JButton(new AbstractAction(I18n.text((String)"Remove")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (String s : LogMerger.this.selectedValues) {
                    LogMerger.this.listModel.removeElement(s);
                }
            }
        });
        this.btnOutDir = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int opt = LogMerger.this.fileChooser.showOpenDialog(LogMerger.this);
                if (opt == 0) {
                    LogMerger.this.txtOutDir.setText(LogMerger.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.btnMerge = new JButton(new AbstractAction(I18n.text((String)"Merge")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NeptusLog.pub().info((Object)"<###>Merging");
            }
        });
        this.add((Component)this.btnAdd, "split");
        this.add((Component)this.btnRemove, "wrap");
        this.add(this.list, "w 100%, h 100%, wrap");
        this.add((Component)new JLabel(I18n.text((String)"Output directory:")), "wrap");
        this.add((Component)this.txtOutDir, "w 100%, split");
        this.add((Component)this.btnOutDir, "wrap");
        this.add(this.btnMerge);
    }

    public static void main(String[] args) {
        LogMerger merger = new LogMerger();
        merger.setDefaultCloseOperation(2);
    }
}

