/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.RoundRectangle2D;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.NetworkInterfacesUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.logdownload.LogFileInfoList;
import pt.lsts.neptus.util.logdownload.LogFolderInfo;
import pt.lsts.neptus.util.logdownload.LogsDownloaderWorker;

@Popup(pos=Popup.POSITION.RIGHT, width=300, height=100, accelerator=76)
@PluginDescription(author="Paulo Dias and Jos\u00e9 Pinto", name="Log Download", description="", version="3.0.0", icon="pt/lsts/neptus/plugins/logs/log.png", documentation="logs-downloader/logs-downloader.html#console")
public class LoggingDownloader
extends ConsolePanel
implements MainVehicleChangeListener,
IPeriodicUpdates,
ConfigurationListener,
NeptusMessageListener {
    private final ImageIcon ICON = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/log.png");
    @NeptusProperty(name="Log List Update Period in Seconds", userLevel=NeptusProperty.LEVEL.REGULAR)
    public short logListUpdatePeriodSeconds = (short)30;
    @NeptusProperty(name="Automatic Update Log List from Remote Systems", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean automaticUpdateLogsFromRemoteSystems = false;
    @NeptusProperty(name="Change Log Name Enabled")
    public boolean changeLogNameEnabled = true;
    @NeptusProperty(name="Component Update Period in Seconds", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public short updatePeriodSeconds = (short)20;
    @NeptusProperty(name="Auto Sync. Only Non Idle Logs", userLevel=NeptusProperty.LEVEL.ADVANCED, description="If enable only logs with names (excluding 'idle') are synchronized.")
    public boolean autoSyncOnlyNonIdleLogs = false;
    protected boolean isUpdatedListFromServer = false;
    protected Operation curState = Operation.UNKNOWN;
    protected String lastName = "";
    protected String currentName = null;
    protected Vector<String> logFoldersList = new Vector();
    protected ToolbarButton button = null;
    protected ToolbarButton showDownloader = null;
    protected ToolbarButton syncList = null;
    protected BarPainter barSyncValue = null;
    protected AbstractAction logCtrlAction;
    protected AbstractAction showDownloaderAction;
    protected AbstractAction syncListAction;
    private final String syncListToolTipText = I18n.text((String)"Sync day Mission Logs");
    protected double valueSync = 0.0;
    private final LinkedHashMap<String, LogsDownloaderWorker> downloadWorkerList = new LinkedHashMap();
    private Timer timer = null;
    private TimerTask ttaskUpdateLogList = null;
    private TimerTask ttaskUpdateLogName = null;
    private long timeRequestLogList = -1L;
    private JFrame logsFrame;
    private JTabbedPane tabbledPane;

    public LoggingDownloader(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.initializeActions();
        this.removeAll();
        this.button = new ToolbarButton(this.logCtrlAction);
        this.button.setEnabled(this.changeLogNameEnabled);
        this.syncList = new ToolbarButton(this.syncListAction);
        this.syncList.setToolTipText(this.syncListToolTipText);
        this.syncList.setText(I18n.text((String)"Sync Logs"));
        Painter obp = this.syncList.getBackgroundPainter();
        this.barSyncValue = new BarPainter();
        if (obp != null) {
            this.syncList.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{obp, this.barSyncValue, new GlossPainter()}));
        } else {
            this.syncList.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this.barSyncValue, new GlossPainter()}));
        }
        this.showDownloader = new ToolbarButton(this.showDownloaderAction);
        this.showDownloader.setToolTipText(I18n.text((String)"Show Downloader"));
        this.setLayout(new BorderLayout());
        JXPanel dlpanel = new JXPanel();
        dlpanel.setLayout((LayoutManager)new FlowLayout());
        dlpanel.add((Component)this.button);
        dlpanel.add((Component)this.syncList);
        dlpanel.add((Component)this.showDownloader);
        this.add((Component)dlpanel, "Center");
        this.tabbledPane = new JTabbedPane();
        if (this.getMainVehicleId() != null && !"".equalsIgnoreCase(this.getMainVehicleId())) {
            this.tabbledPane.setSelectedComponent((Component)this.getDownloadWorker().getContentPanel());
        }
        this.logsFrame = new JFrame(I18n.text((String)"Download Log Files"));
        this.logsFrame.setSize(900, 560);
        this.logsFrame.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.logsFrame.setDefaultCloseOperation(2);
        this.logsFrame.setLayout(new BorderLayout());
        this.logsFrame.add(this.tabbledPane);
    }

    private void initializeActions() {
        this.logCtrlAction = new AbstractAction(I18n.text((String)"Logging Control"), this.ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog((Component)LoggingDownloader.this.getConsole(), I18n.text((String)"Please enter the desired log name (empty for default)"), LoggingDownloader.this.lastName);
                if (name == null) {
                    return;
                }
                LoggingDownloader.this.lastName = name;
                LoggingDownloader.this.send(IMCDefinition.getInstance().create("LoggingControl", new Object[]{"op", Operation.REQUEST_START.type(), "name", name}));
            }
        };
        this.showDownloaderAction = new AbstractAction(I18n.text((String)"Show Downloader"), LogsDownloaderWorker.ICON_DOWNLOAD_FOLDERS){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingDownloader.this.tabbledPane.setSelectedComponent((Component)LoggingDownloader.this.getDownloadWorker().getContentPanel());
                LoggingDownloader.this.getDownloadWorker().setVisible(true);
            }
        };
        this.syncListAction = new AbstractAction(I18n.text((String)"Sync Logs")){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingDownloader.this.syncList.setEnabled(false);
                boolean noListRqst = true;
                if (!LoggingDownloader.this.automaticUpdateLogsFromRemoteSystems) {
                    noListRqst = !LoggingDownloader.this.scheduleDownloadListFromServer();
                }
                Timer timer = new Timer("Sync Logs");
                TimerTask ttask = new TimerTask(){

                    @Override
                    public void run() {
                        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                            @Override
                            protected Void doInBackground() throws Exception {
                                LogsDownloaderWorker dw = LoggingDownloader.this.getDownloadWorker();
                                String[] listFolders = dw.doGiveListOfLogFolders();
                                Vector<String> ltdw = new Vector<String>();
                                for (String str : listFolders) {
                                    if (!LoggingDownloader.this.isMissionLogFromToday(str)) continue;
                                    ltdw.add(str);
                                }
                                Collections.sort(ltdw, new Comparator<String>(){

                                    @Override
                                    public int compare(String o1, String o2) {
                                        return o2.compareTo(o1);
                                    }
                                });
                                dw.doDownloadLogFoldersFromServer(ltdw.toArray(new String[0]));
                                return null;
                            }

                            @Override
                            protected void done() {
                                try {
                                    this.get();
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                }
                                LoggingDownloader.this.syncList.setEnabled(true);
                            }
                        };
                        worker.execute();
                    }
                };
                timer.schedule(ttask, noListRqst ? 10L : 5000L);
            }
        };
    }

    public void initSubPanel() {
        if (this.getConsole().getMainSystem() == null) {
            this.button.setEnabled(false);
            this.button.setToolTipText(I18n.text((String)"Log: (communications not started)"));
        } else {
            this.resetDownloaderForVehicle(this.getConsole().getMainSystem());
            this.send(IMCDefinition.getInstance().create("LoggingControl", new Object[]{"op", Operation.REQUEST_CURRENT_NAME.type()}));
            this.button.setEnabled(this.changeLogNameEnabled);
            this.button.setToolTipText(I18n.text((String)"Log: (updating...)"));
        }
    }

    public void cleanSubPanel() {
        if (this.ttaskUpdateLogList != null) {
            this.ttaskUpdateLogList.cancel();
            this.ttaskUpdateLogList = null;
        }
        this.revokeScheduleCurLogFromVehicle();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (LogsDownloaderWorker downloadWorker : this.downloadWorkerList.values()) {
            downloadWorker.cleanup();
        }
        this.logsFrame.dispose();
    }

    private void updateLogsState() {
        String[] listFolders;
        LogsDownloaderWorker dw = this.getDownloadWorker();
        if (dw == null) {
            return;
        }
        try {
            listFolders = dw.doGiveListOfLogFolders();
        }
        catch (Exception e) {
            NeptusLog.pub().warn((Object)e);
            return;
        }
        long nTotal = 0L;
        long nDownloading = 0L;
        long nError = 0L;
        long nNew = 0L;
        long nIncomplete = 0L;
        long nSync = 0L;
        long nUnknown = 0L;
        for (String strLFd : listFolders) {
            if (!this.isMissionLogFromToday(strLFd)) continue;
            LinkedHashMap sfiles = dw.doGiveStateOfLogFolderFiles(strLFd);
            for (String strFx : sfiles.keySet()) {
                if (sfiles.get(strFx) == LogFolderInfo.State.LOCAL) continue;
                ++nTotal;
                if (sfiles.get(strFx) == LogFolderInfo.State.SYNC) {
                    ++nSync;
                    continue;
                }
                if (sfiles.get(strFx) == LogFolderInfo.State.DOWNLOADING) {
                    ++nDownloading;
                    continue;
                }
                if (sfiles.get(strFx) == LogFolderInfo.State.ERROR) {
                    ++nError;
                    continue;
                }
                if (sfiles.get(strFx) == LogFolderInfo.State.NEW) {
                    ++nNew;
                    continue;
                }
                if (sfiles.get(strFx) == LogFolderInfo.State.INCOMPLETE) {
                    ++nIncomplete;
                    continue;
                }
                if (sfiles.get(strFx) != LogFolderInfo.State.UNKNOWN) continue;
                ++nUnknown;
            }
        }
        Icon icon = LogFileInfoList.ICON_UNKNOWN;
        icon = nTotal == 0L ? LogFileInfoList.ICON_UNKNOWN : (nDownloading > 0L ? LogFileInfoList.ICON_DOWN : (nError > 0L ? LogFileInfoList.ICON_ERROR : (nSync == nTotal ? LogFileInfoList.ICON_SYNC : (nNew == nTotal ? LogFileInfoList.ICON_NEW : (nSync + nIncomplete + nUnknown + nNew == nTotal ? LogFileInfoList.ICON_INCOMP : LogFileInfoList.ICON_UNKNOWN)))));
        this.barSyncValue.setValue(1.0 * (double)nSync / (double)nTotal);
        this.syncList.setToolTipText(this.syncListToolTipText + " (" + nSync + " / " + nTotal + ")");
        this.syncList.setIcon(icon);
        this.syncList.repaint();
    }

    private boolean isMissionLogFromToday(String logStr) {
        String dateStr;
        if (this.autoSyncOnlyNonIdleLogs) {
            int idx_ = logStr.indexOf(95);
            if (idx_ == -1) {
                return false;
            }
            if (idx_ < 15) {
                return false;
            }
            String slstr = logStr.substring(idx_ + 1, logStr.length());
            if ("".equals(slstr)) {
                return false;
            }
            if ("idle".equals(slstr)) {
                return false;
            }
        }
        return logStr.startsWith((dateStr = DateTimeUtil.dateFormaterNoSpaces.format(new Date(System.currentTimeMillis()))) + "/");
    }

    public LogsDownloaderWorker getDownloadWorker() {
        return this.getDownloadWorker(this.getMainVehicleId());
    }

    public synchronized LogsDownloaderWorker getDownloadWorker(String id) {
        if (id == null || id.length() == 0) {
            NeptusLog.pub().warn((Object)"Trying to get a downloader worker for a null id!");
            return null;
        }
        LogsDownloaderWorker downloadWorker = this.downloadWorkerList.get(id);
        if (downloadWorker == null) {
            downloadWorker = new LogsDownloaderWorker(this.logsFrame);
            downloadWorker.setHost("");
            downloadWorker.setLogLabel(id);
            downloadWorker.setEnableHost(true);
            downloadWorker.setEnablePort(false);
            downloadWorker.setEnableLogLabel(false);
            this.downloadWorkerList.put(id, downloadWorker);
            this.tabbledPane.addTab(downloadWorker.getLogLabel(), (Component)downloadWorker.getContentPanel());
        }
        return downloadWorker;
    }

    private void resetDownloaderForVehicle(String id) {
        LogsDownloaderWorker dw = this.getDownloadWorker(id);
        if (dw == null) {
            return;
        }
        String oldId = this.getDownloadWorker(id).getLogLabel();
        if (!id.equalsIgnoreCase(oldId)) {
            try {
                ImcSystem sys3 = ImcSystemsHolder.lookupSystemByName((String)id);
                this.getDownloadWorker(id).setHost(sys3.getHostAddress());
                this.getDownloadWorker(id).setLogLabel(id.toLowerCase());
                this.getDownloadWorker(id).doReset(false);
                this.scheduleDownloadListFromServer();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("Bad log downloader settings for '" + id + "'"), (Throwable)e);
                this.getDownloadWorker(id).setHost("");
                this.getDownloadWorker(id).setLogLabel(id.toLowerCase());
                this.getDownloadWorker(id).doReset(false);
            }
        }
    }

    private void updateSettingsDownloaderForVehicle() {
        block4: for (String id : this.downloadWorkerList.keySet().toArray(new String[0])) {
            try {
                Vector sUri;
                LogsDownloaderWorker dw = this.getDownloadWorker(id);
                ImcSystem sys3 = ImcSystemsHolder.lookupSystemByName((String)id);
                if (dw == null || sys3 == null) {
                    NeptusLog.pub().warn((Object)("Not able to get IMC System for '" + id + "'"));
                    continue;
                }
                dw.setHost(sys3.getHostAddress());
                dw.setLogLabel(id.toLowerCase());
                int idx = -1;
                for (int i = 0; i < this.tabbledPane.getTabCount(); ++i) {
                    try {
                        if (!this.tabbledPane.getComponentAt(i).equals(dw.getContentPanel())) continue;
                        idx = i;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (idx >= 0) {
                    this.tabbledPane.setTitleAt(idx, dw.getLogLabel());
                }
                if ((sUri = sys3.getServiceProvided("ftp", "")).size() > 0) {
                    dw.setHost(((URI)sUri.get(0)).getHost());
                    dw.setPort(((URI)sUri.get(0)).getPort() <= 0 ? 21 : ((URI)sUri.get(0)).getPort());
                }
                if (sUri.size() <= 1) continue;
                for (URI uriT : sUri) {
                    if (!NetworkInterfacesUtil.testForReachability((String)uriT.getHost(), (int)uriT.getPort())) continue;
                    dw.setHost(uriT.getHost());
                    dw.setPort(uriT.getPort() <= 0 ? 21 : uriT.getPort());
                    continue block4;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String[] getObservedMessages() {
        return new String[]{"LoggingControl"};
    }

    public void messageArrived(IMCMessage message) {
        String op = message.getString("op");
        if (op == null) {
            return;
        }
        Operation operation = Operation.valueOf(op);
        String name = message.getString("name");
        this.revokeScheduleCurLogFromVehicle();
        this.updateState(operation, name);
    }

    private TimerTask createTimerTaskUpdateLogList() {
        return new TimerTask(){

            @Override
            public void run() {
                for (String id : LoggingDownloader.this.downloadWorkerList.keySet().toArray(new String[0])) {
                    LogsDownloaderWorker dw = LoggingDownloader.this.getDownloadWorker(id);
                    if (dw == null || !dw.validateConfiguration()) continue;
                    dw.doUpdateListFromServer();
                }
                LoggingDownloader.this.ttaskUpdateLogList = null;
            }
        };
    }

    private TimerTask createTimerTaskUpdateLogName() {
        return new TimerTask(){

            @Override
            public void run() {
                if (LoggingDownloader.this.getConsole().getMainSystem() != null) {
                    LoggingDownloader.this.send(IMCDefinition.getInstance().create("LoggingControl", new Object[]{"op", Operation.REQUEST_CURRENT_NAME.type()}));
                }
                LoggingDownloader.this.ttaskUpdateLogName = null;
            }
        };
    }

    private boolean scheduleDownloadListFromServer() {
        if (System.currentTimeMillis() - this.timeRequestLogList > 800L) {
            this.timeRequestLogList = System.currentTimeMillis();
            if (this.timer == null) {
                this.timer = new Timer(LoggingDownloader.class.getName() + ": ScheduleDownloadListFromServer");
            }
            this.ttaskUpdateLogList = this.createTimerTaskUpdateLogList();
            this.timer.schedule(this.ttaskUpdateLogList, 500L);
            return true;
        }
        return false;
    }

    private void scheduleCurLogFromVehicle() {
        if (this.ttaskUpdateLogName == null) {
            if (this.timer == null) {
                this.timer = new Timer(LoggingDownloader.class.getName() + ": ScheduleCurLogFromVehicle");
            }
            this.ttaskUpdateLogName = this.createTimerTaskUpdateLogName();
            this.timer.schedule(this.ttaskUpdateLogName, 1000L);
        }
    }

    private void revokeScheduleCurLogFromVehicle() {
        if (this.ttaskUpdateLogName != null) {
            this.ttaskUpdateLogName.cancel();
            this.ttaskUpdateLogName = null;
        }
    }

    protected void updateState(Operation operation, String argument) {
        switch (operation) {
            case STOPPED: {
                this.button.setSelected(false);
                this.button.setEnabled(true);
                this.button.setToolTipText(I18n.text((String)"Log: (stopped)"));
                break;
            }
            case STARTED: {
                if (argument != null && !argument.equals(this.currentName)) {
                    this.currentName = argument;
                }
                this.button.setSelected(true);
                this.button.setEnabled(true);
                this.button.setToolTipText(I18n.textf((String)"Log: %logname", (Object[])new Object[]{argument}));
                break;
            }
            case CURRENT_NAME: {
                if (argument.equals("")) {
                    this.button.setSelected(false);
                    this.button.setEnabled(true);
                    this.button.setToolTipText(I18n.text((String)"Log: (stopped)"));
                    break;
                }
                this.button.setSelected(true);
                this.button.setEnabled(true);
                this.button.setToolTipText(I18n.textf((String)"Log: %logname", (Object[])new Object[]{argument}));
                break;
            }
        }
        if (this.automaticUpdateLogsFromRemoteSystems) {
            this.scheduleDownloadListFromServer();
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.button.setEnabled(false);
        this.button.setToolTipText(I18n.text((String)"Log: (updating)"));
        this.tabbledPane.setSelectedComponent((Component)this.getDownloadWorker().getContentPanel());
        this.resetDownloaderForVehicle(evt.getCurrent());
    }

    public long millisBetweenUpdates() {
        return this.updatePeriodSeconds * 1000;
    }

    public boolean update() {
        this.updateSettingsDownloaderForVehicle();
        this.scheduleCurLogFromVehicle();
        this.updateLogsState();
        return true;
    }

    public void propertiesChanged() {
        this.button.setEnabled(this.changeLogNameEnabled);
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GuiUtils.setLookAndFeel();
        IMCMessage msg = IMCDefinition.getInstance().create("LoggingControl", new Object[]{"op", Operation.STOPPED.type()});
        Operation op = Operation.valueOf(msg.getString("op"));
        NeptusLog.pub().info((Object)("<###> " + (Object)((Object)op)));
        GuiUtils.testFrame((JComponent)((Object)new LoggingDownloader(null)));
    }

    class BarPainter
    implements Painter<JXButton> {
        double value = 0.0;
        ColorMap colormap = new InterpolationColorMap("RedYellowGreen", new double[]{0.0, 0.9999999999, 1.0}, new Color[]{Color.red, Color.yellow, Color.green});

        BarPainter() {
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        }

        public ColorMap getColormap() {
            return this.colormap;
        }

        public void setColormap(ColorMap colormap) {
            this.colormap = colormap;
        }

        public void paint(Graphics2D g, JXButton b, int widthI, int heightI) {
            Color color = this.colormap.getColor(this.value);
            double max = b.getWidth() - 4;
            double width = max * this.value;
            if (this.value == 0.0) {
                width = max;
            }
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(2.0, 2.0, width, b.getHeight() - 4, 4.0, 4.0);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(new LinearGradientPaint(0.0f, 0.0f, LoggingDownloader.this.getWidth(), LoggingDownloader.this.getHeight(), new float[]{0.0f, 1.0f}, new Color[]{color, color.darker()}));
            g.fill(rect);
        }
    }

    public static enum Operation {
        REQUEST_START(0),
        STARTED(1),
        REQUEST_STOP(2),
        STOPPED(3),
        REQUEST_CURRENT_NAME(4),
        CURRENT_NAME(5),
        UNKNOWN(-1);

        private final int c;

        private Operation(int c) {
            this.c = c;
        }

        public int type() {
            return this.c;
        }
    }
}

