/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LogBookControl;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.plugins.logs.LogBookHistory;
import pt.lsts.neptus.util.GuiUtils;

public class MultiSystemHistory
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JTabbedPane tabs = new JTabbedPane();
    protected LinkedHashMap<String, LogBookHistory> histories = new LinkedHashMap();
    protected LinkedHashMap<String, JList<HistoryMessage>> lists = new LinkedHashMap();

    public MultiSystemHistory() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, (Object)"Center");
    }

    public Collection<HistoryMessage> add(Collection<HistoryMessage> msgs, String src) {
        if (!this.histories.containsKey(src)) {
            this.createHistory(src);
        }
        Collection<HistoryMessage> ret = this.histories.get(src).add(msgs);
        int size = this.lists.get(src).getModel().getSize() - 1;
        if (!ret.isEmpty() && this.isDisplayable()) {
            this.lists.get(src).ensureIndexIsVisible(size);
        }
        return ret;
    }

    public void removeHistory(String src) {
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!this.tabs.getTitleAt(i).equals(src)) continue;
            this.tabs.removeTabAt(i);
            return;
        }
        this.histories.remove(src);
        this.lists.remove(src);
    }

    public JList<HistoryMessage> createHistory(String src) {
        final LogBookHistory hist = new LogBookHistory(src);
        this.histories.put(src, hist);
        final JList<HistoryMessage> list = new JList<HistoryMessage>(hist);
        list.setCellRenderer(hist);
        this.tabs.addTab(src, new JScrollPane(list));
        this.lists.put(src, list);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(I18n.text((String)"Clear")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            hist.clear();
                        }
                    });
                    popup.add(I18n.text((String)"Refresh")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LogBookControl ctrl = new LogBookControl();
                            ctrl.setCommand(LogBookControl.COMMAND.GET);
                            ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)ctrl, hist.sysname);
                        }
                    });
                    final int index = list.locationToIndex(arg0.getPoint());
                    if (index != -1) {
                        popup.add(I18n.text((String)"Copy entry to clipboard")).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String text = ((HistoryMessage)list.getModel().getElementAt(index)).toString();
                                ClipboardOwner owner = new ClipboardOwner(){

                                    @Override
                                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                    }
                                };
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), owner);
                            }
                        });
                    }
                    if (list.getModel().getSize() > 0) {
                        popup.add(I18n.text((String)"Copy history to clipboard")).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String text = "";
                                for (int i = 0; i < list.getModel().getSize(); ++i) {
                                    text = text + list.getModel().getElementAt(i) + "\n";
                                }
                                ClipboardOwner owner = new ClipboardOwner(){

                                    @Override
                                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                    }
                                };
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), owner);
                            }
                        });
                    }
                    popup.show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
                }
            }
        });
        this.invalidate();
        this.revalidate();
        return list;
    }

    public void add(HistoryMessage m, String src) {
        if (!this.histories.containsKey(src)) {
            this.createHistory(src);
        }
        this.histories.get(src).add(m);
        int size = this.lists.get(src).getModel().getSize() - 1;
        if (size > 0) {
            this.lists.get(src).ensureIndexIsVisible(size);
        }
    }

    public static void main(String[] args) throws Exception {
        MultiSystemHistory hist = new MultiSystemHistory();
        GuiUtils.testFrame((JComponent)hist);
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(300L);
            hist.add(new HistoryMessage(System.currentTimeMillis(), "teste1", "ctx", true, HistoryMessage.msg_type.error), "lauv-seacon-1");
            Thread.sleep(300L);
            hist.add(new HistoryMessage(System.currentTimeMillis(), "teste2", "ctx", true, HistoryMessage.msg_type.info), "lauv-seacon-1");
            Thread.sleep(300L);
            hist.add(new HistoryMessage(System.currentTimeMillis() - 5000L, "teste3", "ctx", true, HistoryMessage.msg_type.critical), "lauv-seacon-2");
            Thread.sleep(300L);
            hist.add(new HistoryMessage(System.currentTimeMillis() - 5000L, "teste3", "ctx", true, HistoryMessage.msg_type.warning), "lauv-seacon-1");
        }
    }
}

