/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfMessageLogger;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.ConsoleScript;
import pt.lsts.neptus.console.plugins.LogBookPanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.conf.StringProperty;

@PluginDescription(author="zp", name="Quick Logbook Panel")
public class QuickLogger
extends ConsolePanel
implements ConfigurationListener {
    private ConsoleScript conScript = new ConsoleScript();
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Log Shortcuts", description="Enter the shortcuts as <Text to display>,<Text to log>(,<icon filename>)?")
    public StringProperty shortcuts = new StringProperty("Mission Start,Mission Started\nScript Example,\"VehicleStatePos.ref=\"+$(VehicleStatePos.ref)");
    @NeptusProperty(name="Number of Rows", description="Number of rows in the panel. 0 for infinite.")
    public int numRows = 0;
    @NeptusProperty(name="Number of Columns", description="Number of columns in the panel. 0 for infinite.")
    public int numCols = 1;
    protected IMCMessage logMsg = IMCDefinition.getInstance().create("LogBookEntry", new Object[0]);

    public QuickLogger(ConsoleLayout console) {
        super(console);
        this.logMsg.setValue("context", (Object)(System.getProperty("user.name") + " quick log"));
        this.logMsg.setValue("type", (Object)0);
        this.propertiesChanged();
    }

    public void propertiesChanged() {
        String[] lines;
        this.removeAll();
        this.setLayout(new GridLayout(this.numRows, this.numCols));
        for (String s : lines = this.shortcuts.toString().split("\n")) {
            String[] parts = s.split(",");
            final String logText = parts[1].trim();
            JButton btn = new JButton(parts[0].trim());
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String txt;
                    try {
                        QuickLogger.this.conScript.setScript(logText);
                        txt = QuickLogger.this.conScript.evaluate(QuickLogger.this.getState()).toString();
                    }
                    catch (Exception ex) {
                        txt = logText;
                        ex.printStackTrace();
                    }
                    QuickLogger.this.logMsg.setValue("htime", (Object)DateTimeUtil.timeStampSeconds());
                    QuickLogger.this.logMsg.setValue("text", (Object)txt);
                    try {
                        LsfMessageLogger.log((IMCMessage)QuickLogger.this.logMsg);
                    }
                    catch (Exception ex) {
                        NeptusLog.pub().error((Object)ex);
                    }
                    LogBookPanel.logPlain((String)txt);
                }
            });
            this.add(btn);
        }
        this.invalidate();
        this.revalidate();
        this.validate();
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(QuickLogger.class);
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

