/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.logs;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LogBookControl;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.logs.HistoryMessage;
import pt.lsts.neptus.plugins.logs.HistoryPanel;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="Remote History", icon="pt/lsts/neptus/plugins/logs/queue.png", documentation="entity-state/remotehistory.html")
public class RemoteHistory
extends ConsolePanel
implements NeptusMessageListener,
MainVehicleChangeListener {
    private final JMenuItem menuItem;
    private final JDialog dialog;
    protected HistoryPanel p = new HistoryPanel(null, true);
    protected boolean hasNewMessages = false;
    protected Vector<HistoryMessage> history = new Vector();
    protected AbstractAction viewEvents = new AbstractAction(I18n.text((String)this.getName()), ImageUtils.getScaledIcon((ImageIcon)this.getImageIcon(), (int)16, (int)16)){

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 1) != 0) {
                RemoteHistory.this.clearHistory();
            }
            LogBookControl getmsgs = new LogBookControl();
            getmsgs.setCommand(LogBookControl.COMMAND.GET);
            RemoteHistory.this.send((IMCMessage)getmsgs);
            LogBookControl geterr = new LogBookControl();
            geterr.setCommand(LogBookControl.COMMAND.GET_ERR);
            RemoteHistory.this.send((IMCMessage)geterr);
            RemoteHistory.this.p.setMessages(RemoteHistory.this.history);
            RemoteHistory.this.dialog.setVisible(!RemoteHistory.this.dialog.isVisible());
        }
    };

    public RemoteHistory(ConsoleLayout console) {
        super(console);
        this.removeAll();
        this.dialog = new JDialog((Frame)console);
        this.dialog.setTitle(I18n.text((String)"Remote History"));
        this.dialog.setIconImage(ImageUtils.getImage((String)PluginUtils.getPluginIcon(RemoteHistory.class)));
        this.dialog.setSize(700, 300);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.add(this.p);
        JRootPane rootPane = this.dialog.getRootPane();
        InputMap globalInputMap = rootPane.getInputMap(2);
        globalInputMap.put(KeyStroke.getKeyStroke(82, 2, true), "pressed");
        rootPane.getActionMap().put("pressed", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteHistory.this.dialog.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        ToolbarButton btn = new ToolbarButton(this.viewEvents);
        this.add((Component)btn, "Center");
        this.menuItem = new JMenuItem(this.viewEvents);
        this.menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2, true));
    }

    public void initSubPanel() {
        this.p.console = this.getConsole();
        JMenu menu = this.getConsole().getOrCreateJMenu(new String[]{I18n.text((String)"View")});
        menu.add(this.menuItem);
    }

    public void cleanSubPanel() {
        if (this.dialog.isVisible()) {
            this.dialog.setVisible(false);
        }
        if (this.menuItem != null) {
            JMenu menu = this.getConsole().getOrCreateJMenu(new String[]{I18n.text((String)"View")});
            menu.remove(this.menuItem);
        }
    }

    protected void clearHistory() {
        this.p.myMessages.clear();
        this.p.mainPanel.removeAll();
        this.history.clear();
        this.viewEvents.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/queue.png"));
        this.invalidate();
    }

    public String[] getObservedMessages() {
        return new String[]{"LogBookControl", "LogBookEntry"};
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange e) {
        this.clearHistory();
    }

    protected HistoryMessage getMessage(IMCMessage logBookEntry) {
        HistoryMessage msg = new HistoryMessage();
        msg.timestamp = logBookEntry.getTimestampMillis();
        msg.text = logBookEntry.getString("text");
        msg.context = logBookEntry.getString("context");
        String type = logBookEntry.getString("type");
        if (type.equals("INFO")) {
            msg.type = HistoryMessage.msg_type.info;
        } else if (type.equals("WARNING")) {
            msg.type = HistoryMessage.msg_type.warning;
        } else if (type.equals("ERROR")) {
            msg.type = HistoryMessage.msg_type.error;
        } else if (type.equals("CRITICAL")) {
            msg.type = HistoryMessage.msg_type.critical;
        } else if (type.equals("DEBUG")) {
            msg.type = HistoryMessage.msg_type.debug;
        }
        return msg;
    }

    public void messageArrived(IMCMessage message) {
        if (message.getMgid() == 103) {
            HistoryMessage msg = this.getMessage(message);
            msg.assynchronous = true;
            Vector<HistoryMessage> messages = new Vector<HistoryMessage>();
            messages.add(msg);
            this.p.setMessages(messages);
            return;
        }
        if (message.getMgid() == 104) {
            if (message.getAsString("command").equals("STORE")) {
                IMCMessage inline = message.getMessage("msg");
                HistoryMessage msg = this.getMessage(inline);
                msg.assynchronous = true;
                this.history.add(msg);
                Vector<HistoryMessage> tmp = new Vector<HistoryMessage>();
                tmp.add(msg);
                this.p.setMessages(tmp);
                this.viewEvents.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/queue2.png"));
            } else {
                long lastTimeStamp = 0L;
                for (IMCMessage pivot = message.getMessage("msg"); pivot != null; pivot = pivot.getMessage("next")) {
                    IMCMessage hist = pivot.getMessage("msg");
                    HistoryMessage msg = this.getMessage(hist);
                    msg.assynchronous = false;
                    this.history.add(msg);
                    lastTimeStamp = msg.timestamp;
                }
                Vector<HistoryMessage> toRemove = new Vector<HistoryMessage>();
                for (HistoryMessage m : this.history) {
                    if (!m.assynchronous || m.timestamp >= lastTimeStamp) continue;
                    toRemove.add(m);
                }
                this.history.removeAll(toRemove);
                this.p.setMessages(this.history);
                this.viewEvents.putValue("SmallIcon", ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/logs/queue.png"));
            }
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        ConsoleLayout layout = ConsoleParse.testSubPanel(RemoteHistory.class);
        layout.setMainSystem("lauv-seacon-2");
    }
}

