/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.buffer;

import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.external.buffer.EAIAddRoute;
import org.web3d.vrml.scripting.external.buffer.EAICreateVrmlFromUrl;
import org.web3d.vrml.scripting.external.buffer.EAILoadURL;
import org.web3d.vrml.scripting.external.buffer.EAIRemoveRoute;
import org.web3d.vrml.scripting.external.buffer.EAIReplaceWorld;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.NodeRealizationProcessor;
import org.web3d.vrml.scripting.external.buffer.SAIRealizeNode;

public class ExternalEventQueue
implements ExternalView,
NodeRealizationProcessor {
    static final int INITIAL_EVENT_QUEUE_SIZE = 20;
    private HashSet conglomerativeEvents;
    private HashSet realizingNodes;
    public Object eventLock = new Object();
    private boolean queueing;
    protected ErrorReporter errorReporter;
    ObjectArray eventQueue = new ObjectArray(20);
    ObjectArray waitingQueue;
    ObjectArray eventsInProcessing;

    public ExternalEventQueue(ErrorReporter errorReporter) {
        this.conglomerativeEvents = new HashSet();
        this.realizingNodes = new HashSet();
        this.waitingQueue = new ObjectArray(20);
        this.eventsInProcessing = new ObjectArray(20);
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void beginUpdate() {
        this.queueing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.queueing) {
                this.queueing = false;
                this.waitingQueue.addAll(this.eventQueue);
                this.eventQueue.clear();
                this.conglomerativeEvents.clear();
            }
        }
    }

    public ExternalEvent getLast(ExternalEvent externalEvent) {
        return (ExternalEvent)this.conglomerativeEvents.get(externalEvent);
    }

    public void postAddRoute(VRML97CommonBrowser vRML97CommonBrowser, BrowserCore browserCore, VRMLNodeType vRMLNodeType, String string, VRMLNodeType vRMLNodeType2, String string2) {
        this.processEvent(new EAIAddRoute(vRML97CommonBrowser, browserCore, vRMLNodeType, string, vRMLNodeType2, string2));
    }

    public void postCreateVrmlFromURL(VRML97CommonBrowser vRML97CommonBrowser, String[] stringArray, VRMLNodeType vRMLNodeType, String string) {
        new EAICreateVrmlFromUrl(vRML97CommonBrowser, stringArray, vRMLNodeType, string).doEvent();
    }

    public void postLoadURL(VRML97CommonBrowser vRML97CommonBrowser, String[] stringArray, String[] stringArray2) {
        new EAILoadURL(vRML97CommonBrowser, stringArray, stringArray2).doEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRealizeNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType == null) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.isNodeRealized(vRMLNodeType)) {
                this.realizingNodes.add(vRMLNodeType);
                this.processEvent(new SAIRealizeNode(vRMLNodeType, this));
            }
        }
    }

    public void postRemoveRoute(VRML97CommonBrowser vRML97CommonBrowser, BrowserCore browserCore, VRMLNodeType vRMLNodeType, String string, VRMLNodeType vRMLNodeType2, String string2) {
        this.processEvent(new EAIRemoveRoute(vRML97CommonBrowser, browserCore, vRMLNodeType, string, vRMLNodeType2, string2));
    }

    public void postReplaceWorld(VRML97CommonBrowser vRML97CommonBrowser, VRMLNodeType[] vRMLNodeTypeArray) {
        new EAIReplaceWorld(vRML97CommonBrowser, vRMLNodeTypeArray).doEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(ExternalEvent externalEvent) {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.queueing) {
                this.eventQueue.add(externalEvent);
                if (externalEvent.isConglomerating()) {
                    this.conglomerativeEvents.add(externalEvent);
                } else {
                    this.conglomerativeEvents.remove(externalEvent);
                }
            } else {
                this.waitingQueue.add(externalEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents() {
        Object object;
        Object object2 = this.eventLock;
        synchronized (object2) {
            object = this.waitingQueue;
            this.waitingQueue = this.eventsInProcessing;
            this.eventsInProcessing = object;
        }
        for (int i = 0; i < this.eventsInProcessing.size(); ++i) {
            object = (ExternalEvent)this.eventsInProcessing.get(i);
            try {
                object.doEvent();
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Error encountered processing buffered event of type " + object.getClass().getName() + ".", exception);
            }
        }
        this.eventsInProcessing.clear();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public boolean isNodeRealized(VRMLNodeType vRMLNodeType) {
        return vRMLNodeType.isSetupFinished() || this.realizingNodes.contains(vRMLNodeType);
    }

    public void markNodeRealized(VRMLNodeType vRMLNodeType) {
        if (!vRMLNodeType.isSetupFinished()) {
            this.realizingNodes.add(vRMLNodeType);
        }
    }

    public void markRealizationComplete(VRMLNodeType vRMLNodeType) {
        this.realizingNodes.remove(vRMLNodeType);
    }
}

