/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import java.util.Enumeration;
import java.util.Vector;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.BaseExternalEventAdapter;
import org.web3d.vrml.scripting.external.buffer.ExternalEventAdapter;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBufferReclaimer;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterThreadPool;
import org.web3d.vrml.scripting.external.eai.EAIFieldFactory;
import vrml.eai.event.VrmlEvent;
import vrml.eai.event.VrmlEventListener;
import vrml.eai.field.EventOut;

class BufferedEAIEventAdapter
extends BaseExternalEventAdapter
implements ExternalEventAdapter,
VRMLNodeListener,
ExternalOutputBufferReclaimer {
    EAIFieldFactory theFieldFactory;
    EAIEventAdapterThreadPool thePool;

    BufferedEAIEventAdapter(EAIFieldFactory eAIFieldFactory, VRMLNodeType vRMLNodeType, EAIEventAdapterThreadPool eAIEventAdapterThreadPool, VRMLClock vRMLClock) {
        super(vRMLNodeType, vRMLClock);
        this.theFieldFactory = eAIFieldFactory;
        this.thePool = eAIEventAdapterThreadPool;
    }

    public synchronized void generateBroadcast(int n, double d) {
        Vector vector = this.getListeners(n);
        if (vector != null) {
            Object object;
            try {
                object = this.parentNode.getUserData(n);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Unexpectedly bad field ID " + n + " for " + this.parentNode + " in event broadcast.");
            }
            Enumeration enumeration = ((Vector)vector.clone()).elements();
            while (enumeration.hasMoreElements()) {
                ExternalOutputBuffer externalOutputBuffer;
                if (this.buffers[n].size() != 0) {
                    externalOutputBuffer = (ExternalOutputBuffer)this.buffers[n].removeFirst();
                    externalOutputBuffer.initialize(this.parentNode, n);
                    externalOutputBuffer.loadOutputValue();
                } else {
                    externalOutputBuffer = (ExternalOutputBuffer)((Object)this.theFieldFactory.getStoredEventOut(this.parentNode, n, this.parentNode.getFieldDeclaration(n).getName()));
                }
                VrmlEvent vrmlEvent = new VrmlEvent((EventOut)((Object)externalOutputBuffer), d, object);
                VrmlEventListener vrmlEventListener = (VrmlEventListener)enumeration.nextElement();
                this.thePool.sendEvent(vrmlEventListener, vrmlEvent, externalOutputBuffer, n, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimEventOutBuffer(ExternalOutputBuffer externalOutputBuffer, int n) {
        externalOutputBuffer.reset();
        BufferedEAIEventAdapter bufferedEAIEventAdapter = this;
        synchronized (bufferedEAIEventAdapter) {
            this.buffers[n].addLast(externalOutputBuffer);
        }
    }
}

