/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import java.util.Hashtable;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEventAdapter;
import org.web3d.vrml.scripting.external.eai.BufferedEAIEventAdapter;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterThreadPool;
import org.web3d.vrml.scripting.external.eai.EAIFieldFactory;

class BufferedMappingEAIEventAdapterFactory
implements EAIEventAdapterFactory {
    Hashtable adapterTable = new Hashtable();
    EAIFieldFactory theFieldFactory;
    EAIEventAdapterThreadPool thePool;
    VRMLClock timeClock;

    BufferedMappingEAIEventAdapterFactory(int n, VRMLClock vRMLClock) {
        this.thePool = new EAIEventAdapterThreadPool(n);
        this.timeClock = vRMLClock;
    }

    public ExternalEventAdapter getAdapter(VRMLNodeType vRMLNodeType) {
        BufferedEAIEventAdapter bufferedEAIEventAdapter = (BufferedEAIEventAdapter)this.adapterTable.get(vRMLNodeType);
        if (bufferedEAIEventAdapter == null) {
            bufferedEAIEventAdapter = new BufferedEAIEventAdapter(this.theFieldFactory, vRMLNodeType, this.thePool, this.timeClock);
            this.adapterTable.put(vRMLNodeType, bufferedEAIEventAdapter);
            vRMLNodeType.addNodeListener(bufferedEAIEventAdapter);
        }
        return bufferedEAIEventAdapter;
    }

    public void setFieldFactory(EAIFieldFactory eAIFieldFactory) {
        this.theFieldFactory = eAIFieldFactory;
    }

    public void shutdown() {
        this.thePool.shutdown();
    }
}

