/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.BufferedMappingEAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.NonMappingVRMLNodeFactory;
import org.web3d.vrml.scripting.external.eai.SimpleEAIFieldFactory;
import org.web3d.vrml.scripting.external.eai.VRMLNodeFactory;
import vrml.eai.Browser;
import vrml.eai.InvalidBrowserException;
import vrml.eai.InvalidNodeException;
import vrml.eai.InvalidURLException;
import vrml.eai.InvalidVrmlException;
import vrml.eai.Node;
import vrml.eai.URLUnavailableException;
import vrml.eai.event.BrowserEvent;
import vrml.eai.event.BrowserListener;
import vrml.eai.field.InvalidEventInException;
import vrml.eai.field.InvalidEventOutException;

public class EAIBrowser
implements Browser,
BrowserCoreListener {
    EAIEventAdapterFactory eventAdapterFactory;
    static final String browserVersion = "$Revision: 1.18 $";
    Vector browserListeners;
    static final String browserName = "EAI Browser";
    static final String INITIAL_WORLD = "#VRML V2.0 utf8\nGroup{}\n";
    BrowserCore theBrowserCore;
    VRML97CommonBrowser theBrowserImpl;
    ErrorReporter theErrorReporter;
    ExternalEventQueue theEventQueue;
    VRMLNodeFactory theNodeFactory;

    public EAIBrowser(BrowserCore browserCore, VRML97CommonBrowser vRML97CommonBrowser, ExternalEventQueue externalEventQueue, ErrorReporter errorReporter) {
        if (browserCore == null) {
            throw new IllegalArgumentException("Null BrowserCore");
        }
        if (vRML97CommonBrowser == null) {
            throw new IllegalArgumentException("Null CommonBrowser");
        }
        this.theBrowserCore = browserCore;
        this.theBrowserImpl = vRML97CommonBrowser;
        this.theEventQueue = externalEventQueue;
        this.browserListeners = new Vector();
        browserCore.addCoreListener(this);
        SimpleEAIFieldFactory simpleEAIFieldFactory = new SimpleEAIFieldFactory(this.theEventQueue);
        this.eventAdapterFactory = new BufferedMappingEAIEventAdapterFactory(2, browserCore.getVRMLClock());
        this.theNodeFactory = new NonMappingVRMLNodeFactory(simpleEAIFieldFactory);
        this.eventAdapterFactory.setFieldFactory(simpleEAIFieldFactory);
        simpleEAIFieldFactory.setNodeFactory(this.theNodeFactory);
        simpleEAIFieldFactory.setEAIEventAdapterFactory(this.eventAdapterFactory);
        this.theErrorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public String getName() throws InvalidBrowserException {
        return browserName;
    }

    public String getVersion() throws InvalidBrowserException {
        return browserVersion;
    }

    public float getCurrentSpeed() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        return this.theBrowserImpl.getCurrentSpeed();
    }

    public float getCurrentFrameRate() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        return this.theBrowserImpl.getCurrentFrameRate();
    }

    public String getWorldURL() throws InvalidBrowserException, URLUnavailableException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        return this.theBrowserImpl.getWorldURL();
    }

    public void replaceWorld(Node[] nodeArray) throws IllegalArgumentException, InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        VRMLNodeType[] vRMLNodeTypeArray = null;
        if (nodeArray != null) {
            vRMLNodeTypeArray = new VRMLNodeType[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                vRMLNodeTypeArray[i] = this.theNodeFactory.getVRMLNode(nodeArray[i]);
            }
        }
        this.theEventQueue.postReplaceWorld(this.theBrowserImpl, vRMLNodeTypeArray);
    }

    public void loadURL(String[] stringArray, String[] stringArray2) throws InvalidBrowserException, InvalidURLException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.theEventQueue.postLoadURL(this.theBrowserImpl, stringArray, stringArray2);
    }

    public void setDescription(String string) throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.theBrowserImpl.setDescription(string);
    }

    public Node[] createVrmlFromString(String string) throws InvalidBrowserException, InvalidVrmlException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        Node[] nodeArray = null;
        try {
            VRMLNodeType[] vRMLNodeTypeArray = this.theBrowserImpl.createVrmlFromString(string, null);
            if (vRMLNodeTypeArray != null) {
                nodeArray = new Node[vRMLNodeTypeArray.length];
                int n = 0;
                for (n = 0; n < nodeArray.length; ++n) {
                    nodeArray[n] = this.theNodeFactory.getEAINode(vRMLNodeTypeArray[n]);
                }
            }
        }
        catch (VRMLParseException vRMLParseException) {
            throw new InvalidVrmlException(vRMLParseException.getMessage());
        }
        catch (InvalidNodeTypeException invalidNodeTypeException) {
            throw new InvalidVrmlException(invalidNodeTypeException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return nodeArray;
    }

    public void createVrmlFromURL(String[] stringArray, Node node, String string) throws InvalidBrowserException, InvalidNodeException, InvalidURLException, InvalidEventInException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        if (node == null) {
            throw new InvalidNodeException("Node cannot be null.");
        }
        VRMLNodeType vRMLNodeType = this.theNodeFactory.getVRMLNode(node);
        if (vRMLNodeType == null) {
            throw new InvalidNodeException("Node was disposed.");
        }
        this.theEventQueue.postCreateVrmlFromURL(this.theBrowserImpl, stringArray, vRMLNodeType, string);
    }

    public Node getNode(String string) throws InvalidNodeException, InvalidBrowserException, URLUnavailableException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        Map map = this.theBrowserCore.getDEFMappings();
        System.out.println("DEF Map Size: " + map.size());
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.theBrowserCore.getDEFMappings().get(string);
        if (vRMLNodeType != null) {
            return this.theNodeFactory.getEAINode(vRMLNodeType);
        }
        throw new InvalidNodeException(string + " not found");
    }

    public void addRoute(Node node, String string, Node node2, String string2) throws InvalidBrowserException, InvalidEventOutException, InvalidEventInException, InvalidNodeException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        VRMLNodeType vRMLNodeType = this.theNodeFactory.getVRMLNode(node);
        VRMLNodeType vRMLNodeType2 = this.theNodeFactory.getVRMLNode(node2);
        this.theEventQueue.postAddRoute(this.theBrowserImpl, this.theBrowserCore, vRMLNodeType, string, vRMLNodeType2, string2);
    }

    public void deleteRoute(Node node, String string, Node node2, String string2) throws InvalidBrowserException, InvalidEventOutException, InvalidEventInException, InvalidNodeException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        VRMLNodeType vRMLNodeType = this.theNodeFactory.getVRMLNode(node);
        VRMLNodeType vRMLNodeType2 = this.theNodeFactory.getVRMLNode(node2);
        this.theEventQueue.postRemoveRoute(this.theBrowserImpl, this.theBrowserCore, vRMLNodeType, string, vRMLNodeType2, string2);
    }

    public void beginUpdate() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.theEventQueue.beginUpdate();
    }

    public void endUpdate() throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.theEventQueue.endUpdate();
    }

    public void addBrowserListener(BrowserListener browserListener) throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        if (browserListener != null && !this.browserListeners.contains(browserListener)) {
            this.browserListeners.addElement(browserListener);
        }
    }

    public void removeBrowserListener(BrowserListener browserListener) throws InvalidBrowserException {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.browserListeners.removeElement(browserListener);
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        this.broadcastEvent(new BrowserEvent(this, 0));
    }

    public void urlLoadFailed(String string) {
        this.theErrorReporter.messageReport("Received urlLoadFailed message:" + string);
        this.broadcastEvent(new BrowserEvent(this, 2));
    }

    public void browserShutdown() {
        this.broadcastEvent(new BrowserEvent(this, 1));
    }

    public void browserDisposed() {
    }

    void broadcastEvent(BrowserEvent browserEvent) {
        Enumeration enumeration = this.browserListeners.elements();
        while (enumeration.hasMoreElements()) {
            BrowserListener browserListener = (BrowserListener)enumeration.nextElement();
            this.createNotifierThread(new EventNotifier(browserListener, browserEvent)).start();
        }
    }

    Thread createNotifierThread(Runnable runnable) {
        return (Thread)AccessController.doPrivileged(new CreateThreadAction(runnable));
    }

    public void dispose() {
        if (this.theBrowserImpl == null) {
            throw new InvalidBrowserException();
        }
        this.endUpdate();
        try {
            this.theBrowserImpl.replaceWorld(this.theBrowserImpl.createVrmlFromString(INITIAL_WORLD, this.theBrowserCore.getWorldExecutionSpace()));
        }
        catch (Exception exception) {
            this.theErrorReporter.fatalErrorReport("Error initializing system.", exception);
        }
        this.theBrowserImpl = null;
        this.theBrowserCore = null;
        this.eventAdapterFactory.shutdown();
        this.do_shutdown();
    }

    void do_shutdown() {
        this.broadcastEvent(new BrowserEvent(this, 1));
    }

    public void initializeWorld() {
    }

    class CreateThreadAction
    implements PrivilegedAction {
        Runnable r;

        CreateThreadAction(Runnable runnable) {
            this.r = runnable;
        }

        public Object run() {
            return new Thread(this.r);
        }
    }

    private class EventNotifier
    implements Runnable {
        private BrowserListener theListener;
        private BrowserEvent theEvent;

        EventNotifier(BrowserListener browserListener, BrowserEvent browserEvent) {
            this.theListener = browserListener;
            this.theEvent = browserEvent;
        }

        public void run() {
            this.theListener.browserChanged(this.theEvent);
        }
    }
}

