/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.web3d.util.BlockingQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBufferReclaimer;
import vrml.eai.event.VrmlEvent;
import vrml.eai.event.VrmlEventListener;

class EAIEventAdapterThreadPool {
    BroadcastThread[] threads;
    BlockingQueue theSourceQueue;
    BlockingQueue theRecyclingQueue;

    EAIEventAdapterThreadPool(int n) {
        this.threads = new BroadcastThread[n];
        this.theSourceQueue = new BlockingQueue();
        this.theRecyclingQueue = new BlockingQueue();
        while (n-- > 0) {
            this.threads[n] = this.createThread(this.theSourceQueue, this.theRecyclingQueue);
        }
    }

    BroadcastThread createThread(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
        return (BroadcastThread)AccessController.doPrivileged(new CreateBroadcastThreadAction(blockingQueue, blockingQueue2));
    }

    void sendEvent(VrmlEventListener vrmlEventListener, VrmlEvent vrmlEvent, ExternalOutputBuffer externalOutputBuffer, int n, ExternalOutputBufferReclaimer externalOutputBufferReclaimer) {
        if (this.theRecyclingQueue == null) {
            return;
        }
        EventRecord eventRecord = (EventRecord)this.theRecyclingQueue.peekNext();
        eventRecord = eventRecord == null ? new EventRecord() : (EventRecord)this.theRecyclingQueue.getNext();
        eventRecord.load(vrmlEventListener, vrmlEvent, externalOutputBuffer, n, externalOutputBufferReclaimer);
        this.theSourceQueue.add(eventRecord);
    }

    void shutdown() {
        int n;
        for (n = 0; n < this.threads.length; ++n) {
            this.threads[n].shutdown();
        }
        this.theSourceQueue.purge();
        this.theRecyclingQueue = null;
        for (n = 0; n < this.threads.length; ++n) {
            this.theSourceQueue.add(null);
        }
    }

    class CreateBroadcastThreadAction
    implements PrivilegedAction {
        BlockingQueue theSourceQueue;
        BlockingQueue theRecyclingQueue;

        CreateBroadcastThreadAction(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
            this.theSourceQueue = blockingQueue;
            this.theRecyclingQueue = blockingQueue2;
        }

        public Object run() {
            return new BroadcastThread(this.theSourceQueue, this.theRecyclingQueue);
        }
    }

    class BroadcastThread
    extends Thread {
        boolean shouldStop;
        BlockingQueue theSourceQueue;
        BlockingQueue theRecyclingQueue;

        BroadcastThread(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
            this.theSourceQueue = blockingQueue;
            this.theRecyclingQueue = blockingQueue2;
            this.start();
        }

        public void run() {
            while (!this.shouldStop) {
                EventRecord eventRecord = (EventRecord)this.theSourceQueue.getNext();
                if (eventRecord == null) {
                    this.theRecyclingQueue = null;
                    return;
                }
                eventRecord.receiver.eventOutChanged(eventRecord.event);
                eventRecord.reclaimer.reclaimEventOutBuffer(eventRecord.buffer, eventRecord.tag);
                eventRecord.reset();
                this.theRecyclingQueue.add(eventRecord);
            }
            this.theRecyclingQueue = null;
        }

        void shutdown() {
            this.shouldStop = true;
        }
    }

    class EventRecord {
        VrmlEventListener receiver;
        VrmlEvent event;
        ExternalOutputBuffer buffer;
        int tag;
        ExternalOutputBufferReclaimer reclaimer;

        EventRecord() {
        }

        void load(VrmlEventListener vrmlEventListener, VrmlEvent vrmlEvent, ExternalOutputBuffer externalOutputBuffer, int n, ExternalOutputBufferReclaimer externalOutputBufferReclaimer) {
            this.receiver = vrmlEventListener;
            this.event = vrmlEvent;
            this.buffer = externalOutputBuffer;
            this.tag = n;
            this.reclaimer = externalOutputBufferReclaimer;
        }

        void reset() {
            this.receiver = null;
            this.event = null;
            this.buffer = null;
            this.reclaimer = null;
            this.tag = -1;
        }
    }
}

